# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_custom_domain_response_content import CreateCustomDomainResponseContent
from ..types.custom_domain_custom_client_ip_header import CustomDomainCustomClientIpHeader
from ..types.custom_domain_provisioning_type_enum import CustomDomainProvisioningTypeEnum
from ..types.custom_domain_tls_policy_enum import CustomDomainTlsPolicyEnum
from ..types.custom_domain_verification_method_enum import CustomDomainVerificationMethodEnum
from ..types.domain_metadata import DomainMetadata
from ..types.get_custom_domain_response_content import GetCustomDomainResponseContent
from ..types.list_custom_domains_response_content import ListCustomDomainsResponseContent
from ..types.test_custom_domain_response_content import TestCustomDomainResponseContent
from ..types.update_custom_domain_response_content import UpdateCustomDomainResponseContent
from ..types.verify_custom_domain_response_content import VerifyCustomDomainResponseContent
from .raw_client import AsyncRawCustomDomainsClient, RawCustomDomainsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomDomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomDomainsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        take: typing.Optional[int] = 50,
        from_: typing.Optional[str] = None,
        q: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListCustomDomainsResponseContent:
        """
        Retrieve details on <a href="https://auth0.com/docs/custom-domains">custom domains</a>.

        Parameters
        ----------
        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        q : typing.Optional[str]
            Query in <a href ="http://www.lucenetutorial.com/lucene-query-syntax.html">Lucene query string syntax</a>.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        sort : typing.Optional[str]
            Field to sort by. Only <code>domain:1</code> (ascending order by domain) is supported at this time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListCustomDomainsResponseContent
            Custom domains successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.list(
            take=1,
            from_="from",
            q="q",
            fields="fields",
            include_fields=True,
            sort="sort",
        )
        """
        _response = self._raw_client.list(
            take=take,
            from_=from_,
            q=q,
            fields=fields,
            include_fields=include_fields,
            sort=sort,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        domain: str,
        type: CustomDomainProvisioningTypeEnum,
        verification_method: typing.Optional[CustomDomainVerificationMethodEnum] = OMIT,
        tls_policy: typing.Optional[CustomDomainTlsPolicyEnum] = OMIT,
        custom_client_ip_header: typing.Optional[CustomDomainCustomClientIpHeader] = OMIT,
        domain_metadata: typing.Optional[DomainMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateCustomDomainResponseContent:
        """
        Create a new custom domain.

        Note: The custom domain will need to be verified before it will accept
        requests.

        Optional attributes that can be updated:

        - custom_client_ip_header
        - tls_policy


        TLS Policies:

        - recommended - for modern usage this includes TLS 1.2 only

        Parameters
        ----------
        domain : str
            Domain name.

        type : CustomDomainProvisioningTypeEnum

        verification_method : typing.Optional[CustomDomainVerificationMethodEnum]

        tls_policy : typing.Optional[CustomDomainTlsPolicyEnum]

        custom_client_ip_header : typing.Optional[CustomDomainCustomClientIpHeader]

        domain_metadata : typing.Optional[DomainMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateCustomDomainResponseContent
            Custom domain successfully created (verification is pending).

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.create(
            domain="domain",
            type="auth0_managed_certs",
        )
        """
        _response = self._raw_client.create(
            domain=domain,
            type=type,
            verification_method=verification_method,
            tls_policy=tls_policy,
            custom_client_ip_header=custom_client_ip_header,
            domain_metadata=domain_metadata,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetCustomDomainResponseContent:
        """
        Retrieve a custom domain configuration and status.

        Parameters
        ----------
        id : str
            ID of the custom domain to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomDomainResponseContent
            Custom domain successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a custom domain and stop serving requests for it.

        Parameters
        ----------
        id : str
            ID of the custom domain to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        tls_policy: typing.Optional[CustomDomainTlsPolicyEnum] = OMIT,
        custom_client_ip_header: typing.Optional[CustomDomainCustomClientIpHeader] = OMIT,
        domain_metadata: typing.Optional[DomainMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateCustomDomainResponseContent:
        """
        Update a custom domain.

        These are the attributes that can be updated:

        - custom_client_ip_header
        - tls_policy

        <h5>Updating CUSTOM_CLIENT_IP_HEADER for a custom domain</h5>To update the <code>custom_client_ip_header</code> for a domain, the body to
        send should be:
        <pre><code>{ "custom_client_ip_header": "cf-connecting-ip" }</code></pre>

        <h5>Updating TLS_POLICY for a custom domain</h5>To update the <code>tls_policy</code> for a domain, the body to send should be:
        <pre><code>{ "tls_policy": "recommended" }</code></pre>


        TLS Policies:

        - recommended - for modern usage this includes TLS 1.2 only


        Some considerations:

        - The TLS ciphers and protocols available in each TLS policy follow industry recommendations, and may be updated occasionally.
        - The <code>compatible</code> TLS policy is no longer supported.

        Parameters
        ----------
        id : str
            The id of the custom domain to update

        tls_policy : typing.Optional[CustomDomainTlsPolicyEnum]

        custom_client_ip_header : typing.Optional[CustomDomainCustomClientIpHeader]

        domain_metadata : typing.Optional[DomainMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateCustomDomainResponseContent
            Custom domain updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            tls_policy=tls_policy,
            custom_client_ip_header=custom_client_ip_header,
            domain_metadata=domain_metadata,
            request_options=request_options,
        )
        return _response.data

    def test(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TestCustomDomainResponseContent:
        """
        Run the test process on a custom domain.

        Parameters
        ----------
        id : str
            ID of the custom domain to test.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestCustomDomainResponseContent
            Custom domain test successfully completed.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.test(
            id="id",
        )
        """
        _response = self._raw_client.test(id, request_options=request_options)
        return _response.data

    def verify(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyCustomDomainResponseContent:
        """
        Run the verification process on a custom domain.

        Note: Check the <code>status</code> field to see its verification status. Once verification is complete, it may take up to 10 minutes before the custom domain can start accepting requests.

        For <code>self_managed_certs</code>, when the custom domain is verified for the first time, the response will also include the <code>cname_api_key</code> which you will need to configure your proxy. This key must be kept secret, and is used to validate the proxy requests.

        <a href="https://auth0.com/docs/custom-domains#step-2-verify-ownership">Learn more</a> about verifying custom domains that use Auth0 Managed certificates.
        <a href="https://auth0.com/docs/custom-domains/self-managed-certificates#step-2-verify-ownership">Learn more</a> about verifying custom domains that use Self Managed certificates.

        Parameters
        ----------
        id : str
            ID of the custom domain to verify.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyCustomDomainResponseContent
            Custom domain successfully verified.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.custom_domains.verify(
            id="id",
        )
        """
        _response = self._raw_client.verify(id, request_options=request_options)
        return _response.data


class AsyncCustomDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomDomainsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        take: typing.Optional[int] = 50,
        from_: typing.Optional[str] = None,
        q: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListCustomDomainsResponseContent:
        """
        Retrieve details on <a href="https://auth0.com/docs/custom-domains">custom domains</a>.

        Parameters
        ----------
        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        q : typing.Optional[str]
            Query in <a href ="http://www.lucenetutorial.com/lucene-query-syntax.html">Lucene query string syntax</a>.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        sort : typing.Optional[str]
            Field to sort by. Only <code>domain:1</code> (ascending order by domain) is supported at this time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListCustomDomainsResponseContent
            Custom domains successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.list(
                take=1,
                from_="from",
                q="q",
                fields="fields",
                include_fields=True,
                sort="sort",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            take=take,
            from_=from_,
            q=q,
            fields=fields,
            include_fields=include_fields,
            sort=sort,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        domain: str,
        type: CustomDomainProvisioningTypeEnum,
        verification_method: typing.Optional[CustomDomainVerificationMethodEnum] = OMIT,
        tls_policy: typing.Optional[CustomDomainTlsPolicyEnum] = OMIT,
        custom_client_ip_header: typing.Optional[CustomDomainCustomClientIpHeader] = OMIT,
        domain_metadata: typing.Optional[DomainMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateCustomDomainResponseContent:
        """
        Create a new custom domain.

        Note: The custom domain will need to be verified before it will accept
        requests.

        Optional attributes that can be updated:

        - custom_client_ip_header
        - tls_policy


        TLS Policies:

        - recommended - for modern usage this includes TLS 1.2 only

        Parameters
        ----------
        domain : str
            Domain name.

        type : CustomDomainProvisioningTypeEnum

        verification_method : typing.Optional[CustomDomainVerificationMethodEnum]

        tls_policy : typing.Optional[CustomDomainTlsPolicyEnum]

        custom_client_ip_header : typing.Optional[CustomDomainCustomClientIpHeader]

        domain_metadata : typing.Optional[DomainMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateCustomDomainResponseContent
            Custom domain successfully created (verification is pending).

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.create(
                domain="domain",
                type="auth0_managed_certs",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            domain=domain,
            type=type,
            verification_method=verification_method,
            tls_policy=tls_policy,
            custom_client_ip_header=custom_client_ip_header,
            domain_metadata=domain_metadata,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetCustomDomainResponseContent:
        """
        Retrieve a custom domain configuration and status.

        Parameters
        ----------
        id : str
            ID of the custom domain to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomDomainResponseContent
            Custom domain successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a custom domain and stop serving requests for it.

        Parameters
        ----------
        id : str
            ID of the custom domain to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        tls_policy: typing.Optional[CustomDomainTlsPolicyEnum] = OMIT,
        custom_client_ip_header: typing.Optional[CustomDomainCustomClientIpHeader] = OMIT,
        domain_metadata: typing.Optional[DomainMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateCustomDomainResponseContent:
        """
        Update a custom domain.

        These are the attributes that can be updated:

        - custom_client_ip_header
        - tls_policy

        <h5>Updating CUSTOM_CLIENT_IP_HEADER for a custom domain</h5>To update the <code>custom_client_ip_header</code> for a domain, the body to
        send should be:
        <pre><code>{ "custom_client_ip_header": "cf-connecting-ip" }</code></pre>

        <h5>Updating TLS_POLICY for a custom domain</h5>To update the <code>tls_policy</code> for a domain, the body to send should be:
        <pre><code>{ "tls_policy": "recommended" }</code></pre>


        TLS Policies:

        - recommended - for modern usage this includes TLS 1.2 only


        Some considerations:

        - The TLS ciphers and protocols available in each TLS policy follow industry recommendations, and may be updated occasionally.
        - The <code>compatible</code> TLS policy is no longer supported.

        Parameters
        ----------
        id : str
            The id of the custom domain to update

        tls_policy : typing.Optional[CustomDomainTlsPolicyEnum]

        custom_client_ip_header : typing.Optional[CustomDomainCustomClientIpHeader]

        domain_metadata : typing.Optional[DomainMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateCustomDomainResponseContent
            Custom domain updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            tls_policy=tls_policy,
            custom_client_ip_header=custom_client_ip_header,
            domain_metadata=domain_metadata,
            request_options=request_options,
        )
        return _response.data

    async def test(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TestCustomDomainResponseContent:
        """
        Run the test process on a custom domain.

        Parameters
        ----------
        id : str
            ID of the custom domain to test.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestCustomDomainResponseContent
            Custom domain test successfully completed.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.test(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.test(id, request_options=request_options)
        return _response.data

    async def verify(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyCustomDomainResponseContent:
        """
        Run the verification process on a custom domain.

        Note: Check the <code>status</code> field to see its verification status. Once verification is complete, it may take up to 10 minutes before the custom domain can start accepting requests.

        For <code>self_managed_certs</code>, when the custom domain is verified for the first time, the response will also include the <code>cname_api_key</code> which you will need to configure your proxy. This key must be kept secret, and is used to validate the proxy requests.

        <a href="https://auth0.com/docs/custom-domains#step-2-verify-ownership">Learn more</a> about verifying custom domains that use Auth0 Managed certificates.
        <a href="https://auth0.com/docs/custom-domains/self-managed-certificates#step-2-verify-ownership">Learn more</a> about verifying custom domains that use Self Managed certificates.

        Parameters
        ----------
        id : str
            ID of the custom domain to verify.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyCustomDomainResponseContent
            Custom domain successfully verified.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_domains.verify(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.verify(id, request_options=request_options)
        return _response.data
