# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_public_key_device_credential_response_content import CreatePublicKeyDeviceCredentialResponseContent
from ..types.device_credential import DeviceCredential
from ..types.device_credential_type_enum import DeviceCredentialTypeEnum
from ..types.list_device_credentials_offset_paginated_response_content import (
    ListDeviceCredentialsOffsetPaginatedResponseContent,
)
from .raw_client import AsyncRawDeviceCredentialsClient, RawDeviceCredentialsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DeviceCredentialsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeviceCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDeviceCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeviceCredentialsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        user_id: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        type: typing.Optional[DeviceCredentialTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DeviceCredential, ListDeviceCredentialsOffsetPaginatedResponseContent]:
        """
        Retrieve device credential information (<code>public_key</code>, <code>refresh_token</code>, or <code>rotating_refresh_token</code>) associated with a specific user.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.  There is a maximum of 1000 results allowed from this endpoint.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        user_id : typing.Optional[str]
            user_id of the devices to retrieve.

        client_id : typing.Optional[str]
            client_id of the devices to retrieve.

        type : typing.Optional[DeviceCredentialTypeEnum]
            Type of credentials to retrieve. Must be `public_key`, `refresh_token` or `rotating_refresh_token`. The property will default to `refresh_token` when paging is requested

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DeviceCredential, ListDeviceCredentialsOffsetPaginatedResponseContent]
            Device credentials successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.device_credentials.list(
            page=1,
            per_page=1,
            include_totals=True,
            fields="fields",
            include_fields=True,
            user_id="user_id",
            client_id="client_id",
            type="public_key",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            fields=fields,
            include_fields=include_fields,
            user_id=user_id,
            client_id=client_id,
            type=type,
            request_options=request_options,
        )

    def create_public_key(
        self,
        *,
        device_name: str,
        value: str,
        device_id: str,
        client_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePublicKeyDeviceCredentialResponseContent:
        """
        Create a device credential public key to manage refresh token rotation for a given <code>user_id</code>. Device Credentials APIs are designed for ad-hoc administrative use only and paging is by default enabled for GET requests.

        When refresh token rotation is enabled, the endpoint becomes consistent. For more information, read <a href="https://auth0.com/docs/get-started/tenant-settings/signing-keys"> Signing Keys</a>.

        Parameters
        ----------
        device_name : str
            Name for this device easily recognized by owner.

        value : str
            Base64 encoded string containing the credential.

        device_id : str
            Unique identifier for the device. Recommend using <a href="http://developer.android.com/reference/android/provider/Settings.Secure.html#ANDROID_ID">Android_ID</a> on Android and <a href="https://developer.apple.com/library/ios/documentation/UIKit/Reference/UIDevice_Class/index.html#//apple_ref/occ/instp/UIDevice/identifierForVendor">identifierForVendor</a>.

        client_id : typing.Optional[str]
            client_id of the client (application) this credential is for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePublicKeyDeviceCredentialResponseContent
            Device credentials successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.device_credentials.create_public_key(
            device_name="device_name",
            value="value",
            device_id="device_id",
        )
        """
        _response = self._raw_client.create_public_key(
            device_name=device_name,
            value=value,
            device_id=device_id,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Permanently delete a device credential (such as a refresh token or public key) with the given ID.

        Parameters
        ----------
        id : str
            ID of the credential to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.device_credentials.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncDeviceCredentialsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeviceCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeviceCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeviceCredentialsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        user_id: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        type: typing.Optional[DeviceCredentialTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DeviceCredential, ListDeviceCredentialsOffsetPaginatedResponseContent]:
        """
        Retrieve device credential information (<code>public_key</code>, <code>refresh_token</code>, or <code>rotating_refresh_token</code>) associated with a specific user.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.  There is a maximum of 1000 results allowed from this endpoint.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        user_id : typing.Optional[str]
            user_id of the devices to retrieve.

        client_id : typing.Optional[str]
            client_id of the devices to retrieve.

        type : typing.Optional[DeviceCredentialTypeEnum]
            Type of credentials to retrieve. Must be `public_key`, `refresh_token` or `rotating_refresh_token`. The property will default to `refresh_token` when paging is requested

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DeviceCredential, ListDeviceCredentialsOffsetPaginatedResponseContent]
            Device credentials successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.device_credentials.list(
                page=1,
                per_page=1,
                include_totals=True,
                fields="fields",
                include_fields=True,
                user_id="user_id",
                client_id="client_id",
                type="public_key",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            fields=fields,
            include_fields=include_fields,
            user_id=user_id,
            client_id=client_id,
            type=type,
            request_options=request_options,
        )

    async def create_public_key(
        self,
        *,
        device_name: str,
        value: str,
        device_id: str,
        client_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePublicKeyDeviceCredentialResponseContent:
        """
        Create a device credential public key to manage refresh token rotation for a given <code>user_id</code>. Device Credentials APIs are designed for ad-hoc administrative use only and paging is by default enabled for GET requests.

        When refresh token rotation is enabled, the endpoint becomes consistent. For more information, read <a href="https://auth0.com/docs/get-started/tenant-settings/signing-keys"> Signing Keys</a>.

        Parameters
        ----------
        device_name : str
            Name for this device easily recognized by owner.

        value : str
            Base64 encoded string containing the credential.

        device_id : str
            Unique identifier for the device. Recommend using <a href="http://developer.android.com/reference/android/provider/Settings.Secure.html#ANDROID_ID">Android_ID</a> on Android and <a href="https://developer.apple.com/library/ios/documentation/UIKit/Reference/UIDevice_Class/index.html#//apple_ref/occ/instp/UIDevice/identifierForVendor">identifierForVendor</a>.

        client_id : typing.Optional[str]
            client_id of the client (application) this credential is for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePublicKeyDeviceCredentialResponseContent
            Device credentials successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.device_credentials.create_public_key(
                device_name="device_name",
                value="value",
                device_id="device_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_public_key(
            device_name=device_name,
            value=value,
            device_id=device_id,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Permanently delete a device credential (such as a refresh token or public key) with the given ID.

        Parameters
        ----------
        id : str
            ID of the credential to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.device_credentials.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
