# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_email_template_response_content import CreateEmailTemplateResponseContent
from ..types.email_template_name_enum import EmailTemplateNameEnum
from ..types.get_email_template_response_content import GetEmailTemplateResponseContent
from ..types.set_email_template_response_content import SetEmailTemplateResponseContent
from ..types.update_email_template_response_content import UpdateEmailTemplateResponseContent
from .raw_client import AsyncRawEmailTemplatesClient, RawEmailTemplatesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EmailTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmailTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEmailTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmailTemplatesClient
        """
        return self._raw_client

    def create(
        self,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEmailTemplateResponseContent:
        """
        Create an email template.

        Parameters
        ----------
        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEmailTemplateResponseContent
            Template successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.email_templates.create(
            template="verify_email",
        )
        """
        _response = self._raw_client.create(
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, template_name: EmailTemplateNameEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEmailTemplateResponseContent:
        """
        Retrieve an email template by pre-defined name. These names are `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, and `async_approval`. The names `change_password`, and `password_reset` are also supported for legacy scenarios.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEmailTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.email_templates.get(
            template_name="verify_email",
        )
        """
        _response = self._raw_client.get(template_name, request_options=request_options)
        return _response.data

    def set(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetEmailTemplateResponseContent:
        """
        Update an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetEmailTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.email_templates.set(
            template_name="verify_email",
            template="verify_email",
        )
        """
        _response = self._raw_client.set(
            template_name,
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: typing.Optional[EmailTemplateNameEnum] = OMIT,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEmailTemplateResponseContent:
        """
        Modify an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : typing.Optional[EmailTemplateNameEnum]

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEmailTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.email_templates.update(
            template_name="verify_email",
        )
        """
        _response = self._raw_client.update(
            template_name,
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data


class AsyncEmailTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmailTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEmailTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmailTemplatesClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEmailTemplateResponseContent:
        """
        Create an email template.

        Parameters
        ----------
        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEmailTemplateResponseContent
            Template successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.email_templates.create(
                template="verify_email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, template_name: EmailTemplateNameEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEmailTemplateResponseContent:
        """
        Retrieve an email template by pre-defined name. These names are `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, and `async_approval`. The names `change_password`, and `password_reset` are also supported for legacy scenarios.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEmailTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.email_templates.get(
                template_name="verify_email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(template_name, request_options=request_options)
        return _response.data

    async def set(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetEmailTemplateResponseContent:
        """
        Update an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetEmailTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.email_templates.set(
                template_name="verify_email",
                template="verify_email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(
            template_name,
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: typing.Optional[EmailTemplateNameEnum] = OMIT,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEmailTemplateResponseContent:
        """
        Modify an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : typing.Optional[EmailTemplateNameEnum]

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEmailTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.email_templates.update(
                template_name="verify_email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            template_name,
            template=template,
            body=body,
            from_=from_,
            result_url=result_url,
            subject=subject,
            syntax=syntax,
            url_lifetime_in_seconds=url_lifetime_in_seconds,
            include_email_in_redirect=include_email_in_redirect,
            enabled=enabled,
            request_options=request_options,
        )
        return _response.data
