# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.create_email_template_response_content import CreateEmailTemplateResponseContent
from ..types.email_template_name_enum import EmailTemplateNameEnum
from ..types.get_email_template_response_content import GetEmailTemplateResponseContent
from ..types.set_email_template_response_content import SetEmailTemplateResponseContent
from ..types.update_email_template_response_content import UpdateEmailTemplateResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawEmailTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateEmailTemplateResponseContent]:
        """
        Create an email template.

        Parameters
        ----------
        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateEmailTemplateResponseContent]
            Template successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "email-templates",
            method="POST",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=CreateEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, template_name: EmailTemplateNameEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetEmailTemplateResponseContent]:
        """
        Retrieve an email template by pre-defined name. These names are `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, and `async_approval`. The names `change_password`, and `password_reset` are also supported for legacy scenarios.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetEmailTemplateResponseContent]
            Template successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=GetEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetEmailTemplateResponseContent]:
        """
        Update an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetEmailTemplateResponseContent]
            Template successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="PUT",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=SetEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: typing.Optional[EmailTemplateNameEnum] = OMIT,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateEmailTemplateResponseContent]:
        """
        Modify an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : typing.Optional[EmailTemplateNameEnum]

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateEmailTemplateResponseContent]
            Template successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="PATCH",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=UpdateEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawEmailTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateEmailTemplateResponseContent]:
        """
        Create an email template.

        Parameters
        ----------
        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateEmailTemplateResponseContent]
            Template successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "email-templates",
            method="POST",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=CreateEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, template_name: EmailTemplateNameEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetEmailTemplateResponseContent]:
        """
        Retrieve an email template by pre-defined name. These names are `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, and `async_approval`. The names `change_password`, and `password_reset` are also supported for legacy scenarios.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetEmailTemplateResponseContent]
            Template successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=GetEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: EmailTemplateNameEnum,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetEmailTemplateResponseContent]:
        """
        Update an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : EmailTemplateNameEnum

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetEmailTemplateResponseContent]
            Template successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="PUT",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=SetEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        template_name: EmailTemplateNameEnum,
        *,
        template: typing.Optional[EmailTemplateNameEnum] = OMIT,
        body: typing.Optional[str] = OMIT,
        from_: typing.Optional[str] = "sender@auth0.com",
        result_url: typing.Optional[str] = OMIT,
        subject: typing.Optional[str] = OMIT,
        syntax: typing.Optional[str] = "liquid",
        url_lifetime_in_seconds: typing.Optional[float] = OMIT,
        include_email_in_redirect: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateEmailTemplateResponseContent]:
        """
        Modify an email template.

        Parameters
        ----------
        template_name : EmailTemplateNameEnum
            Template name. Can be `verify_email`, `verify_email_by_code`, `reset_email`, `reset_email_by_code`, `welcome_email`, `blocked_account`, `stolen_credentials`, `enrollment_email`, `mfa_oob_code`, `user_invitation`, `async_approval`, `change_password` (legacy), or `password_reset` (legacy).

        template : typing.Optional[EmailTemplateNameEnum]

        body : typing.Optional[str]
            Body of the email template.

        from_ : typing.Optional[str]
            Senders `from` email address.

        result_url : typing.Optional[str]
            URL to redirect the user to after a successful action.

        subject : typing.Optional[str]
            Subject line of the email.

        syntax : typing.Optional[str]
            Syntax of the template body.

        url_lifetime_in_seconds : typing.Optional[float]
            Lifetime in seconds that the link within the email will be valid for.

        include_email_in_redirect : typing.Optional[bool]
            Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.

        enabled : typing.Optional[bool]
            Whether the template is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateEmailTemplateResponseContent]
            Template successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"email-templates/{jsonable_encoder(template_name)}",
            method="PATCH",
            json={
                "template": template,
                "body": body,
                "from": from_,
                "resultUrl": result_url,
                "subject": subject,
                "syntax": syntax,
                "urlLifetimeInSeconds": url_lifetime_in_seconds,
                "includeEmailInRedirect": include_email_in_redirect,
                "enabled": enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateEmailTemplateResponseContent,
                    parse_obj_as(
                        type_=UpdateEmailTemplateResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
