# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawEmailsClient, RawEmailsClient

if typing.TYPE_CHECKING:
    from .provider.client import AsyncProviderClient, ProviderClient


class EmailsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmailsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._provider: typing.Optional[ProviderClient] = None

    @property
    def with_raw_response(self) -> RawEmailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmailsClient
        """
        return self._raw_client

    @property
    def provider(self):
        if self._provider is None:
            from .provider.client import ProviderClient  # noqa: E402

            self._provider = ProviderClient(client_wrapper=self._client_wrapper)
        return self._provider


class AsyncEmailsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmailsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._provider: typing.Optional[AsyncProviderClient] = None

    @property
    def with_raw_response(self) -> AsyncRawEmailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmailsClient
        """
        return self._raw_client

    @property
    def provider(self):
        if self._provider is None:
            from .provider.client import AsyncProviderClient  # noqa: E402

            self._provider = AsyncProviderClient(client_wrapper=self._client_wrapper)
        return self._provider
