# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_email_provider_response_content import CreateEmailProviderResponseContent
from ...types.email_provider_credentials_schema import EmailProviderCredentialsSchema
from ...types.email_provider_name_enum import EmailProviderNameEnum
from ...types.email_specific_provider_settings_with_additional_properties import (
    EmailSpecificProviderSettingsWithAdditionalProperties,
)
from ...types.get_email_provider_response_content import GetEmailProviderResponseContent
from ...types.update_email_provider_response_content import UpdateEmailProviderResponseContent
from .raw_client import AsyncRawProviderClient, RawProviderClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProviderClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProviderClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProviderClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProviderClient
        """
        return self._raw_client

    def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetEmailProviderResponseContent:
        """
        Retrieve details of the <a href="https://auth0.com/docs/customize/email/smtp-email-providers">email provider configuration</a> in your tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (dependent upon include_fields) from the result. Leave empty to retrieve `name` and `enabled`. Additional fields available include `credentials`, `default_from_address`, and `settings`.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEmailProviderResponseContent
            Email provider successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.emails.provider.get(
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(fields=fields, include_fields=include_fields, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: EmailProviderNameEnum,
        credentials: EmailProviderCredentialsSchema,
        enabled: typing.Optional[bool] = True,
        default_from_address: typing.Optional[str] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEmailProviderResponseContent:
        """
        Create an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
          </li>
          <li>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : EmailProviderNameEnum

        credentials : EmailProviderCredentialsSchema

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEmailProviderResponseContent
            Email provider successfully created.

        Examples
        --------
        from auth0 import Auth0, EmailProviderCredentialsSchemaZero

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.emails.provider.create(
            name="mailgun",
            credentials=EmailProviderCredentialsSchemaZero(
                api_key="api_key",
            ),
        )
        """
        _response = self._raw_client.create(
            name=name,
            credentials=credentials,
            enabled=enabled,
            default_from_address=default_from_address,
            settings=settings,
            request_options=request_options,
        )
        return _response.data

    def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the email provider.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.emails.provider.delete()
        """
        _response = self._raw_client.delete(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        name: typing.Optional[EmailProviderNameEnum] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        default_from_address: typing.Optional[str] = OMIT,
        credentials: typing.Optional[EmailProviderCredentialsSchema] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEmailProviderResponseContent:
        """
        Update an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : typing.Optional[EmailProviderNameEnum]

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        credentials : typing.Optional[EmailProviderCredentialsSchema]

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEmailProviderResponseContent
            Email provider successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.emails.provider.update()
        """
        _response = self._raw_client.update(
            name=name,
            enabled=enabled,
            default_from_address=default_from_address,
            credentials=credentials,
            settings=settings,
            request_options=request_options,
        )
        return _response.data


class AsyncProviderClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProviderClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProviderClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProviderClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetEmailProviderResponseContent:
        """
        Retrieve details of the <a href="https://auth0.com/docs/customize/email/smtp-email-providers">email provider configuration</a> in your tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (dependent upon include_fields) from the result. Leave empty to retrieve `name` and `enabled`. Additional fields available include `credentials`, `default_from_address`, and `settings`.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEmailProviderResponseContent
            Email provider successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.emails.provider.get(
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def create(
        self,
        *,
        name: EmailProviderNameEnum,
        credentials: EmailProviderCredentialsSchema,
        enabled: typing.Optional[bool] = True,
        default_from_address: typing.Optional[str] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEmailProviderResponseContent:
        """
        Create an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
          </li>
          <li>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : EmailProviderNameEnum

        credentials : EmailProviderCredentialsSchema

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEmailProviderResponseContent
            Email provider successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, EmailProviderCredentialsSchemaZero

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.emails.provider.create(
                name="mailgun",
                credentials=EmailProviderCredentialsSchemaZero(
                    api_key="api_key",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            credentials=credentials,
            enabled=enabled,
            default_from_address=default_from_address,
            settings=settings,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the email provider.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.emails.provider.delete()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        name: typing.Optional[EmailProviderNameEnum] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        default_from_address: typing.Optional[str] = OMIT,
        credentials: typing.Optional[EmailProviderCredentialsSchema] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEmailProviderResponseContent:
        """
        Update an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : typing.Optional[EmailProviderNameEnum]

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        credentials : typing.Optional[EmailProviderCredentialsSchema]

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEmailProviderResponseContent
            Email provider successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.emails.provider.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            name=name,
            enabled=enabled,
            default_from_address=default_from_address,
            credentials=credentials,
            settings=settings,
            request_options=request_options,
        )
        return _response.data
