# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.conflict_error import ConflictError
from ...errors.forbidden_error import ForbiddenError
from ...errors.not_found_error import NotFoundError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.create_email_provider_response_content import CreateEmailProviderResponseContent
from ...types.email_provider_credentials_schema import EmailProviderCredentialsSchema
from ...types.email_provider_name_enum import EmailProviderNameEnum
from ...types.email_specific_provider_settings_with_additional_properties import (
    EmailSpecificProviderSettingsWithAdditionalProperties,
)
from ...types.get_email_provider_response_content import GetEmailProviderResponseContent
from ...types.update_email_provider_response_content import UpdateEmailProviderResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawProviderClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetEmailProviderResponseContent]:
        """
        Retrieve details of the <a href="https://auth0.com/docs/customize/email/smtp-email-providers">email provider configuration</a> in your tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (dependent upon include_fields) from the result. Leave empty to retrieve `name` and `enabled`. Additional fields available include `credentials`, `default_from_address`, and `settings`.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetEmailProviderResponseContent]
            Email provider successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEmailProviderResponseContent,
                    parse_obj_as(
                        type_=GetEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: EmailProviderNameEnum,
        credentials: EmailProviderCredentialsSchema,
        enabled: typing.Optional[bool] = True,
        default_from_address: typing.Optional[str] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateEmailProviderResponseContent]:
        """
        Create an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
          </li>
          <li>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : EmailProviderNameEnum

        credentials : EmailProviderCredentialsSchema

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateEmailProviderResponseContent]
            Email provider successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="POST",
            json={
                "name": name,
                "enabled": enabled,
                "default_from_address": default_from_address,
                "credentials": convert_and_respect_annotation_metadata(
                    object_=credentials, annotation=EmailProviderCredentialsSchema, direction="write"
                ),
                "settings": settings,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateEmailProviderResponseContent,
                    parse_obj_as(
                        type_=CreateEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Delete the email provider.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        name: typing.Optional[EmailProviderNameEnum] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        default_from_address: typing.Optional[str] = OMIT,
        credentials: typing.Optional[EmailProviderCredentialsSchema] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateEmailProviderResponseContent]:
        """
        Update an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : typing.Optional[EmailProviderNameEnum]

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        credentials : typing.Optional[EmailProviderCredentialsSchema]

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateEmailProviderResponseContent]
            Email provider successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="PATCH",
            json={
                "name": name,
                "enabled": enabled,
                "default_from_address": default_from_address,
                "credentials": convert_and_respect_annotation_metadata(
                    object_=credentials, annotation=EmailProviderCredentialsSchema, direction="write"
                ),
                "settings": settings,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateEmailProviderResponseContent,
                    parse_obj_as(
                        type_=UpdateEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawProviderClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetEmailProviderResponseContent]:
        """
        Retrieve details of the <a href="https://auth0.com/docs/customize/email/smtp-email-providers">email provider configuration</a> in your tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (dependent upon include_fields) from the result. Leave empty to retrieve `name` and `enabled`. Additional fields available include `credentials`, `default_from_address`, and `settings`.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetEmailProviderResponseContent]
            Email provider successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEmailProviderResponseContent,
                    parse_obj_as(
                        type_=GetEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: EmailProviderNameEnum,
        credentials: EmailProviderCredentialsSchema,
        enabled: typing.Optional[bool] = True,
        default_from_address: typing.Optional[str] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateEmailProviderResponseContent]:
        """
        Create an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
          </li>
          <li>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : EmailProviderNameEnum

        credentials : EmailProviderCredentialsSchema

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateEmailProviderResponseContent]
            Email provider successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="POST",
            json={
                "name": name,
                "enabled": enabled,
                "default_from_address": default_from_address,
                "credentials": convert_and_respect_annotation_metadata(
                    object_=credentials, annotation=EmailProviderCredentialsSchema, direction="write"
                ),
                "settings": settings,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateEmailProviderResponseContent,
                    parse_obj_as(
                        type_=CreateEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> AsyncHttpResponse[None]:
        """
        Delete the email provider.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        name: typing.Optional[EmailProviderNameEnum] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        default_from_address: typing.Optional[str] = OMIT,
        credentials: typing.Optional[EmailProviderCredentialsSchema] = OMIT,
        settings: typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateEmailProviderResponseContent]:
        """
        Update an <a href="https://auth0.com/docs/email/providers">email provider</a>. The <code>credentials</code> object
        requires different properties depending on the email provider (which is specified using the <code>name</code> property):
        <ul>
          <li><code>mandrill</code> requires <code>api_key</code></li>
          <li><code>sendgrid</code> requires <code>api_key</code></li>
          <li>
            <code>sparkpost</code> requires <code>api_key</code>. Optionally, set <code>region</code> to <code>eu</code> to use
            the SparkPost service hosted in Western Europe; set to <code>null</code> to use the SparkPost service hosted in
            North America. <code>eu</code> or <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li>
            <code>mailgun</code> requires <code>api_key</code> and <code>domain</code>. Optionally, set <code>region</code> to
            <code>eu</code> to use the Mailgun service hosted in Europe; set to <code>null</code> otherwise. <code>eu</code> or
            <code>null</code> are the only valid values for <code>region</code>.
          </li>
          <li><code>ses</code> requires <code>accessKeyId</code>, <code>secretAccessKey</code>, and <code>region</code></li>
          <li>
            <code>smtp</code> requires <code>smtp_host</code>, <code>smtp_port</code>, <code>smtp_user</code>, and
            <code>smtp_pass</code>
          </li>
        </ul>
        Depending on the type of provider it is possible to specify <code>settings</code> object with different configuration
        options, which will be used when sending an email:
        <ul>
          <li>
            <code>smtp</code> provider, <code>settings</code> may contain <code>headers</code> object.
            <ul>
              <li>
                When using AWS SES SMTP host, you may provide a name of configuration set in
                <code>X-SES-Configuration-Set</code> header. Value must be a string.
              </li>
              <li>
                When using Sparkpost host, you may provide value for
                <code>X-MSYS_API</code> header. Value must be an object.
              </li>
            </ul>
            for <code>ses</code> provider, <code>settings</code> may contain <code>message</code> object, where you can provide
            a name of configuration set in <code>configuration_set_name</code> property. Value must be a string.
          </li>
        </ul>

        Parameters
        ----------
        name : typing.Optional[EmailProviderNameEnum]

        enabled : typing.Optional[bool]
            Whether the provider is enabled (true) or disabled (false).

        default_from_address : typing.Optional[str]
            Email address to use as "from" when no other address specified.

        credentials : typing.Optional[EmailProviderCredentialsSchema]

        settings : typing.Optional[EmailSpecificProviderSettingsWithAdditionalProperties]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateEmailProviderResponseContent]
            Email provider successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "emails/provider",
            method="PATCH",
            json={
                "name": name,
                "enabled": enabled,
                "default_from_address": default_from_address,
                "credentials": convert_and_respect_annotation_metadata(
                    object_=credentials, annotation=EmailProviderCredentialsSchema, direction="write"
                ),
                "settings": settings,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateEmailProviderResponseContent,
                    parse_obj_as(
                        type_=UpdateEmailProviderResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
