# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_event_stream_response_content import CreateEventStreamResponseContent
from ..types.create_event_stream_test_event_response_content import CreateEventStreamTestEventResponseContent
from ..types.event_stream_destination_patch import EventStreamDestinationPatch
from ..types.event_stream_response_content import EventStreamResponseContent
from ..types.event_stream_status_enum import EventStreamStatusEnum
from ..types.event_stream_subscription import EventStreamSubscription
from ..types.event_stream_test_event_type_enum import EventStreamTestEventTypeEnum
from ..types.get_event_stream_response_content import GetEventStreamResponseContent
from ..types.test_event_data_content import TestEventDataContent
from ..types.update_event_stream_response_content import UpdateEventStreamResponseContent
from .raw_client import AsyncRawEventStreamsClient, RawEventStreamsClient
from .types.event_streams_create_request import EventStreamsCreateRequest

if typing.TYPE_CHECKING:
    from .deliveries.client import AsyncDeliveriesClient, DeliveriesClient
    from .redeliveries.client import AsyncRedeliveriesClient, RedeliveriesClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EventStreamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEventStreamsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._deliveries: typing.Optional[DeliveriesClient] = None
        self._redeliveries: typing.Optional[RedeliveriesClient] = None

    @property
    def with_raw_response(self) -> RawEventStreamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEventStreamsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EventStreamResponseContent]:
        """
        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EventStreamResponseContent]
            Event streams successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.list(
            from_="from",
            take=1,
        )
        """
        _response = self._raw_client.list(from_=from_, take=take, request_options=request_options)
        return _response.data

    def create(
        self, *, request: EventStreamsCreateRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEventStreamResponseContent:
        """
        Parameters
        ----------
        request : EventStreamsCreateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamResponseContent
            Event Stream stream created successfully.

        Examples
        --------
        from auth0 import (
            Auth0,
            CreateEventStreamWebHookRequestContent,
            EventStreamWebhookBasicAuth,
            EventStreamWebhookConfiguration,
            EventStreamWebhookDestination,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.create(
            request=CreateEventStreamWebHookRequestContent(
                destination=EventStreamWebhookDestination(
                    configuration=EventStreamWebhookConfiguration(
                        webhook_endpoint="webhook_endpoint",
                        webhook_authorization=EventStreamWebhookBasicAuth(
                            username="username",
                        ),
                    ),
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetEventStreamResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEventStreamResponseContent
            Event stream successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        subscriptions: typing.Optional[typing.Sequence[EventStreamSubscription]] = OMIT,
        destination: typing.Optional[EventStreamDestinationPatch] = OMIT,
        status: typing.Optional[EventStreamStatusEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEventStreamResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        name : typing.Optional[str]
            Name of the event stream.

        subscriptions : typing.Optional[typing.Sequence[EventStreamSubscription]]
            List of event types subscribed to in this stream.

        destination : typing.Optional[EventStreamDestinationPatch]

        status : typing.Optional[EventStreamStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEventStreamResponseContent
            Event stream successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            subscriptions=subscriptions,
            destination=destination,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def test(
        self,
        id: str,
        *,
        event_type: EventStreamTestEventTypeEnum,
        data: typing.Optional[TestEventDataContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEventStreamTestEventResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_type : EventStreamTestEventTypeEnum

        data : typing.Optional[TestEventDataContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamTestEventResponseContent
            Test event successfully submitted.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.test(
            id="id",
            event_type="user.created",
        )
        """
        _response = self._raw_client.test(id, event_type=event_type, data=data, request_options=request_options)
        return _response.data

    @property
    def deliveries(self):
        if self._deliveries is None:
            from .deliveries.client import DeliveriesClient  # noqa: E402

            self._deliveries = DeliveriesClient(client_wrapper=self._client_wrapper)
        return self._deliveries

    @property
    def redeliveries(self):
        if self._redeliveries is None:
            from .redeliveries.client import RedeliveriesClient  # noqa: E402

            self._redeliveries = RedeliveriesClient(client_wrapper=self._client_wrapper)
        return self._redeliveries


class AsyncEventStreamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEventStreamsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._deliveries: typing.Optional[AsyncDeliveriesClient] = None
        self._redeliveries: typing.Optional[AsyncRedeliveriesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawEventStreamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEventStreamsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EventStreamResponseContent]:
        """
        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EventStreamResponseContent]
            Event streams successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.list(
                from_="from",
                take=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(from_=from_, take=take, request_options=request_options)
        return _response.data

    async def create(
        self, *, request: EventStreamsCreateRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEventStreamResponseContent:
        """
        Parameters
        ----------
        request : EventStreamsCreateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamResponseContent
            Event Stream stream created successfully.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            CreateEventStreamWebHookRequestContent,
            EventStreamWebhookBasicAuth,
            EventStreamWebhookConfiguration,
            EventStreamWebhookDestination,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.create(
                request=CreateEventStreamWebHookRequestContent(
                    destination=EventStreamWebhookDestination(
                        configuration=EventStreamWebhookConfiguration(
                            webhook_endpoint="webhook_endpoint",
                            webhook_authorization=EventStreamWebhookBasicAuth(
                                username="username",
                            ),
                        ),
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEventStreamResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEventStreamResponseContent
            Event stream successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        subscriptions: typing.Optional[typing.Sequence[EventStreamSubscription]] = OMIT,
        destination: typing.Optional[EventStreamDestinationPatch] = OMIT,
        status: typing.Optional[EventStreamStatusEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateEventStreamResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        name : typing.Optional[str]
            Name of the event stream.

        subscriptions : typing.Optional[typing.Sequence[EventStreamSubscription]]
            List of event types subscribed to in this stream.

        destination : typing.Optional[EventStreamDestinationPatch]

        status : typing.Optional[EventStreamStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateEventStreamResponseContent
            Event stream successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            subscriptions=subscriptions,
            destination=destination,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def test(
        self,
        id: str,
        *,
        event_type: EventStreamTestEventTypeEnum,
        data: typing.Optional[TestEventDataContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEventStreamTestEventResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_type : EventStreamTestEventTypeEnum

        data : typing.Optional[TestEventDataContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamTestEventResponseContent
            Test event successfully submitted.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.test(
                id="id",
                event_type="user.created",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.test(id, event_type=event_type, data=data, request_options=request_options)
        return _response.data

    @property
    def deliveries(self):
        if self._deliveries is None:
            from .deliveries.client import AsyncDeliveriesClient  # noqa: E402

            self._deliveries = AsyncDeliveriesClient(client_wrapper=self._client_wrapper)
        return self._deliveries

    @property
    def redeliveries(self):
        if self._redeliveries is None:
            from .redeliveries.client import AsyncRedeliveriesClient  # noqa: E402

            self._redeliveries = AsyncRedeliveriesClient(client_wrapper=self._client_wrapper)
        return self._redeliveries
