# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.event_stream_delivery import EventStreamDelivery
from ...types.get_event_stream_delivery_history_response_content import GetEventStreamDeliveryHistoryResponseContent
from .raw_client import AsyncRawDeliveriesClient, RawDeliveriesClient


class DeliveriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeliveriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDeliveriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeliveriesClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        statuses: typing.Optional[str] = None,
        event_types: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EventStreamDelivery]:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        statuses : typing.Optional[str]
            Comma-separated list of statuses by which to filter

        event_types : typing.Optional[str]
            Comma-separated list of event types by which to filter

        date_from : typing.Optional[str]
            An RFC-3339 date-time for redelivery start, inclusive. Does not allow sub-second precision.

        date_to : typing.Optional[str]
            An RFC-3339 date-time for redelivery end, exclusive. Does not allow sub-second precision.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EventStreamDelivery]
            Event stream deliveries successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.deliveries.list(
            id="id",
            statuses="statuses",
            event_types="event_types",
            date_from="date_from",
            date_to="date_to",
            from_="from",
            take=1,
        )
        """
        _response = self._raw_client.list(
            id,
            statuses=statuses,
            event_types=event_types,
            date_from=date_from,
            date_to=date_to,
            from_=from_,
            take=take,
            request_options=request_options,
        )
        return _response.data

    def get_history(
        self, id: str, event_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEventStreamDeliveryHistoryResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_id : str
            Unique identifier for the event

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEventStreamDeliveryHistoryResponseContent
            Delivery history for event successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.deliveries.get_history(
            id="id",
            event_id="event_id",
        )
        """
        _response = self._raw_client.get_history(id, event_id, request_options=request_options)
        return _response.data


class AsyncDeliveriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeliveriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeliveriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeliveriesClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        statuses: typing.Optional[str] = None,
        event_types: typing.Optional[str] = None,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[EventStreamDelivery]:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        statuses : typing.Optional[str]
            Comma-separated list of statuses by which to filter

        event_types : typing.Optional[str]
            Comma-separated list of event types by which to filter

        date_from : typing.Optional[str]
            An RFC-3339 date-time for redelivery start, inclusive. Does not allow sub-second precision.

        date_to : typing.Optional[str]
            An RFC-3339 date-time for redelivery end, exclusive. Does not allow sub-second precision.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EventStreamDelivery]
            Event stream deliveries successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.deliveries.list(
                id="id",
                statuses="statuses",
                event_types="event_types",
                date_from="date_from",
                date_to="date_to",
                from_="from",
                take=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            id,
            statuses=statuses,
            event_types=event_types,
            date_from=date_from,
            date_to=date_to,
            from_=from_,
            take=take,
            request_options=request_options,
        )
        return _response.data

    async def get_history(
        self, id: str, event_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEventStreamDeliveryHistoryResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_id : str
            Unique identifier for the event

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEventStreamDeliveryHistoryResponseContent
            Delivery history for event successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.deliveries.get_history(
                id="id",
                event_id="event_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_history(id, event_id, request_options=request_options)
        return _response.data
