# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_event_stream_redelivery_response_content import CreateEventStreamRedeliveryResponseContent
from ...types.event_stream_delivery_status_enum import EventStreamDeliveryStatusEnum
from ...types.event_stream_event_type_enum import EventStreamEventTypeEnum
from .raw_client import AsyncRawRedeliveriesClient, RawRedeliveriesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RedeliveriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRedeliveriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRedeliveriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRedeliveriesClient
        """
        return self._raw_client

    def create(
        self,
        id: str,
        *,
        date_from: typing.Optional[dt.datetime] = OMIT,
        date_to: typing.Optional[dt.datetime] = OMIT,
        statuses: typing.Optional[typing.Sequence[EventStreamDeliveryStatusEnum]] = OMIT,
        event_types: typing.Optional[typing.Sequence[EventStreamEventTypeEnum]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEventStreamRedeliveryResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        date_from : typing.Optional[dt.datetime]
            An RFC-3339 date-time for redelivery start, inclusive. Does not allow sub-second precision.

        date_to : typing.Optional[dt.datetime]
            An RFC-3339 date-time for redelivery end, exclusive. Does not allow sub-second precision.

        statuses : typing.Optional[typing.Sequence[EventStreamDeliveryStatusEnum]]
            Filter by status

        event_types : typing.Optional[typing.Sequence[EventStreamEventTypeEnum]]
            Filter by event type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamRedeliveryResponseContent
            Redelivery request accepted.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.redeliveries.create(
            id="id",
        )
        """
        _response = self._raw_client.create(
            id,
            date_from=date_from,
            date_to=date_to,
            statuses=statuses,
            event_types=event_types,
            request_options=request_options,
        )
        return _response.data

    def create_by_id(self, id: str, event_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_id : str
            Unique identifier for the event

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.event_streams.redeliveries.create_by_id(
            id="id",
            event_id="event_id",
        )
        """
        _response = self._raw_client.create_by_id(id, event_id, request_options=request_options)
        return _response.data


class AsyncRedeliveriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRedeliveriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRedeliveriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRedeliveriesClient
        """
        return self._raw_client

    async def create(
        self,
        id: str,
        *,
        date_from: typing.Optional[dt.datetime] = OMIT,
        date_to: typing.Optional[dt.datetime] = OMIT,
        statuses: typing.Optional[typing.Sequence[EventStreamDeliveryStatusEnum]] = OMIT,
        event_types: typing.Optional[typing.Sequence[EventStreamEventTypeEnum]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateEventStreamRedeliveryResponseContent:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        date_from : typing.Optional[dt.datetime]
            An RFC-3339 date-time for redelivery start, inclusive. Does not allow sub-second precision.

        date_to : typing.Optional[dt.datetime]
            An RFC-3339 date-time for redelivery end, exclusive. Does not allow sub-second precision.

        statuses : typing.Optional[typing.Sequence[EventStreamDeliveryStatusEnum]]
            Filter by status

        event_types : typing.Optional[typing.Sequence[EventStreamEventTypeEnum]]
            Filter by event type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEventStreamRedeliveryResponseContent
            Redelivery request accepted.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.redeliveries.create(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id,
            date_from=date_from,
            date_to=date_to,
            statuses=statuses,
            event_types=event_types,
            request_options=request_options,
        )
        return _response.data

    async def create_by_id(
        self, id: str, event_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        id : str
            Unique identifier for the event stream.

        event_id : str
            Unique identifier for the event

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.event_streams.redeliveries.create_by_id(
                id="id",
                event_id="event_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_by_id(id, event_id, request_options=request_options)
        return _response.data
