# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_flow_response_content import CreateFlowResponseContent
from ..types.flow_action import FlowAction
from ..types.flow_summary import FlowSummary
from ..types.get_flow_request_parameters_hydrate_enum import GetFlowRequestParametersHydrateEnum
from ..types.get_flow_response_content import GetFlowResponseContent
from ..types.list_flows_offset_paginated_response_content import ListFlowsOffsetPaginatedResponseContent
from ..types.update_flow_response_content import UpdateFlowResponseContent
from .raw_client import AsyncRawFlowsClient, RawFlowsClient

if typing.TYPE_CHECKING:
    from .executions.client import AsyncExecutionsClient, ExecutionsClient
    from .vault.client import AsyncVaultClient, VaultClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FlowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFlowsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._executions: typing.Optional[ExecutionsClient] = None
        self._vault: typing.Optional[VaultClient] = None

    @property
    def with_raw_response(self) -> RawFlowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFlowsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[typing.Literal["form_count"], typing.Sequence[typing.Literal["form_count"]]]
        ] = None,
        synchronous: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FlowSummary, ListFlowsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[typing.Literal["form_count"], typing.Sequence[typing.Literal["form_count"]]]]
            hydration param

        synchronous : typing.Optional[bool]
            flag to filter by sync/async flows

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FlowSummary, ListFlowsOffsetPaginatedResponseContent]
            Flows successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.flows.list(
            page=1,
            per_page=1,
            include_totals=True,
            synchronous=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            hydrate=hydrate,
            synchronous=synchronous,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str,
        actions: typing.Optional[typing.Sequence[FlowAction]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFlowResponseContent:
        """
        Parameters
        ----------
        name : str

        actions : typing.Optional[typing.Sequence[FlowAction]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFlowResponseContent
            Flow successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.create(
            name="name",
        )
        """
        _response = self._raw_client.create(name=name, actions=actions, request_options=request_options)
        return _response.data

    def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[GetFlowRequestParametersHydrateEnum, typing.Sequence[GetFlowRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFlowResponseContent:
        """
        Parameters
        ----------
        id : str
            Flow identifier

        hydrate : typing.Optional[typing.Union[GetFlowRequestParametersHydrateEnum, typing.Sequence[GetFlowRequestParametersHydrateEnum]]]
            hydration param

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowResponseContent
            Flow successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, hydrate=hydrate, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Flow id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        actions: typing.Optional[typing.Sequence[FlowAction]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFlowResponseContent:
        """
        Parameters
        ----------
        id : str
            Flow identifier

        name : typing.Optional[str]

        actions : typing.Optional[typing.Sequence[FlowAction]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFlowResponseContent
            Flow successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.update(
            id="id",
        )
        """
        _response = self._raw_client.update(id, name=name, actions=actions, request_options=request_options)
        return _response.data

    @property
    def executions(self):
        if self._executions is None:
            from .executions.client import ExecutionsClient  # noqa: E402

            self._executions = ExecutionsClient(client_wrapper=self._client_wrapper)
        return self._executions

    @property
    def vault(self):
        if self._vault is None:
            from .vault.client import VaultClient  # noqa: E402

            self._vault = VaultClient(client_wrapper=self._client_wrapper)
        return self._vault


class AsyncFlowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFlowsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._executions: typing.Optional[AsyncExecutionsClient] = None
        self._vault: typing.Optional[AsyncVaultClient] = None

    @property
    def with_raw_response(self) -> AsyncRawFlowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFlowsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[typing.Literal["form_count"], typing.Sequence[typing.Literal["form_count"]]]
        ] = None,
        synchronous: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FlowSummary, ListFlowsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[typing.Literal["form_count"], typing.Sequence[typing.Literal["form_count"]]]]
            hydration param

        synchronous : typing.Optional[bool]
            flag to filter by sync/async flows

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FlowSummary, ListFlowsOffsetPaginatedResponseContent]
            Flows successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.flows.list(
                page=1,
                per_page=1,
                include_totals=True,
                synchronous=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            hydrate=hydrate,
            synchronous=synchronous,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str,
        actions: typing.Optional[typing.Sequence[FlowAction]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFlowResponseContent:
        """
        Parameters
        ----------
        name : str

        actions : typing.Optional[typing.Sequence[FlowAction]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFlowResponseContent
            Flow successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, actions=actions, request_options=request_options)
        return _response.data

    async def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[GetFlowRequestParametersHydrateEnum, typing.Sequence[GetFlowRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFlowResponseContent:
        """
        Parameters
        ----------
        id : str
            Flow identifier

        hydrate : typing.Optional[typing.Union[GetFlowRequestParametersHydrateEnum, typing.Sequence[GetFlowRequestParametersHydrateEnum]]]
            hydration param

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowResponseContent
            Flow successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, hydrate=hydrate, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Flow id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        actions: typing.Optional[typing.Sequence[FlowAction]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFlowResponseContent:
        """
        Parameters
        ----------
        id : str
            Flow identifier

        name : typing.Optional[str]

        actions : typing.Optional[typing.Sequence[FlowAction]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFlowResponseContent
            Flow successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, name=name, actions=actions, request_options=request_options)
        return _response.data

    @property
    def executions(self):
        if self._executions is None:
            from .executions.client import AsyncExecutionsClient  # noqa: E402

            self._executions = AsyncExecutionsClient(client_wrapper=self._client_wrapper)
        return self._executions

    @property
    def vault(self):
        if self._vault is None:
            from .vault.client import AsyncVaultClient  # noqa: E402

            self._vault = AsyncVaultClient(client_wrapper=self._client_wrapper)
        return self._vault
