# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.flow_execution_summary import FlowExecutionSummary
from ...types.get_flow_execution_response_content import GetFlowExecutionResponseContent
from ...types.list_flow_executions_paginated_response_content import ListFlowExecutionsPaginatedResponseContent
from .raw_client import AsyncRawExecutionsClient, RawExecutionsClient


class ExecutionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExecutionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExecutionsClient
        """
        return self._raw_client

    def list(
        self,
        flow_id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FlowExecutionSummary, ListFlowExecutionsPaginatedResponseContent]:
        """
        Parameters
        ----------
        flow_id : str
            Flow id

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FlowExecutionSummary, ListFlowExecutionsPaginatedResponseContent]
            Flow executions successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.flows.executions.list(
            flow_id="flow_id",
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(flow_id, from_=from_, take=take, request_options=request_options)

    def get(
        self,
        flow_id: str,
        execution_id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[typing.Literal["debug"], typing.Sequence[typing.Literal["debug"]]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFlowExecutionResponseContent:
        """
        Parameters
        ----------
        flow_id : str
            Flow id

        execution_id : str
            Flow execution id

        hydrate : typing.Optional[typing.Union[typing.Literal["debug"], typing.Sequence[typing.Literal["debug"]]]]
            Hydration param

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowExecutionResponseContent
            Flow execution successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.executions.get(
            flow_id="flow_id",
            execution_id="execution_id",
        )
        """
        _response = self._raw_client.get(flow_id, execution_id, hydrate=hydrate, request_options=request_options)
        return _response.data

    def delete(
        self, flow_id: str, execution_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        flow_id : str
            Flows id

        execution_id : str
            Flow execution identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.executions.delete(
            flow_id="flow_id",
            execution_id="execution_id",
        )
        """
        _response = self._raw_client.delete(flow_id, execution_id, request_options=request_options)
        return _response.data


class AsyncExecutionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExecutionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExecutionsClient
        """
        return self._raw_client

    async def list(
        self,
        flow_id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FlowExecutionSummary, ListFlowExecutionsPaginatedResponseContent]:
        """
        Parameters
        ----------
        flow_id : str
            Flow id

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FlowExecutionSummary, ListFlowExecutionsPaginatedResponseContent]
            Flow executions successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.flows.executions.list(
                flow_id="flow_id",
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(flow_id, from_=from_, take=take, request_options=request_options)

    async def get(
        self,
        flow_id: str,
        execution_id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[typing.Literal["debug"], typing.Sequence[typing.Literal["debug"]]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFlowExecutionResponseContent:
        """
        Parameters
        ----------
        flow_id : str
            Flow id

        execution_id : str
            Flow execution id

        hydrate : typing.Optional[typing.Union[typing.Literal["debug"], typing.Sequence[typing.Literal["debug"]]]]
            Hydration param

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowExecutionResponseContent
            Flow execution successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.executions.get(
                flow_id="flow_id",
                execution_id="execution_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(flow_id, execution_id, hydrate=hydrate, request_options=request_options)
        return _response.data

    async def delete(
        self, flow_id: str, execution_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        flow_id : str
            Flows id

        execution_id : str
            Flow execution identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.executions.delete(
                flow_id="flow_id",
                execution_id="execution_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(flow_id, execution_id, request_options=request_options)
        return _response.data
