# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawVaultClient, RawVaultClient

if typing.TYPE_CHECKING:
    from .connections.client import AsyncConnectionsClient, ConnectionsClient


class VaultClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVaultClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._connections: typing.Optional[ConnectionsClient] = None

    @property
    def with_raw_response(self) -> RawVaultClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVaultClient
        """
        return self._raw_client

    @property
    def connections(self):
        if self._connections is None:
            from .connections.client import ConnectionsClient  # noqa: E402

            self._connections = ConnectionsClient(client_wrapper=self._client_wrapper)
        return self._connections


class AsyncVaultClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVaultClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._connections: typing.Optional[AsyncConnectionsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawVaultClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVaultClient
        """
        return self._raw_client

    @property
    def connections(self):
        if self._connections is None:
            from .connections.client import AsyncConnectionsClient  # noqa: E402

            self._connections = AsyncConnectionsClient(client_wrapper=self._client_wrapper)
        return self._connections
