# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.pagination import AsyncPager, SyncPager
from ....core.request_options import RequestOptions
from ....types.create_flows_vault_connection_request_content import CreateFlowsVaultConnectionRequestContent
from ....types.create_flows_vault_connection_response_content import CreateFlowsVaultConnectionResponseContent
from ....types.flows_vault_connection_summary import FlowsVaultConnectionSummary
from ....types.get_flows_vault_connection_response_content import GetFlowsVaultConnectionResponseContent
from ....types.list_flows_vault_connections_offset_paginated_response_content import (
    ListFlowsVaultConnectionsOffsetPaginatedResponseContent,
)
from ....types.update_flows_vault_connection_response_content import UpdateFlowsVaultConnectionResponseContent
from ....types.update_flows_vault_connection_setup import UpdateFlowsVaultConnectionSetup
from .raw_client import AsyncRawConnectionsClient, RawConnectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FlowsVaultConnectionSummary, ListFlowsVaultConnectionsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FlowsVaultConnectionSummary, ListFlowsVaultConnectionsOffsetPaginatedResponseContent]
            Vault connections successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.flows.vault.connections.list(
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def create(
        self,
        *,
        request: CreateFlowsVaultConnectionRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        request : CreateFlowsVaultConnectionRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFlowsVaultConnectionResponseContent
            Connection successfully created.

        Examples
        --------
        from auth0 import (
            Auth0,
            CreateFlowsVaultConnectionActivecampaignApiKey,
            FlowsVaultConnectioSetupApiKeyWithBaseUrl,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.vault.connections.create(
            request=CreateFlowsVaultConnectionActivecampaignApiKey(
                name="name",
                setup=FlowsVaultConnectioSetupApiKeyWithBaseUrl(
                    api_key="api_key",
                    base_url="base_url",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        id : str
            Flows Vault connection ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowsVaultConnectionResponseContent
            Flow vault connection successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.vault.connections.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Vault connection id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.vault.connections.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        setup: typing.Optional[UpdateFlowsVaultConnectionSetup] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        id : str
            Flows Vault connection ID

        name : typing.Optional[str]
            Flows Vault Connection name.

        setup : typing.Optional[UpdateFlowsVaultConnectionSetup]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFlowsVaultConnectionResponseContent
            Flow vault connection successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.flows.vault.connections.update(
            id="id",
        )
        """
        _response = self._raw_client.update(id, name=name, setup=setup, request_options=request_options)
        return _response.data


class AsyncConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FlowsVaultConnectionSummary, ListFlowsVaultConnectionsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FlowsVaultConnectionSummary, ListFlowsVaultConnectionsOffsetPaginatedResponseContent]
            Vault connections successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.flows.vault.connections.list(
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def create(
        self,
        *,
        request: CreateFlowsVaultConnectionRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        request : CreateFlowsVaultConnectionRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFlowsVaultConnectionResponseContent
            Connection successfully created.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            CreateFlowsVaultConnectionActivecampaignApiKey,
            FlowsVaultConnectioSetupApiKeyWithBaseUrl,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.vault.connections.create(
                request=CreateFlowsVaultConnectionActivecampaignApiKey(
                    name="name",
                    setup=FlowsVaultConnectioSetupApiKeyWithBaseUrl(
                        api_key="api_key",
                        base_url="base_url",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        id : str
            Flows Vault connection ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFlowsVaultConnectionResponseContent
            Flow vault connection successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.vault.connections.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Vault connection id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.vault.connections.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        setup: typing.Optional[UpdateFlowsVaultConnectionSetup] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFlowsVaultConnectionResponseContent:
        """
        Parameters
        ----------
        id : str
            Flows Vault connection ID

        name : typing.Optional[str]
            Flows Vault Connection name.

        setup : typing.Optional[UpdateFlowsVaultConnectionSetup]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFlowsVaultConnectionResponseContent
            Flow vault connection successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.flows.vault.connections.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, name=name, setup=setup, request_options=request_options)
        return _response.data
