# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_form_response_content import CreateFormResponseContent
from ..types.form_ending_node import FormEndingNode
from ..types.form_ending_node_nullable import FormEndingNodeNullable
from ..types.form_languages import FormLanguages
from ..types.form_languages_nullable import FormLanguagesNullable
from ..types.form_messages import FormMessages
from ..types.form_messages_nullable import FormMessagesNullable
from ..types.form_node_list import FormNodeList
from ..types.form_node_list_nullable import FormNodeListNullable
from ..types.form_start_node import FormStartNode
from ..types.form_start_node_nullable import FormStartNodeNullable
from ..types.form_style import FormStyle
from ..types.form_style_nullable import FormStyleNullable
from ..types.form_summary import FormSummary
from ..types.form_translations import FormTranslations
from ..types.form_translations_nullable import FormTranslationsNullable
from ..types.forms_request_parameters_hydrate_enum import FormsRequestParametersHydrateEnum
from ..types.get_form_response_content import GetFormResponseContent
from ..types.list_forms_offset_paginated_response_content import ListFormsOffsetPaginatedResponseContent
from ..types.update_form_response_content import UpdateFormResponseContent
from .raw_client import AsyncRawFormsClient, RawFormsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FormsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFormsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFormsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFormsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]
            Forms successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.forms.list(
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            hydrate=hydrate,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str,
        messages: typing.Optional[FormMessages] = OMIT,
        languages: typing.Optional[FormLanguages] = OMIT,
        translations: typing.Optional[FormTranslations] = OMIT,
        nodes: typing.Optional[FormNodeList] = OMIT,
        start: typing.Optional[FormStartNode] = OMIT,
        ending: typing.Optional[FormEndingNode] = OMIT,
        style: typing.Optional[FormStyle] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFormResponseContent:
        """
        Parameters
        ----------
        name : str

        messages : typing.Optional[FormMessages]

        languages : typing.Optional[FormLanguages]

        translations : typing.Optional[FormTranslations]

        nodes : typing.Optional[FormNodeList]

        start : typing.Optional[FormStartNode]

        ending : typing.Optional[FormEndingNode]

        style : typing.Optional[FormStyle]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFormResponseContent
            Form successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.forms.create(
            name="name",
        )
        """
        _response = self._raw_client.create(
            name=name,
            messages=messages,
            languages=languages,
            translations=translations,
            nodes=nodes,
            start=start,
            ending=ending,
            style=style,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFormResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the form to retrieve.

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFormResponseContent
            Form successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.forms.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, hydrate=hydrate, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            The ID of the form to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.forms.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        messages: typing.Optional[FormMessagesNullable] = OMIT,
        languages: typing.Optional[FormLanguagesNullable] = OMIT,
        translations: typing.Optional[FormTranslationsNullable] = OMIT,
        nodes: typing.Optional[FormNodeListNullable] = OMIT,
        start: typing.Optional[FormStartNodeNullable] = OMIT,
        ending: typing.Optional[FormEndingNodeNullable] = OMIT,
        style: typing.Optional[FormStyleNullable] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFormResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the form to update.

        name : typing.Optional[str]

        messages : typing.Optional[FormMessagesNullable]

        languages : typing.Optional[FormLanguagesNullable]

        translations : typing.Optional[FormTranslationsNullable]

        nodes : typing.Optional[FormNodeListNullable]

        start : typing.Optional[FormStartNodeNullable]

        ending : typing.Optional[FormEndingNodeNullable]

        style : typing.Optional[FormStyleNullable]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFormResponseContent
            Form successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.forms.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            messages=messages,
            languages=languages,
            translations=translations,
            nodes=nodes,
            start=start,
            ending=ending,
            style=style,
            request_options=request_options,
        )
        return _response.data


class AsyncFormsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFormsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFormsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFormsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]
            Forms successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.forms.list(
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            hydrate=hydrate,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str,
        messages: typing.Optional[FormMessages] = OMIT,
        languages: typing.Optional[FormLanguages] = OMIT,
        translations: typing.Optional[FormTranslations] = OMIT,
        nodes: typing.Optional[FormNodeList] = OMIT,
        start: typing.Optional[FormStartNode] = OMIT,
        ending: typing.Optional[FormEndingNode] = OMIT,
        style: typing.Optional[FormStyle] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFormResponseContent:
        """
        Parameters
        ----------
        name : str

        messages : typing.Optional[FormMessages]

        languages : typing.Optional[FormLanguages]

        translations : typing.Optional[FormTranslations]

        nodes : typing.Optional[FormNodeList]

        start : typing.Optional[FormStartNode]

        ending : typing.Optional[FormEndingNode]

        style : typing.Optional[FormStyle]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFormResponseContent
            Form successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.forms.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            messages=messages,
            languages=languages,
            translations=translations,
            nodes=nodes,
            start=start,
            ending=ending,
            style=style,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetFormResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the form to retrieve.

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetFormResponseContent
            Form successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.forms.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, hydrate=hydrate, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            The ID of the form to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.forms.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        messages: typing.Optional[FormMessagesNullable] = OMIT,
        languages: typing.Optional[FormLanguagesNullable] = OMIT,
        translations: typing.Optional[FormTranslationsNullable] = OMIT,
        nodes: typing.Optional[FormNodeListNullable] = OMIT,
        start: typing.Optional[FormStartNodeNullable] = OMIT,
        ending: typing.Optional[FormEndingNodeNullable] = OMIT,
        style: typing.Optional[FormStyleNullable] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateFormResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the form to update.

        name : typing.Optional[str]

        messages : typing.Optional[FormMessagesNullable]

        languages : typing.Optional[FormLanguagesNullable]

        translations : typing.Optional[FormTranslationsNullable]

        nodes : typing.Optional[FormNodeListNullable]

        start : typing.Optional[FormStartNodeNullable]

        ending : typing.Optional[FormEndingNodeNullable]

        style : typing.Optional[FormStyleNullable]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateFormResponseContent
            Form successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.forms.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            messages=messages,
            languages=languages,
            translations=translations,
            nodes=nodes,
            start=start,
            ending=ending,
            style=style,
            request_options=request_options,
        )
        return _response.data
