# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.create_form_response_content import CreateFormResponseContent
from ..types.form_ending_node import FormEndingNode
from ..types.form_ending_node_nullable import FormEndingNodeNullable
from ..types.form_languages import FormLanguages
from ..types.form_languages_nullable import FormLanguagesNullable
from ..types.form_messages import FormMessages
from ..types.form_messages_nullable import FormMessagesNullable
from ..types.form_node_list import FormNodeList
from ..types.form_node_list_nullable import FormNodeListNullable
from ..types.form_start_node import FormStartNode
from ..types.form_start_node_nullable import FormStartNodeNullable
from ..types.form_style import FormStyle
from ..types.form_style_nullable import FormStyleNullable
from ..types.form_summary import FormSummary
from ..types.form_translations import FormTranslations
from ..types.form_translations_nullable import FormTranslationsNullable
from ..types.forms_request_parameters_hydrate_enum import FormsRequestParametersHydrateEnum
from ..types.get_form_response_content import GetFormResponseContent
from ..types.list_forms_offset_paginated_response_content import ListFormsOffsetPaginatedResponseContent
from ..types.update_form_response_content import UpdateFormResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawFormsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]
            Forms successfully retrieved.
        """
        page = page if page is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "forms",
            method="GET",
            params={
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "hydrate": hydrate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListFormsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListFormsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.forms
                _has_next = True
                _get_next = lambda: self.list(
                    page=page + len(_items or []),
                    per_page=per_page,
                    include_totals=include_totals,
                    hydrate=hydrate,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str,
        messages: typing.Optional[FormMessages] = OMIT,
        languages: typing.Optional[FormLanguages] = OMIT,
        translations: typing.Optional[FormTranslations] = OMIT,
        nodes: typing.Optional[FormNodeList] = OMIT,
        start: typing.Optional[FormStartNode] = OMIT,
        ending: typing.Optional[FormEndingNode] = OMIT,
        style: typing.Optional[FormStyle] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateFormResponseContent]:
        """
        Parameters
        ----------
        name : str

        messages : typing.Optional[FormMessages]

        languages : typing.Optional[FormLanguages]

        translations : typing.Optional[FormTranslations]

        nodes : typing.Optional[FormNodeList]

        start : typing.Optional[FormStartNode]

        ending : typing.Optional[FormEndingNode]

        style : typing.Optional[FormStyle]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateFormResponseContent]
            Form successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "forms",
            method="POST",
            json={
                "name": name,
                "messages": convert_and_respect_annotation_metadata(
                    object_=messages, annotation=FormMessages, direction="write"
                ),
                "languages": convert_and_respect_annotation_metadata(
                    object_=languages, annotation=FormLanguages, direction="write"
                ),
                "translations": translations,
                "nodes": convert_and_respect_annotation_metadata(
                    object_=nodes, annotation=FormNodeList, direction="write"
                ),
                "start": convert_and_respect_annotation_metadata(
                    object_=start, annotation=FormStartNode, direction="write"
                ),
                "ending": convert_and_respect_annotation_metadata(
                    object_=ending, annotation=FormEndingNode, direction="write"
                ),
                "style": convert_and_respect_annotation_metadata(
                    object_=style, annotation=FormStyle, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateFormResponseContent,
                    parse_obj_as(
                        type_=CreateFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetFormResponseContent]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to retrieve.

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetFormResponseContent]
            Form successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="GET",
            params={
                "hydrate": hydrate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetFormResponseContent,
                    parse_obj_as(
                        type_=GetFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        messages: typing.Optional[FormMessagesNullable] = OMIT,
        languages: typing.Optional[FormLanguagesNullable] = OMIT,
        translations: typing.Optional[FormTranslationsNullable] = OMIT,
        nodes: typing.Optional[FormNodeListNullable] = OMIT,
        start: typing.Optional[FormStartNodeNullable] = OMIT,
        ending: typing.Optional[FormEndingNodeNullable] = OMIT,
        style: typing.Optional[FormStyleNullable] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateFormResponseContent]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to update.

        name : typing.Optional[str]

        messages : typing.Optional[FormMessagesNullable]

        languages : typing.Optional[FormLanguagesNullable]

        translations : typing.Optional[FormTranslationsNullable]

        nodes : typing.Optional[FormNodeListNullable]

        start : typing.Optional[FormStartNodeNullable]

        ending : typing.Optional[FormEndingNodeNullable]

        style : typing.Optional[FormStyleNullable]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateFormResponseContent]
            Form successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "messages": convert_and_respect_annotation_metadata(
                    object_=messages, annotation=FormMessagesNullable, direction="write"
                ),
                "languages": convert_and_respect_annotation_metadata(
                    object_=languages, annotation=FormLanguagesNullable, direction="write"
                ),
                "translations": translations,
                "nodes": convert_and_respect_annotation_metadata(
                    object_=nodes, annotation=FormNodeListNullable, direction="write"
                ),
                "start": convert_and_respect_annotation_metadata(
                    object_=start, annotation=FormStartNodeNullable, direction="write"
                ),
                "ending": convert_and_respect_annotation_metadata(
                    object_=ending, annotation=FormEndingNodeNullable, direction="write"
                ),
                "style": convert_and_respect_annotation_metadata(
                    object_=style, annotation=FormStyleNullable, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateFormResponseContent,
                    parse_obj_as(
                        type_=UpdateFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawFormsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FormSummary, ListFormsOffsetPaginatedResponseContent]
            Forms successfully retrieved.
        """
        page = page if page is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "forms",
            method="GET",
            params={
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "hydrate": hydrate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListFormsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListFormsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.forms
                _has_next = True

                async def _get_next():
                    return await self.list(
                        page=page + len(_items or []),
                        per_page=per_page,
                        include_totals=include_totals,
                        hydrate=hydrate,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str,
        messages: typing.Optional[FormMessages] = OMIT,
        languages: typing.Optional[FormLanguages] = OMIT,
        translations: typing.Optional[FormTranslations] = OMIT,
        nodes: typing.Optional[FormNodeList] = OMIT,
        start: typing.Optional[FormStartNode] = OMIT,
        ending: typing.Optional[FormEndingNode] = OMIT,
        style: typing.Optional[FormStyle] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateFormResponseContent]:
        """
        Parameters
        ----------
        name : str

        messages : typing.Optional[FormMessages]

        languages : typing.Optional[FormLanguages]

        translations : typing.Optional[FormTranslations]

        nodes : typing.Optional[FormNodeList]

        start : typing.Optional[FormStartNode]

        ending : typing.Optional[FormEndingNode]

        style : typing.Optional[FormStyle]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateFormResponseContent]
            Form successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "forms",
            method="POST",
            json={
                "name": name,
                "messages": convert_and_respect_annotation_metadata(
                    object_=messages, annotation=FormMessages, direction="write"
                ),
                "languages": convert_and_respect_annotation_metadata(
                    object_=languages, annotation=FormLanguages, direction="write"
                ),
                "translations": translations,
                "nodes": convert_and_respect_annotation_metadata(
                    object_=nodes, annotation=FormNodeList, direction="write"
                ),
                "start": convert_and_respect_annotation_metadata(
                    object_=start, annotation=FormStartNode, direction="write"
                ),
                "ending": convert_and_respect_annotation_metadata(
                    object_=ending, annotation=FormEndingNode, direction="write"
                ),
                "style": convert_and_respect_annotation_metadata(
                    object_=style, annotation=FormStyle, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateFormResponseContent,
                    parse_obj_as(
                        type_=CreateFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        id: str,
        *,
        hydrate: typing.Optional[
            typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetFormResponseContent]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to retrieve.

        hydrate : typing.Optional[typing.Union[FormsRequestParametersHydrateEnum, typing.Sequence[FormsRequestParametersHydrateEnum]]]
            Query parameter to hydrate the response with additional data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetFormResponseContent]
            Form successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="GET",
            params={
                "hydrate": hydrate,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetFormResponseContent,
                    parse_obj_as(
                        type_=GetFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        messages: typing.Optional[FormMessagesNullable] = OMIT,
        languages: typing.Optional[FormLanguagesNullable] = OMIT,
        translations: typing.Optional[FormTranslationsNullable] = OMIT,
        nodes: typing.Optional[FormNodeListNullable] = OMIT,
        start: typing.Optional[FormStartNodeNullable] = OMIT,
        ending: typing.Optional[FormEndingNodeNullable] = OMIT,
        style: typing.Optional[FormStyleNullable] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateFormResponseContent]:
        """
        Parameters
        ----------
        id : str
            The ID of the form to update.

        name : typing.Optional[str]

        messages : typing.Optional[FormMessagesNullable]

        languages : typing.Optional[FormLanguagesNullable]

        translations : typing.Optional[FormTranslationsNullable]

        nodes : typing.Optional[FormNodeListNullable]

        start : typing.Optional[FormStartNodeNullable]

        ending : typing.Optional[FormEndingNodeNullable]

        style : typing.Optional[FormStyleNullable]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateFormResponseContent]
            Form successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"forms/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "messages": convert_and_respect_annotation_metadata(
                    object_=messages, annotation=FormMessagesNullable, direction="write"
                ),
                "languages": convert_and_respect_annotation_metadata(
                    object_=languages, annotation=FormLanguagesNullable, direction="write"
                ),
                "translations": translations,
                "nodes": convert_and_respect_annotation_metadata(
                    object_=nodes, annotation=FormNodeListNullable, direction="write"
                ),
                "start": convert_and_respect_annotation_metadata(
                    object_=start, annotation=FormStartNodeNullable, direction="write"
                ),
                "ending": convert_and_respect_annotation_metadata(
                    object_=ending, annotation=FormEndingNodeNullable, direction="write"
                ),
                "style": convert_and_respect_annotation_metadata(
                    object_=style, annotation=FormStyleNullable, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateFormResponseContent,
                    parse_obj_as(
                        type_=UpdateFormResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
