# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawGuardianClient, RawGuardianClient

if typing.TYPE_CHECKING:
    from .enrollments.client import AsyncEnrollmentsClient, EnrollmentsClient
    from .factors.client import AsyncFactorsClient, FactorsClient
    from .policies.client import AsyncPoliciesClient, PoliciesClient


class GuardianClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGuardianClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._enrollments: typing.Optional[EnrollmentsClient] = None
        self._factors: typing.Optional[FactorsClient] = None
        self._policies: typing.Optional[PoliciesClient] = None

    @property
    def with_raw_response(self) -> RawGuardianClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGuardianClient
        """
        return self._raw_client

    @property
    def enrollments(self):
        if self._enrollments is None:
            from .enrollments.client import EnrollmentsClient  # noqa: E402

            self._enrollments = EnrollmentsClient(client_wrapper=self._client_wrapper)
        return self._enrollments

    @property
    def factors(self):
        if self._factors is None:
            from .factors.client import FactorsClient  # noqa: E402

            self._factors = FactorsClient(client_wrapper=self._client_wrapper)
        return self._factors

    @property
    def policies(self):
        if self._policies is None:
            from .policies.client import PoliciesClient  # noqa: E402

            self._policies = PoliciesClient(client_wrapper=self._client_wrapper)
        return self._policies


class AsyncGuardianClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGuardianClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._enrollments: typing.Optional[AsyncEnrollmentsClient] = None
        self._factors: typing.Optional[AsyncFactorsClient] = None
        self._policies: typing.Optional[AsyncPoliciesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawGuardianClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGuardianClient
        """
        return self._raw_client

    @property
    def enrollments(self):
        if self._enrollments is None:
            from .enrollments.client import AsyncEnrollmentsClient  # noqa: E402

            self._enrollments = AsyncEnrollmentsClient(client_wrapper=self._client_wrapper)
        return self._enrollments

    @property
    def factors(self):
        if self._factors is None:
            from .factors.client import AsyncFactorsClient  # noqa: E402

            self._factors = AsyncFactorsClient(client_wrapper=self._client_wrapper)
        return self._factors

    @property
    def policies(self):
        if self._policies is None:
            from .policies.client import AsyncPoliciesClient  # noqa: E402

            self._policies = AsyncPoliciesClient(client_wrapper=self._client_wrapper)
        return self._policies
