# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_guardian_enrollment_ticket_response_content import CreateGuardianEnrollmentTicketResponseContent
from ...types.get_guardian_enrollment_response_content import GetGuardianEnrollmentResponseContent
from ...types.guardian_enrollment_factor_enum import GuardianEnrollmentFactorEnum
from .raw_client import AsyncRawEnrollmentsClient, RawEnrollmentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EnrollmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEnrollmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEnrollmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEnrollmentsClient
        """
        return self._raw_client

    def create_ticket(
        self,
        *,
        user_id: str,
        email: typing.Optional[str] = OMIT,
        send_mail: typing.Optional[bool] = OMIT,
        email_locale: typing.Optional[str] = OMIT,
        factor: typing.Optional[GuardianEnrollmentFactorEnum] = OMIT,
        allow_multiple_enrollments: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateGuardianEnrollmentTicketResponseContent:
        """
        Create a <a href="https://auth0.com/docs/secure/multi-factor-authentication/auth0-guardian/create-custom-enrollment-tickets">multi-factor authentication (MFA) enrollment ticket</a>, and optionally send an email with the created ticket, to a given user.
        Create a <a href="https://auth0.com/docs/secure/multi-factor-authentication/auth0-guardian/create-custom-enrollment-tickets">multi-factor authentication (MFA) enrollment ticket</a>, and optionally send an email with the created ticket to a given user. Enrollment tickets can specify which factor users must enroll with or allow existing MFA users to enroll in additional factors.<br/>

        Note: Users cannot enroll in Email as a factor through custom enrollment tickets.

        Parameters
        ----------
        user_id : str
            user_id for the enrollment ticket

        email : typing.Optional[str]
            alternate email to which the enrollment email will be sent. Optional - by default, the email will be sent to the user's default address

        send_mail : typing.Optional[bool]
            Send an email to the user to start the enrollment

        email_locale : typing.Optional[str]
            Optional. Specify the locale of the enrollment email. Used with send_email.

        factor : typing.Optional[GuardianEnrollmentFactorEnum]

        allow_multiple_enrollments : typing.Optional[bool]
            Optional. Allows a user who has previously enrolled in MFA to enroll with additional factors.<br />Note: Parameter can only be used with Universal Login; it cannot be used with Classic Login or custom MFA pages.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateGuardianEnrollmentTicketResponseContent
            Enrollment ticket successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.enrollments.create_ticket(
            user_id="user_id",
        )
        """
        _response = self._raw_client.create_ticket(
            user_id=user_id,
            email=email,
            send_mail=send_mail,
            email_locale=email_locale,
            factor=factor,
            allow_multiple_enrollments=allow_multiple_enrollments,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianEnrollmentResponseContent:
        """
        Retrieve details, such as status and type, for a specific multi-factor authentication enrollment registered to a user account.

        Parameters
        ----------
        id : str
            ID of the enrollment to be retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianEnrollmentResponseContent
            Enrollment successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.enrollments.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove a specific multi-factor authentication (MFA) enrollment from a user's account. This allows the user to re-enroll with MFA. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/reset-user-mfa">Reset User Multi-Factor Authentication and Recovery Codes</a>.

        Parameters
        ----------
        id : str
            ID of the enrollment to be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.enrollments.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncEnrollmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEnrollmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEnrollmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEnrollmentsClient
        """
        return self._raw_client

    async def create_ticket(
        self,
        *,
        user_id: str,
        email: typing.Optional[str] = OMIT,
        send_mail: typing.Optional[bool] = OMIT,
        email_locale: typing.Optional[str] = OMIT,
        factor: typing.Optional[GuardianEnrollmentFactorEnum] = OMIT,
        allow_multiple_enrollments: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateGuardianEnrollmentTicketResponseContent:
        """
        Create a <a href="https://auth0.com/docs/secure/multi-factor-authentication/auth0-guardian/create-custom-enrollment-tickets">multi-factor authentication (MFA) enrollment ticket</a>, and optionally send an email with the created ticket, to a given user.
        Create a <a href="https://auth0.com/docs/secure/multi-factor-authentication/auth0-guardian/create-custom-enrollment-tickets">multi-factor authentication (MFA) enrollment ticket</a>, and optionally send an email with the created ticket to a given user. Enrollment tickets can specify which factor users must enroll with or allow existing MFA users to enroll in additional factors.<br/>

        Note: Users cannot enroll in Email as a factor through custom enrollment tickets.

        Parameters
        ----------
        user_id : str
            user_id for the enrollment ticket

        email : typing.Optional[str]
            alternate email to which the enrollment email will be sent. Optional - by default, the email will be sent to the user's default address

        send_mail : typing.Optional[bool]
            Send an email to the user to start the enrollment

        email_locale : typing.Optional[str]
            Optional. Specify the locale of the enrollment email. Used with send_email.

        factor : typing.Optional[GuardianEnrollmentFactorEnum]

        allow_multiple_enrollments : typing.Optional[bool]
            Optional. Allows a user who has previously enrolled in MFA to enroll with additional factors.<br />Note: Parameter can only be used with Universal Login; it cannot be used with Classic Login or custom MFA pages.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateGuardianEnrollmentTicketResponseContent
            Enrollment ticket successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.enrollments.create_ticket(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_ticket(
            user_id=user_id,
            email=email,
            send_mail=send_mail,
            email_locale=email_locale,
            factor=factor,
            allow_multiple_enrollments=allow_multiple_enrollments,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianEnrollmentResponseContent:
        """
        Retrieve details, such as status and type, for a specific multi-factor authentication enrollment registered to a user account.

        Parameters
        ----------
        id : str
            ID of the enrollment to be retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianEnrollmentResponseContent
            Enrollment successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.enrollments.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove a specific multi-factor authentication (MFA) enrollment from a user's account. This allows the user to re-enroll with MFA. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/reset-user-mfa">Reset User Multi-Factor Authentication and Recovery Codes</a>.

        Parameters
        ----------
        id : str
            ID of the enrollment to be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.enrollments.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
