# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.guardian_factor import GuardianFactor
from ...types.guardian_factor_name_enum import GuardianFactorNameEnum
from ...types.set_guardian_factor_response_content import SetGuardianFactorResponseContent
from .raw_client import AsyncRawFactorsClient, RawFactorsClient

if typing.TYPE_CHECKING:
    from .duo.client import AsyncDuoClient, DuoClient
    from .phone.client import AsyncPhoneClient, PhoneClient
    from .push_notification.client import AsyncPushNotificationClient, PushNotificationClient
    from .sms.client import AsyncSmsClient, SmsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FactorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFactorsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._phone: typing.Optional[PhoneClient] = None
        self._push_notification: typing.Optional[PushNotificationClient] = None
        self._sms: typing.Optional[SmsClient] = None
        self._duo: typing.Optional[DuoClient] = None

    @property
    def with_raw_response(self) -> RawFactorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFactorsClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[GuardianFactor]:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors">multi-factor authentication factors</a> associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GuardianFactor]
            Factors successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def set(
        self, name: GuardianFactorNameEnum, *, enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianFactorResponseContent:
        """
        Update the status (i.e., enabled or disabled) of a specific multi-factor authentication factor.

        Parameters
        ----------
        name : GuardianFactorNameEnum
            Factor name. Can be `sms`, `push-notification`, `email`, `duo` `otp` `webauthn-roaming`, `webauthn-platform`, or `recovery-code`.

        enabled : bool
            Whether this factor is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorResponseContent
            Factor updated successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.set(
            name="push-notification",
            enabled=True,
        )
        """
        _response = self._raw_client.set(name, enabled=enabled, request_options=request_options)
        return _response.data

    @property
    def phone(self):
        if self._phone is None:
            from .phone.client import PhoneClient  # noqa: E402

            self._phone = PhoneClient(client_wrapper=self._client_wrapper)
        return self._phone

    @property
    def push_notification(self):
        if self._push_notification is None:
            from .push_notification.client import PushNotificationClient  # noqa: E402

            self._push_notification = PushNotificationClient(client_wrapper=self._client_wrapper)
        return self._push_notification

    @property
    def sms(self):
        if self._sms is None:
            from .sms.client import SmsClient  # noqa: E402

            self._sms = SmsClient(client_wrapper=self._client_wrapper)
        return self._sms

    @property
    def duo(self):
        if self._duo is None:
            from .duo.client import DuoClient  # noqa: E402

            self._duo = DuoClient(client_wrapper=self._client_wrapper)
        return self._duo


class AsyncFactorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFactorsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._phone: typing.Optional[AsyncPhoneClient] = None
        self._push_notification: typing.Optional[AsyncPushNotificationClient] = None
        self._sms: typing.Optional[AsyncSmsClient] = None
        self._duo: typing.Optional[AsyncDuoClient] = None

    @property
    def with_raw_response(self) -> AsyncRawFactorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFactorsClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[GuardianFactor]:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors">multi-factor authentication factors</a> associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[GuardianFactor]
            Factors successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def set(
        self, name: GuardianFactorNameEnum, *, enabled: bool, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianFactorResponseContent:
        """
        Update the status (i.e., enabled or disabled) of a specific multi-factor authentication factor.

        Parameters
        ----------
        name : GuardianFactorNameEnum
            Factor name. Can be `sms`, `push-notification`, `email`, `duo` `otp` `webauthn-roaming`, `webauthn-platform`, or `recovery-code`.

        enabled : bool
            Whether this factor is enabled (true) or disabled (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorResponseContent
            Factor updated successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.set(
                name="push-notification",
                enabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(name, enabled=enabled, request_options=request_options)
        return _response.data

    @property
    def phone(self):
        if self._phone is None:
            from .phone.client import AsyncPhoneClient  # noqa: E402

            self._phone = AsyncPhoneClient(client_wrapper=self._client_wrapper)
        return self._phone

    @property
    def push_notification(self):
        if self._push_notification is None:
            from .push_notification.client import AsyncPushNotificationClient  # noqa: E402

            self._push_notification = AsyncPushNotificationClient(client_wrapper=self._client_wrapper)
        return self._push_notification

    @property
    def sms(self):
        if self._sms is None:
            from .sms.client import AsyncSmsClient  # noqa: E402

            self._sms = AsyncSmsClient(client_wrapper=self._client_wrapper)
        return self._sms

    @property
    def duo(self):
        if self._duo is None:
            from .duo.client import AsyncDuoClient  # noqa: E402

            self._duo = AsyncDuoClient(client_wrapper=self._client_wrapper)
        return self._duo
