# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from .....types.get_guardian_factor_duo_settings_response_content import GetGuardianFactorDuoSettingsResponseContent
from .....types.set_guardian_factor_duo_settings_response_content import SetGuardianFactorDuoSettingsResponseContent
from .....types.update_guardian_factor_duo_settings_response_content import (
    UpdateGuardianFactorDuoSettingsResponseContent,
)
from .raw_client import AsyncRawSettingsClient, RawSettingsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSettingsClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorDuoSettingsResponseContent:
        """
        Retrieves the DUO account and factor configuration.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorDuoSettingsResponseContent
            DUO settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.duo.settings.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def set(
        self,
        *,
        ikey: typing.Optional[str] = OMIT,
        skey: typing.Optional[str] = OMIT,
        host: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorDuoSettingsResponseContent:
        """
        Set the DUO account configuration and other properties specific to this factor.

        Parameters
        ----------
        ikey : typing.Optional[str]

        skey : typing.Optional[str]

        host : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorDuoSettingsResponseContent
            DUO settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.duo.settings.set()
        """
        _response = self._raw_client.set(ikey=ikey, skey=skey, host=host, request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        ikey: typing.Optional[str] = OMIT,
        skey: typing.Optional[str] = OMIT,
        host: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateGuardianFactorDuoSettingsResponseContent:
        """
        Parameters
        ----------
        ikey : typing.Optional[str]

        skey : typing.Optional[str]

        host : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateGuardianFactorDuoSettingsResponseContent
            DUO settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.duo.settings.update()
        """
        _response = self._raw_client.update(ikey=ikey, skey=skey, host=host, request_options=request_options)
        return _response.data


class AsyncSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSettingsClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorDuoSettingsResponseContent:
        """
        Retrieves the DUO account and factor configuration.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorDuoSettingsResponseContent
            DUO settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.duo.settings.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def set(
        self,
        *,
        ikey: typing.Optional[str] = OMIT,
        skey: typing.Optional[str] = OMIT,
        host: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorDuoSettingsResponseContent:
        """
        Set the DUO account configuration and other properties specific to this factor.

        Parameters
        ----------
        ikey : typing.Optional[str]

        skey : typing.Optional[str]

        host : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorDuoSettingsResponseContent
            DUO settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.duo.settings.set()


        asyncio.run(main())
        """
        _response = await self._raw_client.set(ikey=ikey, skey=skey, host=host, request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        ikey: typing.Optional[str] = OMIT,
        skey: typing.Optional[str] = OMIT,
        host: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateGuardianFactorDuoSettingsResponseContent:
        """
        Parameters
        ----------
        ikey : typing.Optional[str]

        skey : typing.Optional[str]

        host : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateGuardianFactorDuoSettingsResponseContent
            DUO settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.duo.settings.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(ikey=ikey, skey=skey, host=host, request_options=request_options)
        return _response.data
