# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.get_guardian_factor_phone_message_types_response_content import (
    GetGuardianFactorPhoneMessageTypesResponseContent,
)
from ....types.get_guardian_factor_phone_templates_response_content import (
    GetGuardianFactorPhoneTemplatesResponseContent,
)
from ....types.get_guardian_factors_provider_phone_response_content import (
    GetGuardianFactorsProviderPhoneResponseContent,
)
from ....types.get_guardian_factors_provider_phone_twilio_response_content import (
    GetGuardianFactorsProviderPhoneTwilioResponseContent,
)
from ....types.guardian_factor_phone_factor_message_type_enum import GuardianFactorPhoneFactorMessageTypeEnum
from ....types.guardian_factors_provider_sms_provider_enum import GuardianFactorsProviderSmsProviderEnum
from ....types.set_guardian_factor_phone_message_types_response_content import (
    SetGuardianFactorPhoneMessageTypesResponseContent,
)
from ....types.set_guardian_factor_phone_templates_response_content import (
    SetGuardianFactorPhoneTemplatesResponseContent,
)
from ....types.set_guardian_factors_provider_phone_response_content import (
    SetGuardianFactorsProviderPhoneResponseContent,
)
from ....types.set_guardian_factors_provider_phone_twilio_response_content import (
    SetGuardianFactorsProviderPhoneTwilioResponseContent,
)
from .raw_client import AsyncRawPhoneClient, RawPhoneClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PhoneClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPhoneClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPhoneClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPhoneClient
        """
        return self._raw_client

    def get_message_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorPhoneMessageTypesResponseContent:
        """
        Retrieve list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorPhoneMessageTypesResponseContent
            Returns the enabled phone factors

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.get_message_types()
        """
        _response = self._raw_client.get_message_types(request_options=request_options)
        return _response.data

    def set_message_types(
        self,
        *,
        message_types: typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorPhoneMessageTypesResponseContent:
        """
        Replace the list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        message_types : typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum]
            The list of phone factors to enable on the tenant. Can include `sms` and `voice`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorPhoneMessageTypesResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.set_message_types(
            message_types=["sms"],
        )
        """
        _response = self._raw_client.set_message_types(message_types=message_types, request_options=request_options)
        return _response.data

    def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPhoneTwilioResponseContent:
        """
        Retrieve configuration details for a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPhoneTwilioResponseContent
            Twilio Phone configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.get_twilio_provider()
        """
        _response = self._raw_client.get_twilio_provider(request_options=request_options)
        return _response.data

    def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPhoneTwilioResponseContent:
        """
        Update the configuration of a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPhoneTwilioResponseContent
            Twilio Phone configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.set_twilio_provider()
        """
        _response = self._raw_client.set_twilio_provider(
            from_=from_,
            messaging_service_sid=messaging_service_sid,
            auth_token=auth_token,
            sid=sid,
            request_options=request_options,
        )
        return _response.data

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPhoneResponseContent:
        """
        Retrieve details of the multi-factor authentication phone provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPhoneResponseContent
            Returns selected Phone provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.get_selected_provider()
        """
        _response = self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPhoneResponseContent:
        """
        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPhoneResponseContent
            Returns selected Phone provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.set_provider(
            provider="auth0",
        )
        """
        _response = self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data

    def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorPhoneTemplatesResponseContent:
        """
        Retrieve details of the multi-factor authentication enrollment and verification templates for phone-type factors available in your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorPhoneTemplatesResponseContent
            Phone enrollment and verification templates successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.get_templates()
        """
        _response = self._raw_client.get_templates(request_options=request_options)
        return _response.data

    def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorPhoneTemplatesResponseContent:
        """
        Customize the messages sent to complete phone enrollment and verification (subscription required).

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorPhoneTemplatesResponseContent
            Phone enrollment and verification templates successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.phone.set_templates(
            enrollment_message="enrollment_message",
            verification_message="verification_message",
        )
        """
        _response = self._raw_client.set_templates(
            enrollment_message=enrollment_message,
            verification_message=verification_message,
            request_options=request_options,
        )
        return _response.data


class AsyncPhoneClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPhoneClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPhoneClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPhoneClient
        """
        return self._raw_client

    async def get_message_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorPhoneMessageTypesResponseContent:
        """
        Retrieve list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorPhoneMessageTypesResponseContent
            Returns the enabled phone factors

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.get_message_types()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_message_types(request_options=request_options)
        return _response.data

    async def set_message_types(
        self,
        *,
        message_types: typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorPhoneMessageTypesResponseContent:
        """
        Replace the list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        message_types : typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum]
            The list of phone factors to enable on the tenant. Can include `sms` and `voice`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorPhoneMessageTypesResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.set_message_types(
                message_types=["sms"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_message_types(
            message_types=message_types, request_options=request_options
        )
        return _response.data

    async def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPhoneTwilioResponseContent:
        """
        Retrieve configuration details for a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPhoneTwilioResponseContent
            Twilio Phone configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.get_twilio_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_twilio_provider(request_options=request_options)
        return _response.data

    async def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPhoneTwilioResponseContent:
        """
        Update the configuration of a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPhoneTwilioResponseContent
            Twilio Phone configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.set_twilio_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_twilio_provider(
            from_=from_,
            messaging_service_sid=messaging_service_sid,
            auth_token=auth_token,
            sid=sid,
            request_options=request_options,
        )
        return _response.data

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPhoneResponseContent:
        """
        Retrieve details of the multi-factor authentication phone provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPhoneResponseContent
            Returns selected Phone provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.get_selected_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPhoneResponseContent:
        """
        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPhoneResponseContent
            Returns selected Phone provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.set_provider(
                provider="auth0",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data

    async def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorPhoneTemplatesResponseContent:
        """
        Retrieve details of the multi-factor authentication enrollment and verification templates for phone-type factors available in your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorPhoneTemplatesResponseContent
            Phone enrollment and verification templates successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.get_templates()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_templates(request_options=request_options)
        return _response.data

    async def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorPhoneTemplatesResponseContent:
        """
        Customize the messages sent to complete phone enrollment and verification (subscription required).

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorPhoneTemplatesResponseContent
            Phone enrollment and verification templates successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.phone.set_templates(
                enrollment_message="enrollment_message",
                verification_message="verification_message",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_templates(
            enrollment_message=enrollment_message,
            verification_message=verification_message,
            request_options=request_options,
        )
        return _response.data
