# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ....core.api_error import ApiError
from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.http_response import AsyncHttpResponse, HttpResponse
from ....core.pydantic_utilities import parse_obj_as
from ....core.request_options import RequestOptions
from ....errors.bad_request_error import BadRequestError
from ....errors.forbidden_error import ForbiddenError
from ....errors.not_found_error import NotFoundError
from ....errors.unauthorized_error import UnauthorizedError
from ....types.get_guardian_factor_phone_message_types_response_content import (
    GetGuardianFactorPhoneMessageTypesResponseContent,
)
from ....types.get_guardian_factor_phone_templates_response_content import (
    GetGuardianFactorPhoneTemplatesResponseContent,
)
from ....types.get_guardian_factors_provider_phone_response_content import (
    GetGuardianFactorsProviderPhoneResponseContent,
)
from ....types.get_guardian_factors_provider_phone_twilio_response_content import (
    GetGuardianFactorsProviderPhoneTwilioResponseContent,
)
from ....types.guardian_factor_phone_factor_message_type_enum import GuardianFactorPhoneFactorMessageTypeEnum
from ....types.guardian_factors_provider_sms_provider_enum import GuardianFactorsProviderSmsProviderEnum
from ....types.set_guardian_factor_phone_message_types_response_content import (
    SetGuardianFactorPhoneMessageTypesResponseContent,
)
from ....types.set_guardian_factor_phone_templates_response_content import (
    SetGuardianFactorPhoneTemplatesResponseContent,
)
from ....types.set_guardian_factors_provider_phone_response_content import (
    SetGuardianFactorsProviderPhoneResponseContent,
)
from ....types.set_guardian_factors_provider_phone_twilio_response_content import (
    SetGuardianFactorsProviderPhoneTwilioResponseContent,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPhoneClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_message_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorPhoneMessageTypesResponseContent]:
        """
        Retrieve list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorPhoneMessageTypesResponseContent]
            Returns the enabled phone factors
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/message-types",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorPhoneMessageTypesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorPhoneMessageTypesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_message_types(
        self,
        *,
        message_types: typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorPhoneMessageTypesResponseContent]:
        """
        Replace the list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        message_types : typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum]
            The list of phone factors to enable on the tenant. Can include `sms` and `voice`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorPhoneMessageTypesResponseContent]
            Returns selected SMS provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/message-types",
            method="PUT",
            json={
                "message_types": message_types,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorPhoneMessageTypesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorPhoneMessageTypesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderPhoneTwilioResponseContent]:
        """
        Retrieve configuration details for a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderPhoneTwilioResponseContent]
            Twilio Phone configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/providers/twilio",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPhoneTwilioResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPhoneTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPhoneTwilioResponseContent]:
        """
        Update the configuration of a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPhoneTwilioResponseContent]
            Twilio Phone configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/providers/twilio",
            method="PUT",
            json={
                "from": from_,
                "messaging_service_sid": messaging_service_sid,
                "auth_token": auth_token,
                "sid": sid,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPhoneTwilioResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPhoneTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderPhoneResponseContent]:
        """
        Retrieve details of the multi-factor authentication phone provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderPhoneResponseContent]
            Returns selected Phone provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPhoneResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPhoneResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPhoneResponseContent]:
        """
        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPhoneResponseContent]
            Returns selected Phone provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPhoneResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPhoneResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorPhoneTemplatesResponseContent]:
        """
        Retrieve details of the multi-factor authentication enrollment and verification templates for phone-type factors available in your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorPhoneTemplatesResponseContent]
            Phone enrollment and verification templates successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorPhoneTemplatesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorPhoneTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorPhoneTemplatesResponseContent]:
        """
        Customize the messages sent to complete phone enrollment and verification (subscription required).

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorPhoneTemplatesResponseContent]
            Phone enrollment and verification templates successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/templates",
            method="PUT",
            json={
                "enrollment_message": enrollment_message,
                "verification_message": verification_message,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorPhoneTemplatesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorPhoneTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPhoneClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_message_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorPhoneMessageTypesResponseContent]:
        """
        Retrieve list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorPhoneMessageTypesResponseContent]
            Returns the enabled phone factors
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/message-types",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorPhoneMessageTypesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorPhoneMessageTypesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_message_types(
        self,
        *,
        message_types: typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorPhoneMessageTypesResponseContent]:
        """
        Replace the list of <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">phone-type MFA factors</a> (i.e., sms and voice) that are enabled for your tenant.

        Parameters
        ----------
        message_types : typing.Sequence[GuardianFactorPhoneFactorMessageTypeEnum]
            The list of phone factors to enable on the tenant. Can include `sms` and `voice`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorPhoneMessageTypesResponseContent]
            Returns selected SMS provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/message-types",
            method="PUT",
            json={
                "message_types": message_types,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorPhoneMessageTypesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorPhoneMessageTypesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderPhoneTwilioResponseContent]:
        """
        Retrieve configuration details for a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderPhoneTwilioResponseContent]
            Twilio Phone configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/providers/twilio",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPhoneTwilioResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPhoneTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPhoneTwilioResponseContent]:
        """
        Update the configuration of a Twilio phone provider that has been set up in your tenant. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-sms-voice-notifications-mfa">Configure SMS and Voice Notifications for MFA</a>.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPhoneTwilioResponseContent]
            Twilio Phone configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/providers/twilio",
            method="PUT",
            json={
                "from": from_,
                "messaging_service_sid": messaging_service_sid,
                "auth_token": auth_token,
                "sid": sid,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPhoneTwilioResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPhoneTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderPhoneResponseContent]:
        """
        Retrieve details of the multi-factor authentication phone provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderPhoneResponseContent]
            Returns selected Phone provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPhoneResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPhoneResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPhoneResponseContent]:
        """
        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPhoneResponseContent]
            Returns selected Phone provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPhoneResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPhoneResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorPhoneTemplatesResponseContent]:
        """
        Retrieve details of the multi-factor authentication enrollment and verification templates for phone-type factors available in your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorPhoneTemplatesResponseContent]
            Phone enrollment and verification templates successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorPhoneTemplatesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorPhoneTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorPhoneTemplatesResponseContent]:
        """
        Customize the messages sent to complete phone enrollment and verification (subscription required).

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorPhoneTemplatesResponseContent]
            Phone enrollment and verification templates successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/phone/templates",
            method="PUT",
            json={
                "enrollment_message": enrollment_message,
                "verification_message": verification_message,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorPhoneTemplatesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorPhoneTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
