# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.get_guardian_factors_provider_apns_response_content import GetGuardianFactorsProviderApnsResponseContent
from ....types.get_guardian_factors_provider_push_notification_response_content import (
    GetGuardianFactorsProviderPushNotificationResponseContent,
)
from ....types.get_guardian_factors_provider_sns_response_content import GetGuardianFactorsProviderSnsResponseContent
from ....types.guardian_factors_provider_push_notification_provider_data_enum import (
    GuardianFactorsProviderPushNotificationProviderDataEnum,
)
from ....types.set_guardian_factors_provider_push_notification_apns_response_content import (
    SetGuardianFactorsProviderPushNotificationApnsResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_fcm_response_content import (
    SetGuardianFactorsProviderPushNotificationFcmResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_fcmv_1_response_content import (
    SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_response_content import (
    SetGuardianFactorsProviderPushNotificationResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_sns_response_content import (
    SetGuardianFactorsProviderPushNotificationSnsResponseContent,
)
from ....types.update_guardian_factors_provider_push_notification_sns_response_content import (
    UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,
)
from .raw_client import AsyncRawPushNotificationClient, RawPushNotificationClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PushNotificationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPushNotificationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPushNotificationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPushNotificationClient
        """
        return self._raw_client

    def get_apns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderApnsResponseContent:
        """
        Retrieve configuration details for the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderApnsResponseContent
            APNS configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.get_apns_provider()
        """
        _response = self._raw_client.get_apns_provider(request_options=request_options)
        return _response.data

    def set_apns_provider(
        self,
        *,
        sandbox: typing.Optional[bool] = OMIT,
        bundle_id: typing.Optional[str] = OMIT,
        p_12: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationApnsResponseContent:
        """
        Modify configuration details of the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        sandbox : typing.Optional[bool]

        bundle_id : typing.Optional[str]

        p_12 : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationApnsResponseContent
            APNS configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.set_apns_provider()
        """
        _response = self._raw_client.set_apns_provider(
            sandbox=sandbox, bundle_id=bundle_id, p_12=p_12, request_options=request_options
        )
        return _response.data

    def set_fcm_provider(
        self, *, server_key: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianFactorsProviderPushNotificationFcmResponseContent:
        """
        Modify configuration details of the multi-factor authentication FCM provider associated with your tenant.

        Parameters
        ----------
        server_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationFcmResponseContent
            FCM configuration updated

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.set_fcm_provider()
        """
        _response = self._raw_client.set_fcm_provider(server_key=server_key, request_options=request_options)
        return _response.data

    def set_fcmv_1_provider(
        self,
        *,
        server_credentials: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent:
        """
        Modify configuration details of the multi-factor authentication FCMV1 provider associated with your tenant.

        Parameters
        ----------
        server_credentials : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent
            FCMV1 configuration updated

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.set_fcmv_1_provider()
        """
        _response = self._raw_client.set_fcmv_1_provider(
            server_credentials=server_credentials, request_options=request_options
        )
        return _response.data

    def get_sns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSnsResponseContent:
        """
        Retrieve configuration details for an AWS SNS push notification provider that has been enabled for MFA. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSnsResponseContent
            AWS SNS configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.get_sns_provider()
        """
        _response = self._raw_client.get_sns_provider(request_options=request_options)
        return _response.data

    def set_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationSnsResponseContent:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationSnsResponseContent
            AWS SNS configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.set_sns_provider()
        """
        _response = self._raw_client.set_sns_provider(
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_region=aws_region,
            sns_apns_platform_application_arn=sns_apns_platform_application_arn,
            sns_gcm_platform_application_arn=sns_gcm_platform_application_arn,
            request_options=request_options,
        )
        return _response.data

    def update_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateGuardianFactorsProviderPushNotificationSnsResponseContent:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateGuardianFactorsProviderPushNotificationSnsResponseContent
            AWS SNS configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.update_sns_provider()
        """
        _response = self._raw_client.update_sns_provider(
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_region=aws_region,
            sns_apns_platform_application_arn=sns_apns_platform_application_arn,
            sns_gcm_platform_application_arn=sns_gcm_platform_application_arn,
            request_options=request_options,
        )
        return _response.data

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPushNotificationResponseContent:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPushNotificationResponseContent
            Returns selected push notification provider

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.get_selected_provider()
        """
        _response = self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderPushNotificationProviderDataEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationResponseContent:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        provider : GuardianFactorsProviderPushNotificationProviderDataEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationResponseContent
            Returns selected push notification provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.push_notification.set_provider(
            provider="guardian",
        )
        """
        _response = self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data


class AsyncPushNotificationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPushNotificationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPushNotificationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPushNotificationClient
        """
        return self._raw_client

    async def get_apns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderApnsResponseContent:
        """
        Retrieve configuration details for the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderApnsResponseContent
            APNS configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.get_apns_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_apns_provider(request_options=request_options)
        return _response.data

    async def set_apns_provider(
        self,
        *,
        sandbox: typing.Optional[bool] = OMIT,
        bundle_id: typing.Optional[str] = OMIT,
        p_12: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationApnsResponseContent:
        """
        Modify configuration details of the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        sandbox : typing.Optional[bool]

        bundle_id : typing.Optional[str]

        p_12 : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationApnsResponseContent
            APNS configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.set_apns_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_apns_provider(
            sandbox=sandbox, bundle_id=bundle_id, p_12=p_12, request_options=request_options
        )
        return _response.data

    async def set_fcm_provider(
        self, *, server_key: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianFactorsProviderPushNotificationFcmResponseContent:
        """
        Modify configuration details of the multi-factor authentication FCM provider associated with your tenant.

        Parameters
        ----------
        server_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationFcmResponseContent
            FCM configuration updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.set_fcm_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_fcm_provider(server_key=server_key, request_options=request_options)
        return _response.data

    async def set_fcmv_1_provider(
        self,
        *,
        server_credentials: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent:
        """
        Modify configuration details of the multi-factor authentication FCMV1 provider associated with your tenant.

        Parameters
        ----------
        server_credentials : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent
            FCMV1 configuration updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.set_fcmv_1_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_fcmv_1_provider(
            server_credentials=server_credentials, request_options=request_options
        )
        return _response.data

    async def get_sns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSnsResponseContent:
        """
        Retrieve configuration details for an AWS SNS push notification provider that has been enabled for MFA. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSnsResponseContent
            AWS SNS configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.get_sns_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_sns_provider(request_options=request_options)
        return _response.data

    async def set_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationSnsResponseContent:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationSnsResponseContent
            AWS SNS configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.set_sns_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_sns_provider(
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_region=aws_region,
            sns_apns_platform_application_arn=sns_apns_platform_application_arn,
            sns_gcm_platform_application_arn=sns_gcm_platform_application_arn,
            request_options=request_options,
        )
        return _response.data

    async def update_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateGuardianFactorsProviderPushNotificationSnsResponseContent:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateGuardianFactorsProviderPushNotificationSnsResponseContent
            AWS SNS configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.update_sns_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.update_sns_provider(
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_region=aws_region,
            sns_apns_platform_application_arn=sns_apns_platform_application_arn,
            sns_gcm_platform_application_arn=sns_gcm_platform_application_arn,
            request_options=request_options,
        )
        return _response.data

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderPushNotificationResponseContent:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderPushNotificationResponseContent
            Returns selected push notification provider

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.get_selected_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderPushNotificationProviderDataEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderPushNotificationResponseContent:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        provider : GuardianFactorsProviderPushNotificationProviderDataEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderPushNotificationResponseContent
            Returns selected push notification provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.push_notification.set_provider(
                provider="guardian",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data
