# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ....core.api_error import ApiError
from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.http_response import AsyncHttpResponse, HttpResponse
from ....core.pydantic_utilities import parse_obj_as
from ....core.request_options import RequestOptions
from ....errors.bad_request_error import BadRequestError
from ....errors.forbidden_error import ForbiddenError
from ....errors.unauthorized_error import UnauthorizedError
from ....types.get_guardian_factors_provider_apns_response_content import GetGuardianFactorsProviderApnsResponseContent
from ....types.get_guardian_factors_provider_push_notification_response_content import (
    GetGuardianFactorsProviderPushNotificationResponseContent,
)
from ....types.get_guardian_factors_provider_sns_response_content import GetGuardianFactorsProviderSnsResponseContent
from ....types.guardian_factors_provider_push_notification_provider_data_enum import (
    GuardianFactorsProviderPushNotificationProviderDataEnum,
)
from ....types.set_guardian_factors_provider_push_notification_apns_response_content import (
    SetGuardianFactorsProviderPushNotificationApnsResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_fcm_response_content import (
    SetGuardianFactorsProviderPushNotificationFcmResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_fcmv_1_response_content import (
    SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_response_content import (
    SetGuardianFactorsProviderPushNotificationResponseContent,
)
from ....types.set_guardian_factors_provider_push_notification_sns_response_content import (
    SetGuardianFactorsProviderPushNotificationSnsResponseContent,
)
from ....types.update_guardian_factors_provider_push_notification_sns_response_content import (
    UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPushNotificationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_apns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderApnsResponseContent]:
        """
        Retrieve configuration details for the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderApnsResponseContent]
            APNS configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/apns",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderApnsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderApnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_apns_provider(
        self,
        *,
        sandbox: typing.Optional[bool] = OMIT,
        bundle_id: typing.Optional[str] = OMIT,
        p_12: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPushNotificationApnsResponseContent]:
        """
        Modify configuration details of the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        sandbox : typing.Optional[bool]

        bundle_id : typing.Optional[str]

        p_12 : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPushNotificationApnsResponseContent]
            APNS configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/apns",
            method="PATCH",
            json={
                "sandbox": sandbox,
                "bundle_id": bundle_id,
                "p12": p_12,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationApnsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationApnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_fcm_provider(
        self, *, server_key: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SetGuardianFactorsProviderPushNotificationFcmResponseContent]:
        """
        Modify configuration details of the multi-factor authentication FCM provider associated with your tenant.

        Parameters
        ----------
        server_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPushNotificationFcmResponseContent]
            FCM configuration updated
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/fcm",
            method="PATCH",
            json={
                "server_key": server_key,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationFcmResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationFcmResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_fcmv_1_provider(
        self,
        *,
        server_credentials: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent]:
        """
        Modify configuration details of the multi-factor authentication FCMV1 provider associated with your tenant.

        Parameters
        ----------
        server_credentials : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent]
            FCMV1 configuration updated
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/fcmv1",
            method="PATCH",
            json={
                "server_credentials": server_credentials,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_sns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderSnsResponseContent]:
        """
        Retrieve configuration details for an AWS SNS push notification provider that has been enabled for MFA. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderSnsResponseContent]
            AWS SNS configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSnsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPushNotificationSnsResponseContent]:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPushNotificationSnsResponseContent]
            AWS SNS configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="PUT",
            json={
                "aws_access_key_id": aws_access_key_id,
                "aws_secret_access_key": aws_secret_access_key,
                "aws_region": aws_region,
                "sns_apns_platform_application_arn": sns_apns_platform_application_arn,
                "sns_gcm_platform_application_arn": sns_gcm_platform_application_arn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationSnsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateGuardianFactorsProviderPushNotificationSnsResponseContent]:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateGuardianFactorsProviderPushNotificationSnsResponseContent]
            AWS SNS configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="PATCH",
            json={
                "aws_access_key_id": aws_access_key_id,
                "aws_secret_access_key": aws_secret_access_key,
                "aws_region": aws_region,
                "sns_apns_platform_application_arn": sns_apns_platform_application_arn,
                "sns_gcm_platform_application_arn": sns_gcm_platform_application_arn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,
                    parse_obj_as(
                        type_=UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderPushNotificationResponseContent]:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderPushNotificationResponseContent]
            Returns selected push notification provider
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPushNotificationResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPushNotificationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderPushNotificationProviderDataEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderPushNotificationResponseContent]:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        provider : GuardianFactorsProviderPushNotificationProviderDataEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderPushNotificationResponseContent]
            Returns selected push notification provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPushNotificationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_apns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderApnsResponseContent]:
        """
        Retrieve configuration details for the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderApnsResponseContent]
            APNS configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/apns",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderApnsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderApnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_apns_provider(
        self,
        *,
        sandbox: typing.Optional[bool] = OMIT,
        bundle_id: typing.Optional[str] = OMIT,
        p_12: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationApnsResponseContent]:
        """
        Modify configuration details of the multi-factor authentication APNS provider associated with your tenant.

        Parameters
        ----------
        sandbox : typing.Optional[bool]

        bundle_id : typing.Optional[str]

        p_12 : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationApnsResponseContent]
            APNS configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/apns",
            method="PATCH",
            json={
                "sandbox": sandbox,
                "bundle_id": bundle_id,
                "p12": p_12,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationApnsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationApnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_fcm_provider(
        self, *, server_key: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationFcmResponseContent]:
        """
        Modify configuration details of the multi-factor authentication FCM provider associated with your tenant.

        Parameters
        ----------
        server_key : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationFcmResponseContent]
            FCM configuration updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/fcm",
            method="PATCH",
            json={
                "server_key": server_key,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationFcmResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationFcmResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_fcmv_1_provider(
        self,
        *,
        server_credentials: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent]:
        """
        Modify configuration details of the multi-factor authentication FCMV1 provider associated with your tenant.

        Parameters
        ----------
        server_credentials : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent]
            FCMV1 configuration updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/fcmv1",
            method="PATCH",
            json={
                "server_credentials": server_credentials,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationFcmv1ResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_sns_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderSnsResponseContent]:
        """
        Retrieve configuration details for an AWS SNS push notification provider that has been enabled for MFA. To learn more, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderSnsResponseContent]
            AWS SNS configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSnsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationSnsResponseContent]:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationSnsResponseContent]
            AWS SNS configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="PUT",
            json={
                "aws_access_key_id": aws_access_key_id,
                "aws_secret_access_key": aws_secret_access_key,
                "aws_region": aws_region,
                "sns_apns_platform_application_arn": sns_apns_platform_application_arn,
                "sns_gcm_platform_application_arn": sns_gcm_platform_application_arn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationSnsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_sns_provider(
        self,
        *,
        aws_access_key_id: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        aws_secret_access_key: typing.Optional[str] = "B1ER5JHDGJL3C4sVAKK7SBsq806R3IpL",
        aws_region: typing.Optional[str] = "us-west-1",
        sns_apns_platform_application_arn: typing.Optional[str] = OMIT,
        sns_gcm_platform_application_arn: typing.Optional[str] = "urn://yRMeBxgcCXh8MeTXPBAxhQnm6gP6f5nP",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateGuardianFactorsProviderPushNotificationSnsResponseContent]:
        """
        Configure the <a href="https://auth0.com/docs/multifactor-authentication/developer/sns-configuration">AWS SNS push notification provider configuration</a> (subscription required).

        Parameters
        ----------
        aws_access_key_id : typing.Optional[str]

        aws_secret_access_key : typing.Optional[str]

        aws_region : typing.Optional[str]

        sns_apns_platform_application_arn : typing.Optional[str]

        sns_gcm_platform_application_arn : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateGuardianFactorsProviderPushNotificationSnsResponseContent]
            AWS SNS configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/providers/sns",
            method="PATCH",
            json={
                "aws_access_key_id": aws_access_key_id,
                "aws_secret_access_key": aws_secret_access_key,
                "aws_region": aws_region,
                "sns_apns_platform_application_arn": sns_apns_platform_application_arn,
                "sns_gcm_platform_application_arn": sns_gcm_platform_application_arn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,
                    parse_obj_as(
                        type_=UpdateGuardianFactorsProviderPushNotificationSnsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderPushNotificationResponseContent]:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderPushNotificationResponseContent]
            Returns selected push notification provider
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderPushNotificationResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderPushNotificationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderPushNotificationProviderDataEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationResponseContent]:
        """
        Modify the push notification provider configured for your tenant. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors/configure-push-notifications-for-mfa">Configure Push Notifications for MFA</a>.

        Parameters
        ----------
        provider : GuardianFactorsProviderPushNotificationProviderDataEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderPushNotificationResponseContent]
            Returns selected push notification provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/push-notification/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderPushNotificationResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderPushNotificationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
