# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.get_guardian_factor_sms_templates_response_content import GetGuardianFactorSmsTemplatesResponseContent
from ....types.get_guardian_factors_provider_sms_response_content import GetGuardianFactorsProviderSmsResponseContent
from ....types.get_guardian_factors_provider_sms_twilio_response_content import (
    GetGuardianFactorsProviderSmsTwilioResponseContent,
)
from ....types.guardian_factors_provider_sms_provider_enum import GuardianFactorsProviderSmsProviderEnum
from ....types.set_guardian_factor_sms_templates_response_content import SetGuardianFactorSmsTemplatesResponseContent
from ....types.set_guardian_factors_provider_sms_response_content import SetGuardianFactorsProviderSmsResponseContent
from ....types.set_guardian_factors_provider_sms_twilio_response_content import (
    SetGuardianFactorsProviderSmsTwilioResponseContent,
)
from .raw_client import AsyncRawSmsClient, RawSmsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SmsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSmsClient
        """
        return self._raw_client

    def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSmsTwilioResponseContent:
        """
        Retrieve the <a href="https://auth0.com/docs/multifactor-authentication/twilio-configuration">Twilio SMS provider configuration</a> (subscription required).

            A new endpoint is available to retrieve the Twilio configuration related to phone factors (<a href='https://auth0.com/docs/api/management/v2/#!/Guardian/get_twilio'>phone Twilio configuration</a>). It has the same payload as this one. Please use it instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSmsTwilioResponseContent
            Twilio SMS configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.get_twilio_provider()
        """
        _response = self._raw_client.get_twilio_provider(request_options=request_options)
        return _response.data

    def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderSmsTwilioResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-twilio">Update Twilio phone configuration</a> endpoint.

            <b>Previous functionality</b>: Update the Twilio SMS provider configuration.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderSmsTwilioResponseContent
            Twilio SMS configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.set_twilio_provider()
        """
        _response = self._raw_client.set_twilio_provider(
            from_=from_,
            messaging_service_sid=messaging_service_sid,
            auth_token=auth_token,
            sid=sid,
            request_options=request_options,
        )
        return _response.data

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSmsResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-phone-providers">Retrieve phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Retrieve details for the multi-factor authentication SMS provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSmsResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.get_selected_provider()
        """
        _response = self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderSmsResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-phone-providers">Update phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Update the multi-factor authentication SMS provider configuration in your tenant.

        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderSmsResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.set_provider(
            provider="auth0",
        )
        """
        _response = self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data

    def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorSmsTemplatesResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-factor-phone-templates">Retrieve enrollment and verification phone templates</a> endpoint instead.

            <b>Previous function</b>: Retrieve details of SMS enrollment and verification templates configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorSmsTemplatesResponseContent
            SMS enrollment and verification templates successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.get_templates()
        """
        _response = self._raw_client.get_templates(request_options=request_options)
        return _response.data

    def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorSmsTemplatesResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-factor-phone-templates">Update enrollment and verification phone templates</a> endpoint instead.

            <b>Previous functionality</b>: Customize the messages sent to complete SMS enrollment and verification.

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorSmsTemplatesResponseContent
            SMS enrollment and verification templates successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.factors.sms.set_templates(
            enrollment_message="enrollment_message",
            verification_message="verification_message",
        )
        """
        _response = self._raw_client.set_templates(
            enrollment_message=enrollment_message,
            verification_message=verification_message,
            request_options=request_options,
        )
        return _response.data


class AsyncSmsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSmsClient
        """
        return self._raw_client

    async def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSmsTwilioResponseContent:
        """
        Retrieve the <a href="https://auth0.com/docs/multifactor-authentication/twilio-configuration">Twilio SMS provider configuration</a> (subscription required).

            A new endpoint is available to retrieve the Twilio configuration related to phone factors (<a href='https://auth0.com/docs/api/management/v2/#!/Guardian/get_twilio'>phone Twilio configuration</a>). It has the same payload as this one. Please use it instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSmsTwilioResponseContent
            Twilio SMS configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.get_twilio_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_twilio_provider(request_options=request_options)
        return _response.data

    async def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderSmsTwilioResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-twilio">Update Twilio phone configuration</a> endpoint.

            <b>Previous functionality</b>: Update the Twilio SMS provider configuration.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderSmsTwilioResponseContent
            Twilio SMS configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.set_twilio_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.set_twilio_provider(
            from_=from_,
            messaging_service_sid=messaging_service_sid,
            auth_token=auth_token,
            sid=sid,
            request_options=request_options,
        )
        return _response.data

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorsProviderSmsResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-phone-providers">Retrieve phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Retrieve details for the multi-factor authentication SMS provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorsProviderSmsResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.get_selected_provider()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_selected_provider(request_options=request_options)
        return _response.data

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorsProviderSmsResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-phone-providers">Update phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Update the multi-factor authentication SMS provider configuration in your tenant.

        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorsProviderSmsResponseContent
            Returns selected SMS provider configuration

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.set_provider(
                provider="auth0",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_provider(provider=provider, request_options=request_options)
        return _response.data

    async def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetGuardianFactorSmsTemplatesResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-factor-phone-templates">Retrieve enrollment and verification phone templates</a> endpoint instead.

            <b>Previous function</b>: Retrieve details of SMS enrollment and verification templates configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetGuardianFactorSmsTemplatesResponseContent
            SMS enrollment and verification templates successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.get_templates()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_templates(request_options=request_options)
        return _response.data

    async def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetGuardianFactorSmsTemplatesResponseContent:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-factor-phone-templates">Update enrollment and verification phone templates</a> endpoint instead.

            <b>Previous functionality</b>: Customize the messages sent to complete SMS enrollment and verification.

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianFactorSmsTemplatesResponseContent
            SMS enrollment and verification templates successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.factors.sms.set_templates(
                enrollment_message="enrollment_message",
                verification_message="verification_message",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_templates(
            enrollment_message=enrollment_message,
            verification_message=verification_message,
            request_options=request_options,
        )
        return _response.data
