# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ....core.api_error import ApiError
from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.http_response import AsyncHttpResponse, HttpResponse
from ....core.pydantic_utilities import parse_obj_as
from ....core.request_options import RequestOptions
from ....errors.bad_request_error import BadRequestError
from ....errors.forbidden_error import ForbiddenError
from ....errors.unauthorized_error import UnauthorizedError
from ....types.get_guardian_factor_sms_templates_response_content import GetGuardianFactorSmsTemplatesResponseContent
from ....types.get_guardian_factors_provider_sms_response_content import GetGuardianFactorsProviderSmsResponseContent
from ....types.get_guardian_factors_provider_sms_twilio_response_content import (
    GetGuardianFactorsProviderSmsTwilioResponseContent,
)
from ....types.guardian_factors_provider_sms_provider_enum import GuardianFactorsProviderSmsProviderEnum
from ....types.set_guardian_factor_sms_templates_response_content import SetGuardianFactorSmsTemplatesResponseContent
from ....types.set_guardian_factors_provider_sms_response_content import SetGuardianFactorsProviderSmsResponseContent
from ....types.set_guardian_factors_provider_sms_twilio_response_content import (
    SetGuardianFactorsProviderSmsTwilioResponseContent,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSmsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderSmsTwilioResponseContent]:
        """
        Retrieve the <a href="https://auth0.com/docs/multifactor-authentication/twilio-configuration">Twilio SMS provider configuration</a> (subscription required).

            A new endpoint is available to retrieve the Twilio configuration related to phone factors (<a href='https://auth0.com/docs/api/management/v2/#!/Guardian/get_twilio'>phone Twilio configuration</a>). It has the same payload as this one. Please use it instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderSmsTwilioResponseContent]
            Twilio SMS configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/providers/twilio",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSmsTwilioResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSmsTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderSmsTwilioResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-twilio">Update Twilio phone configuration</a> endpoint.

            <b>Previous functionality</b>: Update the Twilio SMS provider configuration.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderSmsTwilioResponseContent]
            Twilio SMS configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/providers/twilio",
            method="PUT",
            json={
                "from": from_,
                "messaging_service_sid": messaging_service_sid,
                "auth_token": auth_token,
                "sid": sid,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderSmsTwilioResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderSmsTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorsProviderSmsResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-phone-providers">Retrieve phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Retrieve details for the multi-factor authentication SMS provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorsProviderSmsResponseContent]
            Returns selected SMS provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSmsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSmsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorsProviderSmsResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-phone-providers">Update phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Update the multi-factor authentication SMS provider configuration in your tenant.

        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorsProviderSmsResponseContent]
            Returns selected SMS provider configuration
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderSmsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderSmsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetGuardianFactorSmsTemplatesResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-factor-phone-templates">Retrieve enrollment and verification phone templates</a> endpoint instead.

            <b>Previous function</b>: Retrieve details of SMS enrollment and verification templates configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetGuardianFactorSmsTemplatesResponseContent]
            SMS enrollment and verification templates successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorSmsTemplatesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorSmsTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SetGuardianFactorSmsTemplatesResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-factor-phone-templates">Update enrollment and verification phone templates</a> endpoint instead.

            <b>Previous functionality</b>: Customize the messages sent to complete SMS enrollment and verification.

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SetGuardianFactorSmsTemplatesResponseContent]
            SMS enrollment and verification templates successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/templates",
            method="PUT",
            json={
                "enrollment_message": enrollment_message,
                "verification_message": verification_message,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorSmsTemplatesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorSmsTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSmsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_twilio_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderSmsTwilioResponseContent]:
        """
        Retrieve the <a href="https://auth0.com/docs/multifactor-authentication/twilio-configuration">Twilio SMS provider configuration</a> (subscription required).

            A new endpoint is available to retrieve the Twilio configuration related to phone factors (<a href='https://auth0.com/docs/api/management/v2/#!/Guardian/get_twilio'>phone Twilio configuration</a>). It has the same payload as this one. Please use it instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderSmsTwilioResponseContent]
            Twilio SMS configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/providers/twilio",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSmsTwilioResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSmsTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_twilio_provider(
        self,
        *,
        from_: typing.Optional[str] = "+1223323",
        messaging_service_sid: typing.Optional[str] = "5dEkAiHLPCuQ1uJj4qNXcAnERFAL6cpq",
        auth_token: typing.Optional[str] = "zw5Ku6z2sxhd0ZVXto5SDHX6KPDByJPU",
        sid: typing.Optional[str] = "wywA2BH4VqTpfywiDuyDAYZL3xQjoO40",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderSmsTwilioResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-twilio">Update Twilio phone configuration</a> endpoint.

            <b>Previous functionality</b>: Update the Twilio SMS provider configuration.

        Parameters
        ----------
        from_ : typing.Optional[str]
            From number

        messaging_service_sid : typing.Optional[str]
            Copilot SID

        auth_token : typing.Optional[str]
            Twilio Authentication token

        sid : typing.Optional[str]
            Twilio SID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderSmsTwilioResponseContent]
            Twilio SMS configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/providers/twilio",
            method="PUT",
            json={
                "from": from_,
                "messaging_service_sid": messaging_service_sid,
                "auth_token": auth_token,
                "sid": sid,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderSmsTwilioResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderSmsTwilioResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_selected_provider(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorsProviderSmsResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-phone-providers">Retrieve phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Retrieve details for the multi-factor authentication SMS provider configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorsProviderSmsResponseContent]
            Returns selected SMS provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/selected-provider",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorsProviderSmsResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorsProviderSmsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_provider(
        self,
        *,
        provider: GuardianFactorsProviderSmsProviderEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorsProviderSmsResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-phone-providers">Update phone configuration</a> endpoint instead.

            <b>Previous functionality</b>: Update the multi-factor authentication SMS provider configuration in your tenant.

        Parameters
        ----------
        provider : GuardianFactorsProviderSmsProviderEnum

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorsProviderSmsResponseContent]
            Returns selected SMS provider configuration
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/selected-provider",
            method="PUT",
            json={
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorsProviderSmsResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorsProviderSmsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetGuardianFactorSmsTemplatesResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/get-factor-phone-templates">Retrieve enrollment and verification phone templates</a> endpoint instead.

            <b>Previous function</b>: Retrieve details of SMS enrollment and verification templates configured for your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetGuardianFactorSmsTemplatesResponseContent]
            SMS enrollment and verification templates successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetGuardianFactorSmsTemplatesResponseContent,
                    parse_obj_as(
                        type_=GetGuardianFactorSmsTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set_templates(
        self,
        *,
        enrollment_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}. Please enter this code to verify your enrollment.",
        verification_message: str = "{{code}} is your verification code for {{tenant.friendly_name}}",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SetGuardianFactorSmsTemplatesResponseContent]:
        """
        This endpoint has been deprecated. To complete this action, use the <a href="https://auth0.com/docs/api/management/v2/guardian/put-factor-phone-templates">Update enrollment and verification phone templates</a> endpoint instead.

            <b>Previous functionality</b>: Customize the messages sent to complete SMS enrollment and verification.

        Parameters
        ----------
        enrollment_message : str
            Message sent to the user when they are invited to enroll with a phone number.

        verification_message : str
            Message sent to the user when they are prompted to verify their account.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SetGuardianFactorSmsTemplatesResponseContent]
            SMS enrollment and verification templates successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "guardian/factors/sms/templates",
            method="PUT",
            json={
                "enrollment_message": enrollment_message,
                "verification_message": verification_message,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SetGuardianFactorSmsTemplatesResponseContent,
                    parse_obj_as(
                        type_=SetGuardianFactorSmsTemplatesResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
