# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.list_guardian_policies_response_content import ListGuardianPoliciesResponseContent
from ...types.set_guardian_policies_request_content import SetGuardianPoliciesRequestContent
from ...types.set_guardian_policies_response_content import SetGuardianPoliciesResponseContent
from .raw_client import AsyncRawPoliciesClient, RawPoliciesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PoliciesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPoliciesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPoliciesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPoliciesClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> ListGuardianPoliciesResponseContent:
        """
        Retrieve the <a href="https://auth0.com/docs/secure/multi-factor-authentication/enable-mfa">multi-factor authentication (MFA) policies</a> configured for your tenant.

        The following policies are supported:
        <ul>
        <li><code>all-applications</code> policy prompts with MFA for all logins.</li>
        <li><code>confidence-score</code> policy prompts with MFA only for low confidence logins.</li>
        </ul>

        <b>Note</b>: The <code>confidence-score</code> policy is part of the <a href="https://auth0.com/docs/secure/multi-factor-authentication/adaptive-mfa">Adaptive MFA feature</a>. Adaptive MFA requires an add-on for the Enterprise plan; review <a href="https://auth0.com/pricing">Auth0 Pricing</a> for more details.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListGuardianPoliciesResponseContent
            Success

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.policies.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def set(
        self, *, request: SetGuardianPoliciesRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianPoliciesResponseContent:
        """
        Set <a href="https://auth0.com/docs/secure/multi-factor-authentication/enable-mfa">multi-factor authentication (MFA) policies</a> for your tenant.

        The following policies are supported:
        <ul>
        <li><code>all-applications</code> policy prompts with MFA for all logins.</li>
        <li><code>confidence-score</code> policy prompts with MFA only for low confidence logins.</li>
        </ul>

        <b>Note</b>: The <code>confidence-score</code> policy is part of the <a href="https://auth0.com/docs/secure/multi-factor-authentication/adaptive-mfa">Adaptive MFA feature</a>. Adaptive MFA requires an add-on for the Enterprise plan; review <a href="https://auth0.com/pricing">Auth0 Pricing</a> for more details.

        Parameters
        ----------
        request : SetGuardianPoliciesRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianPoliciesResponseContent
            Policies updated

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.guardian.policies.set(
            request=["all-applications"],
        )
        """
        _response = self._raw_client.set(request=request, request_options=request_options)
        return _response.data


class AsyncPoliciesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPoliciesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPoliciesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPoliciesClient
        """
        return self._raw_client

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListGuardianPoliciesResponseContent:
        """
        Retrieve the <a href="https://auth0.com/docs/secure/multi-factor-authentication/enable-mfa">multi-factor authentication (MFA) policies</a> configured for your tenant.

        The following policies are supported:
        <ul>
        <li><code>all-applications</code> policy prompts with MFA for all logins.</li>
        <li><code>confidence-score</code> policy prompts with MFA only for low confidence logins.</li>
        </ul>

        <b>Note</b>: The <code>confidence-score</code> policy is part of the <a href="https://auth0.com/docs/secure/multi-factor-authentication/adaptive-mfa">Adaptive MFA feature</a>. Adaptive MFA requires an add-on for the Enterprise plan; review <a href="https://auth0.com/pricing">Auth0 Pricing</a> for more details.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListGuardianPoliciesResponseContent
            Success

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.policies.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def set(
        self, *, request: SetGuardianPoliciesRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> SetGuardianPoliciesResponseContent:
        """
        Set <a href="https://auth0.com/docs/secure/multi-factor-authentication/enable-mfa">multi-factor authentication (MFA) policies</a> for your tenant.

        The following policies are supported:
        <ul>
        <li><code>all-applications</code> policy prompts with MFA for all logins.</li>
        <li><code>confidence-score</code> policy prompts with MFA only for low confidence logins.</li>
        </ul>

        <b>Note</b>: The <code>confidence-score</code> policy is part of the <a href="https://auth0.com/docs/secure/multi-factor-authentication/adaptive-mfa">Adaptive MFA feature</a>. Adaptive MFA requires an add-on for the Enterprise plan; review <a href="https://auth0.com/pricing">Auth0 Pricing</a> for more details.

        Parameters
        ----------
        request : SetGuardianPoliciesRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetGuardianPoliciesResponseContent
            Policies updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.guardian.policies.set(
                request=["all-applications"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(request=request, request_options=request_options)
        return _response.data
