# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_hook_response_content import CreateHookResponseContent
from ..types.get_hook_response_content import GetHookResponseContent
from ..types.hook import Hook
from ..types.hook_dependencies import HookDependencies
from ..types.hook_trigger_id_enum import HookTriggerIdEnum
from ..types.list_hooks_offset_paginated_response_content import ListHooksOffsetPaginatedResponseContent
from ..types.update_hook_response_content import UpdateHookResponseContent
from .raw_client import AsyncRawHooksClient, RawHooksClient

if typing.TYPE_CHECKING:
    from .secrets.client import AsyncSecretsClient, SecretsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class HooksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawHooksClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._secrets: typing.Optional[SecretsClient] = None

    @property
    def with_raw_response(self) -> RawHooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawHooksClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        enabled: typing.Optional[bool] = None,
        fields: typing.Optional[str] = None,
        trigger_id: typing.Optional[HookTriggerIdEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Hook, ListHooksOffsetPaginatedResponseContent]:
        """
        Retrieve all <a href="https://auth0.com/docs/hooks">hooks</a>. Accepts a list of fields to include or exclude in the result.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        enabled : typing.Optional[bool]
            Optional filter on whether a hook is enabled (true) or disabled (false).

        fields : typing.Optional[str]
            Comma-separated list of fields to include in the result. Leave empty to retrieve all fields.

        trigger_id : typing.Optional[HookTriggerIdEnum]
            Retrieves hooks that match the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Hook, ListHooksOffsetPaginatedResponseContent]
            Hooks successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.hooks.list(
            page=1,
            per_page=1,
            include_totals=True,
            enabled=True,
            fields="fields",
            trigger_id="credentials-exchange",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            enabled=enabled,
            fields=fields,
            trigger_id=trigger_id,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str = "my-hook",
        script: str = "module.exports = function(client, scope, audience, context, cb) cb(null, access_token); };",
        trigger_id: HookTriggerIdEnum,
        enabled: typing.Optional[bool] = False,
        dependencies: typing.Optional[HookDependencies] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateHookResponseContent:
        """
        Create a new hook.

        Parameters
        ----------
        name : str
            Name of this hook.

        script : str
            Code to be executed when this hook runs.

        trigger_id : HookTriggerIdEnum

        enabled : typing.Optional[bool]
            Whether this hook will be executed (true) or ignored (false).

        dependencies : typing.Optional[HookDependencies]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateHookResponseContent
            Hook successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.create(
            name="name",
            script="script",
            trigger_id="credentials-exchange",
        )
        """
        _response = self._raw_client.create(
            name=name,
            script=script,
            trigger_id=trigger_id,
            enabled=enabled,
            dependencies=dependencies,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, fields: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> GetHookResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/hooks">a hook</a> by its ID. Accepts a list of fields to include in the result.

        Parameters
        ----------
        id : str
            ID of the hook to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include in the result. Leave empty to retrieve all fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetHookResponseContent
            Hook successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.get(
            id="id",
            fields="fields",
        )
        """
        _response = self._raw_client.get(id, fields=fields, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a hook.

        Parameters
        ----------
        id : str
            ID of the hook to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-hook",
        script: typing.Optional[
            str
        ] = "module.exports = function(client, scope, audience, context, cb) cb(null, access_token); };",
        enabled: typing.Optional[bool] = False,
        dependencies: typing.Optional[HookDependencies] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateHookResponseContent:
        """
        Update an existing hook.

        Parameters
        ----------
        id : str
            ID of the hook to update.

        name : typing.Optional[str]
            Name of this hook.

        script : typing.Optional[str]
            Code to be executed when this hook runs.

        enabled : typing.Optional[bool]
            Whether this hook will be executed (true) or ignored (false).

        dependencies : typing.Optional[HookDependencies]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateHookResponseContent
            Hook successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, name=name, script=script, enabled=enabled, dependencies=dependencies, request_options=request_options
        )
        return _response.data

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import SecretsClient  # noqa: E402

            self._secrets = SecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets


class AsyncHooksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawHooksClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._secrets: typing.Optional[AsyncSecretsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawHooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawHooksClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        enabled: typing.Optional[bool] = None,
        fields: typing.Optional[str] = None,
        trigger_id: typing.Optional[HookTriggerIdEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Hook, ListHooksOffsetPaginatedResponseContent]:
        """
        Retrieve all <a href="https://auth0.com/docs/hooks">hooks</a>. Accepts a list of fields to include or exclude in the result.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        enabled : typing.Optional[bool]
            Optional filter on whether a hook is enabled (true) or disabled (false).

        fields : typing.Optional[str]
            Comma-separated list of fields to include in the result. Leave empty to retrieve all fields.

        trigger_id : typing.Optional[HookTriggerIdEnum]
            Retrieves hooks that match the trigger

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Hook, ListHooksOffsetPaginatedResponseContent]
            Hooks successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.hooks.list(
                page=1,
                per_page=1,
                include_totals=True,
                enabled=True,
                fields="fields",
                trigger_id="credentials-exchange",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            enabled=enabled,
            fields=fields,
            trigger_id=trigger_id,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str = "my-hook",
        script: str = "module.exports = function(client, scope, audience, context, cb) cb(null, access_token); };",
        trigger_id: HookTriggerIdEnum,
        enabled: typing.Optional[bool] = False,
        dependencies: typing.Optional[HookDependencies] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateHookResponseContent:
        """
        Create a new hook.

        Parameters
        ----------
        name : str
            Name of this hook.

        script : str
            Code to be executed when this hook runs.

        trigger_id : HookTriggerIdEnum

        enabled : typing.Optional[bool]
            Whether this hook will be executed (true) or ignored (false).

        dependencies : typing.Optional[HookDependencies]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateHookResponseContent
            Hook successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.create(
                name="name",
                script="script",
                trigger_id="credentials-exchange",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            script=script,
            trigger_id=trigger_id,
            enabled=enabled,
            dependencies=dependencies,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, fields: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> GetHookResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/hooks">a hook</a> by its ID. Accepts a list of fields to include in the result.

        Parameters
        ----------
        id : str
            ID of the hook to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include in the result. Leave empty to retrieve all fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetHookResponseContent
            Hook successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.get(
                id="id",
                fields="fields",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, fields=fields, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a hook.

        Parameters
        ----------
        id : str
            ID of the hook to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-hook",
        script: typing.Optional[
            str
        ] = "module.exports = function(client, scope, audience, context, cb) cb(null, access_token); };",
        enabled: typing.Optional[bool] = False,
        dependencies: typing.Optional[HookDependencies] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateHookResponseContent:
        """
        Update an existing hook.

        Parameters
        ----------
        id : str
            ID of the hook to update.

        name : typing.Optional[str]
            Name of this hook.

        script : typing.Optional[str]
            Code to be executed when this hook runs.

        enabled : typing.Optional[bool]
            Whether this hook will be executed (true) or ignored (false).

        dependencies : typing.Optional[HookDependencies]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateHookResponseContent
            Hook successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, name=name, script=script, enabled=enabled, dependencies=dependencies, request_options=request_options
        )
        return _response.data

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import AsyncSecretsClient  # noqa: E402

            self._secrets = AsyncSecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets
