# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_hook_secret_request_content import CreateHookSecretRequestContent
from ...types.delete_hook_secret_request_content import DeleteHookSecretRequestContent
from ...types.get_hook_secret_response_content import GetHookSecretResponseContent
from ...types.update_hook_secret_request_content import UpdateHookSecretRequestContent
from .raw_client import AsyncRawSecretsClient, RawSecretsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SecretsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSecretsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSecretsClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetHookSecretResponseContent:
        """
        Retrieve a hook's secrets by the ID of the hook.

        Parameters
        ----------
        id : str
            ID of the hook to retrieve secrets from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetHookSecretResponseContent
            Hook secrets successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.secrets.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        request: CreateHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Add one or more secrets to an existing hook. Accepts an object of key-value pairs, where the key is the name of the secret. A hook can have a maximum of 20 secrets.

        Parameters
        ----------
        id : str
            The id of the hook to retrieve

        request : CreateHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.secrets.create(
            id="id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    def delete(
        self,
        id: str,
        *,
        request: DeleteHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete one or more existing secrets for a given hook. Accepts an array of secret names to delete.

        Parameters
        ----------
        id : str
            ID of the hook whose secrets to delete.

        request : DeleteHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.secrets.delete(
            id="id",
            request=["string"],
        )
        """
        _response = self._raw_client.delete(id, request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        request: UpdateHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update one or more existing secrets for an existing hook. Accepts an object of key-value pairs, where the key is the name of the existing secret.

        Parameters
        ----------
        id : str
            ID of the hook whose secrets to update.

        request : UpdateHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.hooks.secrets.update(
            id="id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data


class AsyncSecretsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSecretsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSecretsClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetHookSecretResponseContent:
        """
        Retrieve a hook's secrets by the ID of the hook.

        Parameters
        ----------
        id : str
            ID of the hook to retrieve secrets from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetHookSecretResponseContent
            Hook secrets successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.secrets.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        request: CreateHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Add one or more secrets to an existing hook. Accepts an object of key-value pairs, where the key is the name of the secret. A hook can have a maximum of 20 secrets.

        Parameters
        ----------
        id : str
            The id of the hook to retrieve

        request : CreateHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.secrets.create(
                id="id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    async def delete(
        self,
        id: str,
        *,
        request: DeleteHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete one or more existing secrets for a given hook. Accepts an array of secret names to delete.

        Parameters
        ----------
        id : str
            ID of the hook whose secrets to delete.

        request : DeleteHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.secrets.delete(
                id="id",
                request=["string"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        request: UpdateHookSecretRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update one or more existing secrets for an existing hook. Accepts an object of key-value pairs, where the key is the name of the existing secret.

        Parameters
        ----------
        id : str
            ID of the hook whose secrets to update.

        request : UpdateHookSecretRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.hooks.secrets.update(
                id="id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data
