# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_job_response_content import GetJobResponseContent
from .raw_client import AsyncRawJobsClient, RawJobsClient

if typing.TYPE_CHECKING:
    from .errors.client import AsyncErrorsClient, ErrorsClient
    from .users_exports.client import AsyncUsersExportsClient, UsersExportsClient
    from .users_imports.client import AsyncUsersImportsClient, UsersImportsClient
    from .verification_email.client import AsyncVerificationEmailClient, VerificationEmailClient


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._users_exports: typing.Optional[UsersExportsClient] = None
        self._users_imports: typing.Optional[UsersImportsClient] = None
        self._verification_email: typing.Optional[VerificationEmailClient] = None
        self._errors: typing.Optional[ErrorsClient] = None

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetJobResponseContent:
        """
        Retrieves a job. Useful to check its status.

        Parameters
        ----------
        id : str
            ID of the job.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobResponseContent
            Job retrieved successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.jobs.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    @property
    def users_exports(self):
        if self._users_exports is None:
            from .users_exports.client import UsersExportsClient  # noqa: E402

            self._users_exports = UsersExportsClient(client_wrapper=self._client_wrapper)
        return self._users_exports

    @property
    def users_imports(self):
        if self._users_imports is None:
            from .users_imports.client import UsersImportsClient  # noqa: E402

            self._users_imports = UsersImportsClient(client_wrapper=self._client_wrapper)
        return self._users_imports

    @property
    def verification_email(self):
        if self._verification_email is None:
            from .verification_email.client import VerificationEmailClient  # noqa: E402

            self._verification_email = VerificationEmailClient(client_wrapper=self._client_wrapper)
        return self._verification_email

    @property
    def errors(self):
        if self._errors is None:
            from .errors.client import ErrorsClient  # noqa: E402

            self._errors = ErrorsClient(client_wrapper=self._client_wrapper)
        return self._errors


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._users_exports: typing.Optional[AsyncUsersExportsClient] = None
        self._users_imports: typing.Optional[AsyncUsersImportsClient] = None
        self._verification_email: typing.Optional[AsyncVerificationEmailClient] = None
        self._errors: typing.Optional[AsyncErrorsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetJobResponseContent:
        """
        Retrieves a job. Useful to check its status.

        Parameters
        ----------
        id : str
            ID of the job.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobResponseContent
            Job retrieved successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    @property
    def users_exports(self):
        if self._users_exports is None:
            from .users_exports.client import AsyncUsersExportsClient  # noqa: E402

            self._users_exports = AsyncUsersExportsClient(client_wrapper=self._client_wrapper)
        return self._users_exports

    @property
    def users_imports(self):
        if self._users_imports is None:
            from .users_imports.client import AsyncUsersImportsClient  # noqa: E402

            self._users_imports = AsyncUsersImportsClient(client_wrapper=self._client_wrapper)
        return self._users_imports

    @property
    def verification_email(self):
        if self._verification_email is None:
            from .verification_email.client import AsyncVerificationEmailClient  # noqa: E402

            self._verification_email = AsyncVerificationEmailClient(client_wrapper=self._client_wrapper)
        return self._verification_email

    @property
    def errors(self):
        if self._errors is None:
            from .errors.client import AsyncErrorsClient  # noqa: E402

            self._errors = AsyncErrorsClient(client_wrapper=self._client_wrapper)
        return self._errors
