# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawErrorsClient, RawErrorsClient
from .types.errors_get_response import ErrorsGetResponse


class ErrorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawErrorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawErrorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawErrorsClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ErrorsGetResponse:
        """
        Retrieve error details of a failed job.

        Parameters
        ----------
        id : str
            ID of the job.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ErrorsGetResponse
            Job successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.jobs.errors.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data


class AsyncErrorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawErrorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawErrorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawErrorsClient
        """
        return self._raw_client

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ErrorsGetResponse:
        """
        Retrieve error details of a failed job.

        Parameters
        ----------
        id : str
            ID of the job.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ErrorsGetResponse
            Job successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.errors.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data
