# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_export_users_fields import CreateExportUsersFields
from ...types.create_export_users_response_content import CreateExportUsersResponseContent
from ...types.job_file_format_enum import JobFileFormatEnum
from .raw_client import AsyncRawUsersExportsClient, RawUsersExportsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersExportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersExportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersExportsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        connection_id: typing.Optional[str] = "con_0000000000000001",
        format: typing.Optional[JobFileFormatEnum] = OMIT,
        limit: typing.Optional[int] = 5,
        fields: typing.Optional[typing.Sequence[CreateExportUsersFields]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateExportUsersResponseContent:
        """
        Export all users to a file via a long-running job.

        Parameters
        ----------
        connection_id : typing.Optional[str]
            connection_id of the connection from which users will be exported.

        format : typing.Optional[JobFileFormatEnum]

        limit : typing.Optional[int]
            Limit the number of records.

        fields : typing.Optional[typing.Sequence[CreateExportUsersFields]]
            List of fields to be included in the CSV. Defaults to a predefined set of fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExportUsersResponseContent
            Job created successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.jobs.users_exports.create()
        """
        _response = self._raw_client.create(
            connection_id=connection_id, format=format, limit=limit, fields=fields, request_options=request_options
        )
        return _response.data


class AsyncUsersExportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersExportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersExportsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        connection_id: typing.Optional[str] = "con_0000000000000001",
        format: typing.Optional[JobFileFormatEnum] = OMIT,
        limit: typing.Optional[int] = 5,
        fields: typing.Optional[typing.Sequence[CreateExportUsersFields]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateExportUsersResponseContent:
        """
        Export all users to a file via a long-running job.

        Parameters
        ----------
        connection_id : typing.Optional[str]
            connection_id of the connection from which users will be exported.

        format : typing.Optional[JobFileFormatEnum]

        limit : typing.Optional[int]
            Limit the number of records.

        fields : typing.Optional[typing.Sequence[CreateExportUsersFields]]
            List of fields to be included in the CSV. Defaults to a predefined set of fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExportUsersResponseContent
            Job created successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.users_exports.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            connection_id=connection_id, format=format, limit=limit, fields=fields, request_options=request_options
        )
        return _response.data
