# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.create_export_users_fields import CreateExportUsersFields
from ...types.create_export_users_response_content import CreateExportUsersResponseContent
from ...types.job_file_format_enum import JobFileFormatEnum

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawUsersExportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        connection_id: typing.Optional[str] = "con_0000000000000001",
        format: typing.Optional[JobFileFormatEnum] = OMIT,
        limit: typing.Optional[int] = 5,
        fields: typing.Optional[typing.Sequence[CreateExportUsersFields]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateExportUsersResponseContent]:
        """
        Export all users to a file via a long-running job.

        Parameters
        ----------
        connection_id : typing.Optional[str]
            connection_id of the connection from which users will be exported.

        format : typing.Optional[JobFileFormatEnum]

        limit : typing.Optional[int]
            Limit the number of records.

        fields : typing.Optional[typing.Sequence[CreateExportUsersFields]]
            List of fields to be included in the CSV. Defaults to a predefined set of fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateExportUsersResponseContent]
            Job created successfully.
        """
        _response = self._client_wrapper.httpx_client.request(
            "jobs/users-exports",
            method="POST",
            json={
                "connection_id": connection_id,
                "format": format,
                "limit": limit,
                "fields": convert_and_respect_annotation_metadata(
                    object_=fields, annotation=typing.Sequence[CreateExportUsersFields], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateExportUsersResponseContent,
                    parse_obj_as(
                        type_=CreateExportUsersResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawUsersExportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        connection_id: typing.Optional[str] = "con_0000000000000001",
        format: typing.Optional[JobFileFormatEnum] = OMIT,
        limit: typing.Optional[int] = 5,
        fields: typing.Optional[typing.Sequence[CreateExportUsersFields]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateExportUsersResponseContent]:
        """
        Export all users to a file via a long-running job.

        Parameters
        ----------
        connection_id : typing.Optional[str]
            connection_id of the connection from which users will be exported.

        format : typing.Optional[JobFileFormatEnum]

        limit : typing.Optional[int]
            Limit the number of records.

        fields : typing.Optional[typing.Sequence[CreateExportUsersFields]]
            List of fields to be included in the CSV. Defaults to a predefined set of fields.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateExportUsersResponseContent]
            Job created successfully.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "jobs/users-exports",
            method="POST",
            json={
                "connection_id": connection_id,
                "format": format,
                "limit": limit,
                "fields": convert_and_respect_annotation_metadata(
                    object_=fields, annotation=typing.Sequence[CreateExportUsersFields], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateExportUsersResponseContent,
                    parse_obj_as(
                        type_=CreateExportUsersResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
