# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_import_users_response_content import CreateImportUsersResponseContent
from .raw_client import AsyncRawUsersImportsClient, RawUsersImportsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersImportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersImportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersImportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersImportsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        users: core.File,
        connection_id: str,
        upsert: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        send_completion_email: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateImportUsersResponseContent:
        """
        Import users from a <a href="https://auth0.com/docs/users/references/bulk-import-database-schema-examples">formatted file</a> into a connection via a long-running job. When importing users, with or without upsert, the `email_verified` is set to `false` when the email address is added or updated. Users must verify their email address. To avoid this behavior, set `email_verified` to `true` in the imported data.

        Parameters
        ----------
        users : core.File
            See core.File for more documentation

        connection_id : str
            connection_id of the connection to which users will be imported.

        upsert : typing.Optional[bool]
            Whether to update users if they already exist (true) or to ignore them (false).

        external_id : typing.Optional[str]
            Customer-defined ID.

        send_completion_email : typing.Optional[bool]
            Whether to send a completion email to all tenant owners when the job is finished (true) or not (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateImportUsersResponseContent
            Job successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.jobs.users_imports.create(
            connection_id="connection_id",
        )
        """
        _response = self._raw_client.create(
            users=users,
            connection_id=connection_id,
            upsert=upsert,
            external_id=external_id,
            send_completion_email=send_completion_email,
            request_options=request_options,
        )
        return _response.data


class AsyncUsersImportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersImportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersImportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersImportsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        users: core.File,
        connection_id: str,
        upsert: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        send_completion_email: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateImportUsersResponseContent:
        """
        Import users from a <a href="https://auth0.com/docs/users/references/bulk-import-database-schema-examples">formatted file</a> into a connection via a long-running job. When importing users, with or without upsert, the `email_verified` is set to `false` when the email address is added or updated. Users must verify their email address. To avoid this behavior, set `email_verified` to `true` in the imported data.

        Parameters
        ----------
        users : core.File
            See core.File for more documentation

        connection_id : str
            connection_id of the connection to which users will be imported.

        upsert : typing.Optional[bool]
            Whether to update users if they already exist (true) or to ignore them (false).

        external_id : typing.Optional[str]
            Customer-defined ID.

        send_completion_email : typing.Optional[bool]
            Whether to send a completion email to all tenant owners when the job is finished (true) or not (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateImportUsersResponseContent
            Job successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.users_imports.create(
                connection_id="connection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            users=users,
            connection_id=connection_id,
            upsert=upsert,
            external_id=external_id,
            send_completion_email=send_completion_email,
            request_options=request_options,
        )
        return _response.data
