# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_verification_email_response_content import CreateVerificationEmailResponseContent
from ...types.identity import Identity
from .raw_client import AsyncRawVerificationEmailClient, RawVerificationEmailClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VerificationEmailClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVerificationEmailClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVerificationEmailClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVerificationEmailClient
        """
        return self._raw_client

    def create(
        self,
        *,
        user_id: str = "google-oauth2|1234",
        client_id: typing.Optional[str] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateVerificationEmailResponseContent:
        """
        Send an email to the specified user that asks them to click a link to <a href="https://auth0.com/docs/email/custom#verification-email">verify their email address</a>.

        Note: You must have the `Status` toggle enabled for the verification email template for the email to be sent.

        Parameters
        ----------
        user_id : str
            user_id of the user to send the verification email to.

        client_id : typing.Optional[str]
            client_id of the client (application). If no value provided, the global Client ID will be used.

        identity : typing.Optional[Identity]

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateVerificationEmailResponseContent
            Job successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.jobs.verification_email.create(
            user_id="user_id",
        )
        """
        _response = self._raw_client.create(
            user_id=user_id,
            client_id=client_id,
            identity=identity,
            organization_id=organization_id,
            request_options=request_options,
        )
        return _response.data


class AsyncVerificationEmailClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVerificationEmailClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVerificationEmailClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVerificationEmailClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        user_id: str = "google-oauth2|1234",
        client_id: typing.Optional[str] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateVerificationEmailResponseContent:
        """
        Send an email to the specified user that asks them to click a link to <a href="https://auth0.com/docs/email/custom#verification-email">verify their email address</a>.

        Note: You must have the `Status` toggle enabled for the verification email template for the email to be sent.

        Parameters
        ----------
        user_id : str
            user_id of the user to send the verification email to.

        client_id : typing.Optional[str]
            client_id of the client (application). If no value provided, the global Client ID will be used.

        identity : typing.Optional[Identity]

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateVerificationEmailResponseContent
            Job successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.verification_email.create(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            user_id=user_id,
            client_id=client_id,
            identity=identity,
            organization_id=organization_id,
            request_options=request_options,
        )
        return _response.data
