# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.create_verification_email_response_content import CreateVerificationEmailResponseContent
from ...types.identity import Identity

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawVerificationEmailClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        user_id: str = "google-oauth2|1234",
        client_id: typing.Optional[str] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateVerificationEmailResponseContent]:
        """
        Send an email to the specified user that asks them to click a link to <a href="https://auth0.com/docs/email/custom#verification-email">verify their email address</a>.

        Note: You must have the `Status` toggle enabled for the verification email template for the email to be sent.

        Parameters
        ----------
        user_id : str
            user_id of the user to send the verification email to.

        client_id : typing.Optional[str]
            client_id of the client (application). If no value provided, the global Client ID will be used.

        identity : typing.Optional[Identity]

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateVerificationEmailResponseContent]
            Job successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "jobs/verification-email",
            method="POST",
            json={
                "user_id": user_id,
                "client_id": client_id,
                "identity": convert_and_respect_annotation_metadata(
                    object_=identity, annotation=Identity, direction="write"
                ),
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateVerificationEmailResponseContent,
                    parse_obj_as(
                        type_=CreateVerificationEmailResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawVerificationEmailClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        user_id: str = "google-oauth2|1234",
        client_id: typing.Optional[str] = OMIT,
        identity: typing.Optional[Identity] = OMIT,
        organization_id: typing.Optional[str] = "org_2eondWoxcMIpaLQc",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateVerificationEmailResponseContent]:
        """
        Send an email to the specified user that asks them to click a link to <a href="https://auth0.com/docs/email/custom#verification-email">verify their email address</a>.

        Note: You must have the `Status` toggle enabled for the verification email template for the email to be sent.

        Parameters
        ----------
        user_id : str
            user_id of the user to send the verification email to.

        client_id : typing.Optional[str]
            client_id of the client (application). If no value provided, the global Client ID will be used.

        identity : typing.Optional[Identity]

        organization_id : typing.Optional[str]
            (Optional) Organization ID – the ID of the Organization. If provided, organization parameters will be made available to the email template and organization branding will be applied to the prompt. In addition, the redirect link in the prompt will include organization_id and organization_name query string parameters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateVerificationEmailResponseContent]
            Job successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "jobs/verification-email",
            method="POST",
            json={
                "user_id": user_id,
                "client_id": client_id,
                "identity": convert_and_respect_annotation_metadata(
                    object_=identity, annotation=Identity, direction="write"
                ),
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateVerificationEmailResponseContent,
                    parse_obj_as(
                        type_=CreateVerificationEmailResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
