# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawKeysClient, RawKeysClient

if typing.TYPE_CHECKING:
    from .custom_signing.client import AsyncCustomSigningClient, CustomSigningClient
    from .encryption.client import AsyncEncryptionClient, EncryptionClient
    from .signing.client import AsyncSigningClient, SigningClient


class KeysClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawKeysClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._custom_signing: typing.Optional[CustomSigningClient] = None
        self._encryption: typing.Optional[EncryptionClient] = None
        self._signing: typing.Optional[SigningClient] = None

    @property
    def with_raw_response(self) -> RawKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawKeysClient
        """
        return self._raw_client

    @property
    def custom_signing(self):
        if self._custom_signing is None:
            from .custom_signing.client import CustomSigningClient  # noqa: E402

            self._custom_signing = CustomSigningClient(client_wrapper=self._client_wrapper)
        return self._custom_signing

    @property
    def encryption(self):
        if self._encryption is None:
            from .encryption.client import EncryptionClient  # noqa: E402

            self._encryption = EncryptionClient(client_wrapper=self._client_wrapper)
        return self._encryption

    @property
    def signing(self):
        if self._signing is None:
            from .signing.client import SigningClient  # noqa: E402

            self._signing = SigningClient(client_wrapper=self._client_wrapper)
        return self._signing


class AsyncKeysClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawKeysClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._custom_signing: typing.Optional[AsyncCustomSigningClient] = None
        self._encryption: typing.Optional[AsyncEncryptionClient] = None
        self._signing: typing.Optional[AsyncSigningClient] = None

    @property
    def with_raw_response(self) -> AsyncRawKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawKeysClient
        """
        return self._raw_client

    @property
    def custom_signing(self):
        if self._custom_signing is None:
            from .custom_signing.client import AsyncCustomSigningClient  # noqa: E402

            self._custom_signing = AsyncCustomSigningClient(client_wrapper=self._client_wrapper)
        return self._custom_signing

    @property
    def encryption(self):
        if self._encryption is None:
            from .encryption.client import AsyncEncryptionClient  # noqa: E402

            self._encryption = AsyncEncryptionClient(client_wrapper=self._client_wrapper)
        return self._encryption

    @property
    def signing(self):
        if self._signing is None:
            from .signing.client import AsyncSigningClient  # noqa: E402

            self._signing = AsyncSigningClient(client_wrapper=self._client_wrapper)
        return self._signing
