# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.custom_signing_key_jwk import CustomSigningKeyJwk
from ...types.get_custom_signing_keys_response_content import GetCustomSigningKeysResponseContent
from ...types.set_custom_signing_keys_response_content import SetCustomSigningKeysResponseContent
from .raw_client import AsyncRawCustomSigningClient, RawCustomSigningClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomSigningClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomSigningClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomSigningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomSigningClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetCustomSigningKeysResponseContent:
        """
        Get entire jwks representation of custom signing keys.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomSigningKeysResponseContent
            Custom signing keys were successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.custom_signing.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def set(
        self, *, keys: typing.Sequence[CustomSigningKeyJwk], request_options: typing.Optional[RequestOptions] = None
    ) -> SetCustomSigningKeysResponseContent:
        """
        Create or replace entire jwks representation of custom signing keys.

        Parameters
        ----------
        keys : typing.Sequence[CustomSigningKeyJwk]
            An array of custom public signing keys.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetCustomSigningKeysResponseContent
            Custom signing keys were successfully created or replaced.

        Examples
        --------
        from auth0 import Auth0, CustomSigningKeyJwk

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.custom_signing.set(
            keys=[
                CustomSigningKeyJwk(
                    kty="EC",
                )
            ],
        )
        """
        _response = self._raw_client.set(keys=keys, request_options=request_options)
        return _response.data

    def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete entire jwks representation of custom signing keys.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.custom_signing.delete()
        """
        _response = self._raw_client.delete(request_options=request_options)
        return _response.data


class AsyncCustomSigningClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomSigningClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomSigningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomSigningClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetCustomSigningKeysResponseContent:
        """
        Get entire jwks representation of custom signing keys.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetCustomSigningKeysResponseContent
            Custom signing keys were successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.custom_signing.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def set(
        self, *, keys: typing.Sequence[CustomSigningKeyJwk], request_options: typing.Optional[RequestOptions] = None
    ) -> SetCustomSigningKeysResponseContent:
        """
        Create or replace entire jwks representation of custom signing keys.

        Parameters
        ----------
        keys : typing.Sequence[CustomSigningKeyJwk]
            An array of custom public signing keys.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetCustomSigningKeysResponseContent
            Custom signing keys were successfully created or replaced.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, CustomSigningKeyJwk

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.custom_signing.set(
                keys=[
                    CustomSigningKeyJwk(
                        kty="EC",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(keys=keys, request_options=request_options)
        return _response.data

    async def delete(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete entire jwks representation of custom signing keys.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.custom_signing.delete()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(request_options=request_options)
        return _response.data
