# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.create_encryption_key_public_wrapping_response_content import (
    CreateEncryptionKeyPublicWrappingResponseContent,
)
from ...types.create_encryption_key_response_content import CreateEncryptionKeyResponseContent
from ...types.create_encryption_key_type import CreateEncryptionKeyType
from ...types.encryption_key import EncryptionKey
from ...types.get_encryption_key_response_content import GetEncryptionKeyResponseContent
from ...types.import_encryption_key_response_content import ImportEncryptionKeyResponseContent
from ...types.list_encryption_key_offset_paginated_response_content import (
    ListEncryptionKeyOffsetPaginatedResponseContent,
)
from .raw_client import AsyncRawEncryptionClient, RawEncryptionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EncryptionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEncryptionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEncryptionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEncryptionClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[EncryptionKey, ListEncryptionKeyOffsetPaginatedResponseContent]:
        """
        Retrieve details of all the encryption keys associated with your tenant.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default value is 50, maximum value is 100.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[EncryptionKey, ListEncryptionKeyOffsetPaginatedResponseContent]
            The keys were successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.keys.encryption.list(
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def create(
        self, *, type: CreateEncryptionKeyType, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEncryptionKeyResponseContent:
        """
        Create the new, pre-activated encryption key, without the key material.

        Parameters
        ----------
        type : CreateEncryptionKeyType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEncryptionKeyResponseContent
            The key was successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.create(
            type="customer-provided-root-key",
        )
        """
        _response = self._raw_client.create(type=type, request_options=request_options)
        return _response.data

    def rekey(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Perform rekeying operation on the key hierarchy.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.rekey()
        """
        _response = self._raw_client.rekey(request_options=request_options)
        return _response.data

    def get(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEncryptionKeyResponseContent:
        """
        Retrieve details of the encryption key with the given ID.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEncryptionKeyResponseContent
            The key was successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.get(
            kid="kid",
        )
        """
        _response = self._raw_client.get(kid, request_options=request_options)
        return _response.data

    def import_(
        self, kid: str, *, wrapped_key: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ImportEncryptionKeyResponseContent:
        """
        Import wrapped key material and activate encryption key.

        Parameters
        ----------
        kid : str
            Encryption key ID

        wrapped_key : str
            Base64 encoded ciphertext of key material wrapped by public wrapping key.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportEncryptionKeyResponseContent
            The key was successfully imported.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.import_(
            kid="kid",
            wrapped_key="wrapped_key",
        )
        """
        _response = self._raw_client.import_(kid, wrapped_key=wrapped_key, request_options=request_options)
        return _response.data

    def delete(self, kid: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the custom provided encryption key with the given ID and move back to using native encryption key.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.delete(
            kid="kid",
        )
        """
        _response = self._raw_client.delete(kid, request_options=request_options)
        return _response.data

    def create_public_wrapping_key(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEncryptionKeyPublicWrappingResponseContent:
        """
        Create the public wrapping key to wrap your own encryption key material.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEncryptionKeyPublicWrappingResponseContent
            The public wrapping key was successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.encryption.create_public_wrapping_key(
            kid="kid",
        )
        """
        _response = self._raw_client.create_public_wrapping_key(kid, request_options=request_options)
        return _response.data


class AsyncEncryptionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEncryptionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEncryptionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEncryptionClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[EncryptionKey, ListEncryptionKeyOffsetPaginatedResponseContent]:
        """
        Retrieve details of all the encryption keys associated with your tenant.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default value is 50, maximum value is 100.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[EncryptionKey, ListEncryptionKeyOffsetPaginatedResponseContent]
            The keys were successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.keys.encryption.list(
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def create(
        self, *, type: CreateEncryptionKeyType, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEncryptionKeyResponseContent:
        """
        Create the new, pre-activated encryption key, without the key material.

        Parameters
        ----------
        type : CreateEncryptionKeyType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEncryptionKeyResponseContent
            The key was successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.create(
                type="customer-provided-root-key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(type=type, request_options=request_options)
        return _response.data

    async def rekey(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Perform rekeying operation on the key hierarchy.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.rekey()


        asyncio.run(main())
        """
        _response = await self._raw_client.rekey(request_options=request_options)
        return _response.data

    async def get(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEncryptionKeyResponseContent:
        """
        Retrieve details of the encryption key with the given ID.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEncryptionKeyResponseContent
            The key was successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.get(
                kid="kid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(kid, request_options=request_options)
        return _response.data

    async def import_(
        self, kid: str, *, wrapped_key: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ImportEncryptionKeyResponseContent:
        """
        Import wrapped key material and activate encryption key.

        Parameters
        ----------
        kid : str
            Encryption key ID

        wrapped_key : str
            Base64 encoded ciphertext of key material wrapped by public wrapping key.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ImportEncryptionKeyResponseContent
            The key was successfully imported.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.import_(
                kid="kid",
                wrapped_key="wrapped_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.import_(kid, wrapped_key=wrapped_key, request_options=request_options)
        return _response.data

    async def delete(self, kid: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the custom provided encryption key with the given ID and move back to using native encryption key.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.delete(
                kid="kid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(kid, request_options=request_options)
        return _response.data

    async def create_public_wrapping_key(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateEncryptionKeyPublicWrappingResponseContent:
        """
        Create the public wrapping key to wrap your own encryption key material.

        Parameters
        ----------
        kid : str
            Encryption key ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateEncryptionKeyPublicWrappingResponseContent
            The public wrapping key was successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.encryption.create_public_wrapping_key(
                kid="kid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_public_wrapping_key(kid, request_options=request_options)
        return _response.data
