# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_signing_keys_response_content import GetSigningKeysResponseContent
from ...types.revoked_signing_keys_response_content import RevokedSigningKeysResponseContent
from ...types.rotate_signing_keys_response_content import RotateSigningKeysResponseContent
from ...types.signing_keys import SigningKeys
from .raw_client import AsyncRawSigningClient, RawSigningClient


class SigningClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSigningClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSigningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSigningClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[SigningKeys]:
        """
        Retrieve details of all the application signing keys associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SigningKeys]
            The signing keys were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.signing.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def rotate(self, *, request_options: typing.Optional[RequestOptions] = None) -> RotateSigningKeysResponseContent:
        """
        Rotate the application signing key of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateSigningKeysResponseContent
            Signing key rotated successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.signing.rotate()
        """
        _response = self._raw_client.rotate(request_options=request_options)
        return _response.data

    def get(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSigningKeysResponseContent:
        """
        Retrieve details of the application signing key with the given ID.

        Parameters
        ----------
        kid : str
            Key id of the key to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSigningKeysResponseContent
            The signing keys were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.signing.get(
            kid="kid",
        )
        """
        _response = self._raw_client.get(kid, request_options=request_options)
        return _response.data

    def revoke(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RevokedSigningKeysResponseContent:
        """
        Revoke the application signing key with the given ID.

        Parameters
        ----------
        kid : str
            Key id of the key to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RevokedSigningKeysResponseContent
            Signing key revoked successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.keys.signing.revoke(
            kid="kid",
        )
        """
        _response = self._raw_client.revoke(kid, request_options=request_options)
        return _response.data


class AsyncSigningClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSigningClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSigningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSigningClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[SigningKeys]:
        """
        Retrieve details of all the application signing keys associated with your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SigningKeys]
            The signing keys were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.signing.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def rotate(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RotateSigningKeysResponseContent:
        """
        Rotate the application signing key of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateSigningKeysResponseContent
            Signing key rotated successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.signing.rotate()


        asyncio.run(main())
        """
        _response = await self._raw_client.rotate(request_options=request_options)
        return _response.data

    async def get(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSigningKeysResponseContent:
        """
        Retrieve details of the application signing key with the given ID.

        Parameters
        ----------
        kid : str
            Key id of the key to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSigningKeysResponseContent
            The signing keys were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.signing.get(
                kid="kid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(kid, request_options=request_options)
        return _response.data

    async def revoke(
        self, kid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RevokedSigningKeysResponseContent:
        """
        Revoke the application signing key with the given ID.

        Parameters
        ----------
        kid : str
            Key id of the key to revoke

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RevokedSigningKeysResponseContent
            Signing key revoked successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.keys.signing.revoke(
                kid="kid",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revoke(kid, request_options=request_options)
        return _response.data
