# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_log_stream_request_content import CreateLogStreamRequestContent
from ..types.create_log_stream_response_content import CreateLogStreamResponseContent
from ..types.get_log_stream_response_content import GetLogStreamResponseContent
from ..types.log_stream_filter import LogStreamFilter
from ..types.log_stream_pii_config import LogStreamPiiConfig
from ..types.log_stream_response_schema import LogStreamResponseSchema
from ..types.log_stream_sink_patch import LogStreamSinkPatch
from ..types.log_stream_status_enum import LogStreamStatusEnum
from ..types.update_log_stream_response_content import UpdateLogStreamResponseContent
from .raw_client import AsyncRawLogStreamsClient, RawLogStreamsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LogStreamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLogStreamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLogStreamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLogStreamsClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[LogStreamResponseSchema]:
        """
        Retrieve details on <a href="https://auth0.com/docs/logs/streams">log streams</a>.
        <h5>Sample Response</h5><pre><code>[{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }, {
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "eventgrid",
            "status": "active|paused|suspended",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }]</code></pre>

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[LogStreamResponseSchema]
            Returning log streams

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.log_streams.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self, *, request: CreateLogStreamRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateLogStreamResponseContent:
        """
        Create a log stream.
        <h5>Log Stream Types</h5> The <code>type</code> of log stream being created determines the properties required in the <code>sink</code> payload.
        <h5>HTTP Stream</h5> For an <code>http</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "http",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        <h5>Amazon EventBridge Stream</h5> For an <code>eventbridge</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventbridge",
            "sink": {
                "awsRegion": "string",
                "awsAccountId": "string"
            }
        }</code></pre>
        The response will include an additional field <code>awsPartnerEventSource</code> in the <code>sink</code>: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre>
        <h5>Azure Event Grid Stream</h5> For an <code>Azure Event Grid</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventgrid",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        }</code></pre>
        <h5>Datadog Stream</h5> For a <code>Datadog</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "datadog",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        <h5>Splunk Stream</h5> For a <code>Splunk</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "splunk",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        <h5>Sumo Logic Stream</h5> For a <code>Sumo Logic</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "sumo",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>

        Parameters
        ----------
        request : CreateLogStreamRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateLogStreamResponseContent
            Log stream created

        Examples
        --------
        from auth0 import Auth0, CreateLogStreamHttpRequestBody, LogStreamHttpSink

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.log_streams.create(
            request=CreateLogStreamHttpRequestBody(
                sink=LogStreamHttpSink(
                    http_endpoint="httpEndpoint",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetLogStreamResponseContent:
        """
        Retrieve a log stream configuration and status.
        <h5>Sample responses</h5><h5>Amazon EventBridge Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre> <h5>HTTP Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        }</code></pre> <h5>Datadog Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }

        }</code></pre><h5>Mixpanel</h5>

            Request: <pre><code>{
              "name": "string",
              "type": "mixpanel",
              "sink": {
                "mixpanelRegion": "string", // "us" | "eu",
                "mixpanelProjectId": "string",
                "mixpanelServiceAccountUsername": "string",
                "mixpanelServiceAccountPassword": "string"
              }
            } </code></pre>


            Response: <pre><code>{
                "id": "string",
                "name": "string",
                "type": "mixpanel",
                "status": "active",
                "sink": {
                  "mixpanelRegion": "string", // "us" | "eu",
                  "mixpanelProjectId": "string",
                  "mixpanelServiceAccountUsername": "string",
                  "mixpanelServiceAccountPassword": "string" // the following is redacted on return
                }
              } </code></pre>

            <h5>Segment</h5>

            Request: <pre><code> {
              "name": "string",
              "type": "segment",
              "sink": {
                "segmentWriteKey": "string"
              }
            }</code></pre>

            Response: <pre><code>{
              "id": "string",
              "name": "string",
              "type": "segment",
              "status": "active",
              "sink": {
                "segmentWriteKey": "string"
              }
            } </code></pre>

        <h5>Splunk Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre> <h5>Sumo Logic Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre> <h5>Status</h5> The <code>status</code> of a log stream maybe any of the following:
        1. <code>active</code> - Stream is currently enabled.
        2. <code>paused</code> - Stream is currently user disabled and will not attempt log delivery.
        3. <code>suspended</code> - Stream is currently disabled because of errors and will not attempt log delivery.

        Parameters
        ----------
        id : str
            The id of the log stream to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLogStreamResponseContent
            Returning log stream.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.log_streams.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a log stream.

        Parameters
        ----------
        id : str
            The id of the log stream to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.log_streams.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[LogStreamStatusEnum] = OMIT,
        is_priority: typing.Optional[bool] = OMIT,
        filters: typing.Optional[typing.Sequence[LogStreamFilter]] = OMIT,
        pii_config: typing.Optional[LogStreamPiiConfig] = OMIT,
        sink: typing.Optional[LogStreamSinkPatch] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateLogStreamResponseContent:
        """
        Update a log stream.
        <h4>Examples of how to use the PATCH endpoint.</h4> The following fields may be updated in a PATCH operation: <ul><li>name</li><li>status</li><li>sink</li></ul> Note: For log streams of type <code>eventbridge</code> and <code>eventgrid</code>, updating the <code>sink</code> is not permitted.
        <h5>Update the status of a log stream</h5><pre><code>{
            "status": "active|paused"
        }</code></pre>
        <h5>Update the name of a log stream</h5><pre><code>{
            "name": "string"
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>http</code></h5><pre><code>{
          "sink": {
            "httpEndpoint": "string",
            "httpContentType": "string",
            "httpContentFormat": "JSONARRAY|JSONLINES",
            "httpAuthorization": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>datadog</code></h5><pre><code>{
          "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>splunk</code></h5><pre><code>{
          "sink": {
            "splunkDomain": "string",
            "splunkToken": "string",
            "splunkPort": "string",
            "splunkSecure": "boolean"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>sumo</code></h5><pre><code>{
          "sink": {
            "sumoSourceAddress": "string"
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            The id of the log stream to get

        name : typing.Optional[str]
            log stream name

        status : typing.Optional[LogStreamStatusEnum]

        is_priority : typing.Optional[bool]
            True for priority log streams, false for non-priority

        filters : typing.Optional[typing.Sequence[LogStreamFilter]]
            Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered.

        pii_config : typing.Optional[LogStreamPiiConfig]

        sink : typing.Optional[LogStreamSinkPatch]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateLogStreamResponseContent
            Log stream updated

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.log_streams.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            status=status,
            is_priority=is_priority,
            filters=filters,
            pii_config=pii_config,
            sink=sink,
            request_options=request_options,
        )
        return _response.data


class AsyncLogStreamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLogStreamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLogStreamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLogStreamsClient
        """
        return self._raw_client

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[LogStreamResponseSchema]:
        """
        Retrieve details on <a href="https://auth0.com/docs/logs/streams">log streams</a>.
        <h5>Sample Response</h5><pre><code>[{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }, {
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "eventgrid",
            "status": "active|paused|suspended",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }]</code></pre>

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[LogStreamResponseSchema]
            Returning log streams

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.log_streams.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self, *, request: CreateLogStreamRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateLogStreamResponseContent:
        """
        Create a log stream.
        <h5>Log Stream Types</h5> The <code>type</code> of log stream being created determines the properties required in the <code>sink</code> payload.
        <h5>HTTP Stream</h5> For an <code>http</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "http",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        <h5>Amazon EventBridge Stream</h5> For an <code>eventbridge</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventbridge",
            "sink": {
                "awsRegion": "string",
                "awsAccountId": "string"
            }
        }</code></pre>
        The response will include an additional field <code>awsPartnerEventSource</code> in the <code>sink</code>: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre>
        <h5>Azure Event Grid Stream</h5> For an <code>Azure Event Grid</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventgrid",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        }</code></pre>
        <h5>Datadog Stream</h5> For a <code>Datadog</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "datadog",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        <h5>Splunk Stream</h5> For a <code>Splunk</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "splunk",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        <h5>Sumo Logic Stream</h5> For a <code>Sumo Logic</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "sumo",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>

        Parameters
        ----------
        request : CreateLogStreamRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateLogStreamResponseContent
            Log stream created

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, CreateLogStreamHttpRequestBody, LogStreamHttpSink

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.log_streams.create(
                request=CreateLogStreamHttpRequestBody(
                    sink=LogStreamHttpSink(
                        http_endpoint="httpEndpoint",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetLogStreamResponseContent:
        """
        Retrieve a log stream configuration and status.
        <h5>Sample responses</h5><h5>Amazon EventBridge Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre> <h5>HTTP Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        }</code></pre> <h5>Datadog Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }

        }</code></pre><h5>Mixpanel</h5>

            Request: <pre><code>{
              "name": "string",
              "type": "mixpanel",
              "sink": {
                "mixpanelRegion": "string", // "us" | "eu",
                "mixpanelProjectId": "string",
                "mixpanelServiceAccountUsername": "string",
                "mixpanelServiceAccountPassword": "string"
              }
            } </code></pre>


            Response: <pre><code>{
                "id": "string",
                "name": "string",
                "type": "mixpanel",
                "status": "active",
                "sink": {
                  "mixpanelRegion": "string", // "us" | "eu",
                  "mixpanelProjectId": "string",
                  "mixpanelServiceAccountUsername": "string",
                  "mixpanelServiceAccountPassword": "string" // the following is redacted on return
                }
              } </code></pre>

            <h5>Segment</h5>

            Request: <pre><code> {
              "name": "string",
              "type": "segment",
              "sink": {
                "segmentWriteKey": "string"
              }
            }</code></pre>

            Response: <pre><code>{
              "id": "string",
              "name": "string",
              "type": "segment",
              "status": "active",
              "sink": {
                "segmentWriteKey": "string"
              }
            } </code></pre>

        <h5>Splunk Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre> <h5>Sumo Logic Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre> <h5>Status</h5> The <code>status</code> of a log stream maybe any of the following:
        1. <code>active</code> - Stream is currently enabled.
        2. <code>paused</code> - Stream is currently user disabled and will not attempt log delivery.
        3. <code>suspended</code> - Stream is currently disabled because of errors and will not attempt log delivery.

        Parameters
        ----------
        id : str
            The id of the log stream to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLogStreamResponseContent
            Returning log stream.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.log_streams.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a log stream.

        Parameters
        ----------
        id : str
            The id of the log stream to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.log_streams.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[LogStreamStatusEnum] = OMIT,
        is_priority: typing.Optional[bool] = OMIT,
        filters: typing.Optional[typing.Sequence[LogStreamFilter]] = OMIT,
        pii_config: typing.Optional[LogStreamPiiConfig] = OMIT,
        sink: typing.Optional[LogStreamSinkPatch] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateLogStreamResponseContent:
        """
        Update a log stream.
        <h4>Examples of how to use the PATCH endpoint.</h4> The following fields may be updated in a PATCH operation: <ul><li>name</li><li>status</li><li>sink</li></ul> Note: For log streams of type <code>eventbridge</code> and <code>eventgrid</code>, updating the <code>sink</code> is not permitted.
        <h5>Update the status of a log stream</h5><pre><code>{
            "status": "active|paused"
        }</code></pre>
        <h5>Update the name of a log stream</h5><pre><code>{
            "name": "string"
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>http</code></h5><pre><code>{
          "sink": {
            "httpEndpoint": "string",
            "httpContentType": "string",
            "httpContentFormat": "JSONARRAY|JSONLINES",
            "httpAuthorization": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>datadog</code></h5><pre><code>{
          "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>splunk</code></h5><pre><code>{
          "sink": {
            "splunkDomain": "string",
            "splunkToken": "string",
            "splunkPort": "string",
            "splunkSecure": "boolean"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>sumo</code></h5><pre><code>{
          "sink": {
            "sumoSourceAddress": "string"
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            The id of the log stream to get

        name : typing.Optional[str]
            log stream name

        status : typing.Optional[LogStreamStatusEnum]

        is_priority : typing.Optional[bool]
            True for priority log streams, false for non-priority

        filters : typing.Optional[typing.Sequence[LogStreamFilter]]
            Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered.

        pii_config : typing.Optional[LogStreamPiiConfig]

        sink : typing.Optional[LogStreamSinkPatch]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateLogStreamResponseContent
            Log stream updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.log_streams.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            status=status,
            is_priority=is_priority,
            filters=filters,
            pii_config=pii_config,
            sink=sink,
            request_options=request_options,
        )
        return _response.data
