# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.create_log_stream_request_content import CreateLogStreamRequestContent
from ..types.create_log_stream_response_content import CreateLogStreamResponseContent
from ..types.get_log_stream_response_content import GetLogStreamResponseContent
from ..types.log_stream_filter import LogStreamFilter
from ..types.log_stream_pii_config import LogStreamPiiConfig
from ..types.log_stream_response_schema import LogStreamResponseSchema
from ..types.log_stream_sink_patch import LogStreamSinkPatch
from ..types.log_stream_status_enum import LogStreamStatusEnum
from ..types.update_log_stream_response_content import UpdateLogStreamResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawLogStreamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[LogStreamResponseSchema]]:
        """
        Retrieve details on <a href="https://auth0.com/docs/logs/streams">log streams</a>.
        <h5>Sample Response</h5><pre><code>[{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }, {
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "eventgrid",
            "status": "active|paused|suspended",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }]</code></pre>

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[LogStreamResponseSchema]]
            Returning log streams
        """
        _response = self._client_wrapper.httpx_client.request(
            "log-streams",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[LogStreamResponseSchema],
                    parse_obj_as(
                        type_=typing.List[LogStreamResponseSchema],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, request: CreateLogStreamRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CreateLogStreamResponseContent]:
        """
        Create a log stream.
        <h5>Log Stream Types</h5> The <code>type</code> of log stream being created determines the properties required in the <code>sink</code> payload.
        <h5>HTTP Stream</h5> For an <code>http</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "http",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        <h5>Amazon EventBridge Stream</h5> For an <code>eventbridge</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventbridge",
            "sink": {
                "awsRegion": "string",
                "awsAccountId": "string"
            }
        }</code></pre>
        The response will include an additional field <code>awsPartnerEventSource</code> in the <code>sink</code>: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre>
        <h5>Azure Event Grid Stream</h5> For an <code>Azure Event Grid</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventgrid",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        }</code></pre>
        <h5>Datadog Stream</h5> For a <code>Datadog</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "datadog",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        <h5>Splunk Stream</h5> For a <code>Splunk</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "splunk",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        <h5>Sumo Logic Stream</h5> For a <code>Sumo Logic</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "sumo",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>

        Parameters
        ----------
        request : CreateLogStreamRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateLogStreamResponseContent]
            Log stream created
        """
        _response = self._client_wrapper.httpx_client.request(
            "log-streams",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateLogStreamRequestContent, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateLogStreamResponseContent,
                    parse_obj_as(
                        type_=CreateLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetLogStreamResponseContent]:
        """
        Retrieve a log stream configuration and status.
        <h5>Sample responses</h5><h5>Amazon EventBridge Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre> <h5>HTTP Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        }</code></pre> <h5>Datadog Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }

        }</code></pre><h5>Mixpanel</h5>

            Request: <pre><code>{
              "name": "string",
              "type": "mixpanel",
              "sink": {
                "mixpanelRegion": "string", // "us" | "eu",
                "mixpanelProjectId": "string",
                "mixpanelServiceAccountUsername": "string",
                "mixpanelServiceAccountPassword": "string"
              }
            } </code></pre>


            Response: <pre><code>{
                "id": "string",
                "name": "string",
                "type": "mixpanel",
                "status": "active",
                "sink": {
                  "mixpanelRegion": "string", // "us" | "eu",
                  "mixpanelProjectId": "string",
                  "mixpanelServiceAccountUsername": "string",
                  "mixpanelServiceAccountPassword": "string" // the following is redacted on return
                }
              } </code></pre>

            <h5>Segment</h5>

            Request: <pre><code> {
              "name": "string",
              "type": "segment",
              "sink": {
                "segmentWriteKey": "string"
              }
            }</code></pre>

            Response: <pre><code>{
              "id": "string",
              "name": "string",
              "type": "segment",
              "status": "active",
              "sink": {
                "segmentWriteKey": "string"
              }
            } </code></pre>

        <h5>Splunk Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre> <h5>Sumo Logic Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre> <h5>Status</h5> The <code>status</code> of a log stream maybe any of the following:
        1. <code>active</code> - Stream is currently enabled.
        2. <code>paused</code> - Stream is currently user disabled and will not attempt log delivery.
        3. <code>suspended</code> - Stream is currently disabled because of errors and will not attempt log delivery.

        Parameters
        ----------
        id : str
            The id of the log stream to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetLogStreamResponseContent]
            Returning log stream.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLogStreamResponseContent,
                    parse_obj_as(
                        type_=GetLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Delete a log stream.

        Parameters
        ----------
        id : str
            The id of the log stream to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[LogStreamStatusEnum] = OMIT,
        is_priority: typing.Optional[bool] = OMIT,
        filters: typing.Optional[typing.Sequence[LogStreamFilter]] = OMIT,
        pii_config: typing.Optional[LogStreamPiiConfig] = OMIT,
        sink: typing.Optional[LogStreamSinkPatch] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateLogStreamResponseContent]:
        """
        Update a log stream.
        <h4>Examples of how to use the PATCH endpoint.</h4> The following fields may be updated in a PATCH operation: <ul><li>name</li><li>status</li><li>sink</li></ul> Note: For log streams of type <code>eventbridge</code> and <code>eventgrid</code>, updating the <code>sink</code> is not permitted.
        <h5>Update the status of a log stream</h5><pre><code>{
            "status": "active|paused"
        }</code></pre>
        <h5>Update the name of a log stream</h5><pre><code>{
            "name": "string"
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>http</code></h5><pre><code>{
          "sink": {
            "httpEndpoint": "string",
            "httpContentType": "string",
            "httpContentFormat": "JSONARRAY|JSONLINES",
            "httpAuthorization": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>datadog</code></h5><pre><code>{
          "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>splunk</code></h5><pre><code>{
          "sink": {
            "splunkDomain": "string",
            "splunkToken": "string",
            "splunkPort": "string",
            "splunkSecure": "boolean"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>sumo</code></h5><pre><code>{
          "sink": {
            "sumoSourceAddress": "string"
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            The id of the log stream to get

        name : typing.Optional[str]
            log stream name

        status : typing.Optional[LogStreamStatusEnum]

        is_priority : typing.Optional[bool]
            True for priority log streams, false for non-priority

        filters : typing.Optional[typing.Sequence[LogStreamFilter]]
            Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered.

        pii_config : typing.Optional[LogStreamPiiConfig]

        sink : typing.Optional[LogStreamSinkPatch]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateLogStreamResponseContent]
            Log stream updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "status": status,
                "isPriority": is_priority,
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=typing.Sequence[LogStreamFilter], direction="write"
                ),
                "pii_config": convert_and_respect_annotation_metadata(
                    object_=pii_config, annotation=LogStreamPiiConfig, direction="write"
                ),
                "sink": convert_and_respect_annotation_metadata(
                    object_=sink, annotation=LogStreamSinkPatch, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateLogStreamResponseContent,
                    parse_obj_as(
                        type_=UpdateLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLogStreamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[LogStreamResponseSchema]]:
        """
        Retrieve details on <a href="https://auth0.com/docs/logs/streams">log streams</a>.
        <h5>Sample Response</h5><pre><code>[{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }, {
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "eventgrid",
            "status": "active|paused|suspended",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        },
        {
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }]</code></pre>

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[LogStreamResponseSchema]]
            Returning log streams
        """
        _response = await self._client_wrapper.httpx_client.request(
            "log-streams",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[LogStreamResponseSchema],
                    parse_obj_as(
                        type_=typing.List[LogStreamResponseSchema],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, request: CreateLogStreamRequestContent, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CreateLogStreamResponseContent]:
        """
        Create a log stream.
        <h5>Log Stream Types</h5> The <code>type</code> of log stream being created determines the properties required in the <code>sink</code> payload.
        <h5>HTTP Stream</h5> For an <code>http</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "http",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "httpEndpoint": "string",
                "httpContentType": "string",
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpAuthorization": "string"
            }
        }</code></pre>
        <h5>Amazon EventBridge Stream</h5> For an <code>eventbridge</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventbridge",
            "sink": {
                "awsRegion": "string",
                "awsAccountId": "string"
            }
        }</code></pre>
        The response will include an additional field <code>awsPartnerEventSource</code> in the <code>sink</code>: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre>
        <h5>Azure Event Grid Stream</h5> For an <code>Azure Event Grid</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "eventgrid",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active",
            "sink": {
                "azureSubscriptionId": "string",
                "azureResourceGroup": "string",
                "azureRegion": "string",
                "azurePartnerTopic": "string"
            }
        }</code></pre>
        <h5>Datadog Stream</h5> For a <code>Datadog</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "datadog",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }
        }</code></pre>
        <h5>Splunk Stream</h5> For a <code>Splunk</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "splunk",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre>
        <h5>Sumo Logic Stream</h5> For a <code>Sumo Logic</code> Stream, the <code>sink</code> properties are listed in the payload below
        Request: <pre><code>{
            "name": "string",
            "type": "sumo",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>
        Response: <pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre>

        Parameters
        ----------
        request : CreateLogStreamRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateLogStreamResponseContent]
            Log stream created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "log-streams",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateLogStreamRequestContent, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateLogStreamResponseContent,
                    parse_obj_as(
                        type_=CreateLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetLogStreamResponseContent]:
        """
        Retrieve a log stream configuration and status.
        <h5>Sample responses</h5><h5>Amazon EventBridge Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "eventbridge",
            "status": "active|paused|suspended",
            "sink": {
                "awsAccountId": "string",
                "awsRegion": "string",
                "awsPartnerEventSource": "string"
            }
        }</code></pre> <h5>HTTP Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "http",
            "status": "active|paused|suspended",
            "sink": {
                "httpContentFormat": "JSONLINES|JSONARRAY",
                "httpContentType": "string",
                "httpEndpoint": "string",
                "httpAuthorization": "string"
            }
        }</code></pre> <h5>Datadog Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "datadog",
            "status": "active|paused|suspended",
            "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
            }

        }</code></pre><h5>Mixpanel</h5>

            Request: <pre><code>{
              "name": "string",
              "type": "mixpanel",
              "sink": {
                "mixpanelRegion": "string", // "us" | "eu",
                "mixpanelProjectId": "string",
                "mixpanelServiceAccountUsername": "string",
                "mixpanelServiceAccountPassword": "string"
              }
            } </code></pre>


            Response: <pre><code>{
                "id": "string",
                "name": "string",
                "type": "mixpanel",
                "status": "active",
                "sink": {
                  "mixpanelRegion": "string", // "us" | "eu",
                  "mixpanelProjectId": "string",
                  "mixpanelServiceAccountUsername": "string",
                  "mixpanelServiceAccountPassword": "string" // the following is redacted on return
                }
              } </code></pre>

            <h5>Segment</h5>

            Request: <pre><code> {
              "name": "string",
              "type": "segment",
              "sink": {
                "segmentWriteKey": "string"
              }
            }</code></pre>

            Response: <pre><code>{
              "id": "string",
              "name": "string",
              "type": "segment",
              "status": "active",
              "sink": {
                "segmentWriteKey": "string"
              }
            } </code></pre>

        <h5>Splunk Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "splunk",
            "status": "active|paused|suspended",
            "sink": {
                "splunkDomain": "string",
                "splunkToken": "string",
                "splunkPort": "string",
                "splunkSecure": "boolean"
            }
        }</code></pre> <h5>Sumo Logic Log Stream</h5><pre><code>{
            "id": "string",
            "name": "string",
            "type": "sumo",
            "status": "active|paused|suspended",
            "sink": {
                "sumoSourceAddress": "string",
            }
        }</code></pre> <h5>Status</h5> The <code>status</code> of a log stream maybe any of the following:
        1. <code>active</code> - Stream is currently enabled.
        2. <code>paused</code> - Stream is currently user disabled and will not attempt log delivery.
        3. <code>suspended</code> - Stream is currently disabled because of errors and will not attempt log delivery.

        Parameters
        ----------
        id : str
            The id of the log stream to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetLogStreamResponseContent]
            Returning log stream.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLogStreamResponseContent,
                    parse_obj_as(
                        type_=GetLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete a log stream.

        Parameters
        ----------
        id : str
            The id of the log stream to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[LogStreamStatusEnum] = OMIT,
        is_priority: typing.Optional[bool] = OMIT,
        filters: typing.Optional[typing.Sequence[LogStreamFilter]] = OMIT,
        pii_config: typing.Optional[LogStreamPiiConfig] = OMIT,
        sink: typing.Optional[LogStreamSinkPatch] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateLogStreamResponseContent]:
        """
        Update a log stream.
        <h4>Examples of how to use the PATCH endpoint.</h4> The following fields may be updated in a PATCH operation: <ul><li>name</li><li>status</li><li>sink</li></ul> Note: For log streams of type <code>eventbridge</code> and <code>eventgrid</code>, updating the <code>sink</code> is not permitted.
        <h5>Update the status of a log stream</h5><pre><code>{
            "status": "active|paused"
        }</code></pre>
        <h5>Update the name of a log stream</h5><pre><code>{
            "name": "string"
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>http</code></h5><pre><code>{
          "sink": {
            "httpEndpoint": "string",
            "httpContentType": "string",
            "httpContentFormat": "JSONARRAY|JSONLINES",
            "httpAuthorization": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>datadog</code></h5><pre><code>{
          "sink": {
                "datadogRegion": "string",
                "datadogApiKey": "string"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>splunk</code></h5><pre><code>{
          "sink": {
            "splunkDomain": "string",
            "splunkToken": "string",
            "splunkPort": "string",
            "splunkSecure": "boolean"
          }
        }</code></pre>
        <h5>Update the sink properties of a stream of type <code>sumo</code></h5><pre><code>{
          "sink": {
            "sumoSourceAddress": "string"
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            The id of the log stream to get

        name : typing.Optional[str]
            log stream name

        status : typing.Optional[LogStreamStatusEnum]

        is_priority : typing.Optional[bool]
            True for priority log streams, false for non-priority

        filters : typing.Optional[typing.Sequence[LogStreamFilter]]
            Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered.

        pii_config : typing.Optional[LogStreamPiiConfig]

        sink : typing.Optional[LogStreamSinkPatch]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateLogStreamResponseContent]
            Log stream updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"log-streams/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "status": status,
                "isPriority": is_priority,
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=typing.Sequence[LogStreamFilter], direction="write"
                ),
                "pii_config": convert_and_respect_annotation_metadata(
                    object_=pii_config, annotation=LogStreamPiiConfig, direction="write"
                ),
                "sink": convert_and_respect_annotation_metadata(
                    object_=sink, annotation=LogStreamSinkPatch, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateLogStreamResponseContent,
                    parse_obj_as(
                        type_=UpdateLogStreamResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
