# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.get_network_acls_response_content import GetNetworkAclsResponseContent
from ..types.list_network_acls_offset_paginated_response_content import ListNetworkAclsOffsetPaginatedResponseContent
from ..types.network_acl_rule import NetworkAclRule
from ..types.network_acls_response_content import NetworkAclsResponseContent
from ..types.set_network_acls_response_content import SetNetworkAclsResponseContent
from ..types.update_network_acl_response_content import UpdateNetworkAclResponseContent
from .raw_client import AsyncRawNetworkAclsClient, RawNetworkAclsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NetworkAclsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNetworkAclsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNetworkAclsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNetworkAclsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[NetworkAclsResponseContent, ListNetworkAclsOffsetPaginatedResponseContent]:
        """
        Get all access control list entries for your client.

        Parameters
        ----------
        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The amount of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[NetworkAclsResponseContent, ListNetworkAclsOffsetPaginatedResponseContent]
            Network access control list successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.network_acls.list(
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def create(
        self,
        *,
        description: str,
        active: bool,
        priority: float,
        rule: NetworkAclRule,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create a new access control list for your client.

        Parameters
        ----------
        description : str

        active : bool
            Indicates whether or not this access control list is actively being used

        priority : float
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : NetworkAclRule

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0, NetworkAclAction, NetworkAclRule

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.network_acls.create(
            description="description",
            active=True,
            priority=1.1,
            rule=NetworkAclRule(
                action=NetworkAclAction(),
                scope="management",
            ),
        )
        """
        _response = self._raw_client.create(
            description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetNetworkAclsResponseContent:
        """
        Get a specific access control list entry for your client.

        Parameters
        ----------
        id : str
            The id of the access control list to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetNetworkAclsResponseContent
            Network access control list successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.network_acls.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def set(
        self,
        id: str,
        *,
        description: str,
        active: bool,
        priority: float,
        rule: NetworkAclRule,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetNetworkAclsResponseContent:
        """
        Update existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to update.

        description : str

        active : bool
            Indicates whether or not this access control list is actively being used

        priority : float
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : NetworkAclRule

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetNetworkAclsResponseContent
            Network ACL properties successfully updated

        Examples
        --------
        from auth0 import Auth0, NetworkAclAction, NetworkAclRule

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.network_acls.set(
            id="id",
            description="description",
            active=True,
            priority=1.1,
            rule=NetworkAclRule(
                action=NetworkAclAction(),
                scope="management",
            ),
        )
        """
        _response = self._raw_client.set(
            id, description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.network_acls.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        description: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        priority: typing.Optional[float] = OMIT,
        rule: typing.Optional[NetworkAclRule] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateNetworkAclResponseContent:
        """
        Update existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to update.

        description : typing.Optional[str]

        active : typing.Optional[bool]
            Indicates whether or not this access control list is actively being used

        priority : typing.Optional[float]
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : typing.Optional[NetworkAclRule]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateNetworkAclResponseContent
            Network ACL properties successfully updated

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.network_acls.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data


class AsyncNetworkAclsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNetworkAclsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNetworkAclsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNetworkAclsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[NetworkAclsResponseContent, ListNetworkAclsOffsetPaginatedResponseContent]:
        """
        Get all access control list entries for your client.

        Parameters
        ----------
        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The amount of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[NetworkAclsResponseContent, ListNetworkAclsOffsetPaginatedResponseContent]
            Network access control list successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.network_acls.list(
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def create(
        self,
        *,
        description: str,
        active: bool,
        priority: float,
        rule: NetworkAclRule,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create a new access control list for your client.

        Parameters
        ----------
        description : str

        active : bool
            Indicates whether or not this access control list is actively being used

        priority : float
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : NetworkAclRule

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, NetworkAclAction, NetworkAclRule

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.network_acls.create(
                description="description",
                active=True,
                priority=1.1,
                rule=NetworkAclRule(
                    action=NetworkAclAction(),
                    scope="management",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetNetworkAclsResponseContent:
        """
        Get a specific access control list entry for your client.

        Parameters
        ----------
        id : str
            The id of the access control list to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetNetworkAclsResponseContent
            Network access control list successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.network_acls.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def set(
        self,
        id: str,
        *,
        description: str,
        active: bool,
        priority: float,
        rule: NetworkAclRule,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SetNetworkAclsResponseContent:
        """
        Update existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to update.

        description : str

        active : bool
            Indicates whether or not this access control list is actively being used

        priority : float
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : NetworkAclRule

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SetNetworkAclsResponseContent
            Network ACL properties successfully updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, NetworkAclAction, NetworkAclRule

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.network_acls.set(
                id="id",
                description="description",
                active=True,
                priority=1.1,
                rule=NetworkAclRule(
                    action=NetworkAclAction(),
                    scope="management",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(
            id, description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.network_acls.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        description: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        priority: typing.Optional[float] = OMIT,
        rule: typing.Optional[NetworkAclRule] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateNetworkAclResponseContent:
        """
        Update existing access control list for your client.

        Parameters
        ----------
        id : str
            The id of the ACL to update.

        description : typing.Optional[str]

        active : typing.Optional[bool]
            Indicates whether or not this access control list is actively being used

        priority : typing.Optional[float]
            Indicates the order in which the ACL will be evaluated relative to other ACL rules.

        rule : typing.Optional[NetworkAclRule]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateNetworkAclResponseContent
            Network ACL properties successfully updated

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.network_acls.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, description=description, active=active, priority=priority, rule=rule, request_options=request_options
        )
        return _response.data
