# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.connection_for_organization import ConnectionForOrganization
from ..types.create_organization_response_content import CreateOrganizationResponseContent
from ..types.create_token_quota import CreateTokenQuota
from ..types.get_organization_by_name_response_content import GetOrganizationByNameResponseContent
from ..types.get_organization_response_content import GetOrganizationResponseContent
from ..types.list_organizations_paginated_response_content import ListOrganizationsPaginatedResponseContent
from ..types.organization import Organization
from ..types.organization_branding import OrganizationBranding
from ..types.organization_metadata import OrganizationMetadata
from ..types.update_organization_response_content import UpdateOrganizationResponseContent
from ..types.update_token_quota import UpdateTokenQuota
from .raw_client import AsyncRawOrganizationsClient, RawOrganizationsClient

if typing.TYPE_CHECKING:
    from .client_grants.client import AsyncClientGrantsClient, ClientGrantsClient
    from .discovery_domains.client import AsyncDiscoveryDomainsClient, DiscoveryDomainsClient
    from .enabled_connections.client import AsyncEnabledConnectionsClient, EnabledConnectionsClient
    from .invitations.client import AsyncInvitationsClient, InvitationsClient
    from .members.client import AsyncMembersClient, MembersClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OrganizationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOrganizationsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._client_grants: typing.Optional[ClientGrantsClient] = None
        self._discovery_domains: typing.Optional[DiscoveryDomainsClient] = None
        self._enabled_connections: typing.Optional[EnabledConnectionsClient] = None
        self._invitations: typing.Optional[InvitationsClient] = None
        self._members: typing.Optional[MembersClient] = None

    @property
    def with_raw_response(self) -> RawOrganizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOrganizationsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Organization, ListOrganizationsPaginatedResponseContent]:
        """
        Retrieve detailed list of all Organizations available in your tenant. For more information, see Auth0 Organizations.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 organizations.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total number of entries to retrieve when using the <code>from</code> parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        sort : typing.Optional[str]
            Field to sort by. Use <code>field:order</code> where order is <code>1</code> for ascending and <code>-1</code> for descending. e.g. <code>created_at:1</code>. We currently support sorting by the following fields: <code>name</code>, <code>display_name</code> and <code>created_at</code>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Organization, ListOrganizationsPaginatedResponseContent]
            Organizations successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.list(
            from_="from",
            take=1,
            sort="sort",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(from_=from_, take=take, sort=sort, request_options=request_options)

    def create(
        self,
        *,
        name: str = "organization-1",
        display_name: typing.Optional[str] = "Acme Users",
        branding: typing.Optional[OrganizationBranding] = OMIT,
        metadata: typing.Optional[OrganizationMetadata] = OMIT,
        enabled_connections: typing.Optional[typing.Sequence[ConnectionForOrganization]] = OMIT,
        token_quota: typing.Optional[CreateTokenQuota] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationResponseContent:
        """
        Create a new Organization within your tenant.  To learn more about Organization settings, behavior, and configuration options, review <a href="https://auth0.com/docs/manage-users/organizations/create-first-organization">Create Your First Organization</a>.

        Parameters
        ----------
        name : str
            The name of this organization.

        display_name : typing.Optional[str]
            Friendly name of this organization.

        branding : typing.Optional[OrganizationBranding]

        metadata : typing.Optional[OrganizationMetadata]

        enabled_connections : typing.Optional[typing.Sequence[ConnectionForOrganization]]
            Connections that will be enabled for this organization. See POST enabled_connections endpoint for the object format. (Max of 10 connections allowed)

        token_quota : typing.Optional[CreateTokenQuota]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationResponseContent
            Organization successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.create(
            name="name",
        )
        """
        _response = self._raw_client.create(
            name=name,
            display_name=display_name,
            branding=branding,
            metadata=metadata,
            enabled_connections=enabled_connections,
            token_quota=token_quota,
            request_options=request_options,
        )
        return _response.data

    def get_by_name(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationByNameResponseContent:
        """
        Retrieve details about a single Organization specified by name.

        Parameters
        ----------
        name : str
            name of the organization to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationByNameResponseContent
            Organization successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.get_by_name(
            name="name",
        )
        """
        _response = self._raw_client.get_by_name(name, request_options=request_options)
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationResponseContent:
        """
        Retrieve details about a single Organization specified by ID.

        Parameters
        ----------
        id : str
            ID of the organization to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationResponseContent
            Organization successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove an Organization from your tenant.  This action cannot be undone.

        <b>Note</b>: Members are automatically disassociated from an Organization when it is deleted. However, this action does <b>not</b> delete these users from your tenant.

        Parameters
        ----------
        id : str
            Organization identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        display_name: typing.Optional[str] = "Acme Users",
        name: typing.Optional[str] = "organization-1",
        branding: typing.Optional[OrganizationBranding] = OMIT,
        metadata: typing.Optional[OrganizationMetadata] = OMIT,
        token_quota: typing.Optional[UpdateTokenQuota] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationResponseContent:
        """
        Update the details of a specific <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/create-organizations">Organization</a>, such as name and display name, branding options, and metadata.

        Parameters
        ----------
        id : str
            ID of the organization to update.

        display_name : typing.Optional[str]
            Friendly name of this organization.

        name : typing.Optional[str]
            The name of this organization.

        branding : typing.Optional[OrganizationBranding]

        metadata : typing.Optional[OrganizationMetadata]

        token_quota : typing.Optional[UpdateTokenQuota]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationResponseContent
            Organization successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            display_name=display_name,
            name=name,
            branding=branding,
            metadata=metadata,
            token_quota=token_quota,
            request_options=request_options,
        )
        return _response.data

    @property
    def client_grants(self):
        if self._client_grants is None:
            from .client_grants.client import ClientGrantsClient  # noqa: E402

            self._client_grants = ClientGrantsClient(client_wrapper=self._client_wrapper)
        return self._client_grants

    @property
    def discovery_domains(self):
        if self._discovery_domains is None:
            from .discovery_domains.client import DiscoveryDomainsClient  # noqa: E402

            self._discovery_domains = DiscoveryDomainsClient(client_wrapper=self._client_wrapper)
        return self._discovery_domains

    @property
    def enabled_connections(self):
        if self._enabled_connections is None:
            from .enabled_connections.client import EnabledConnectionsClient  # noqa: E402

            self._enabled_connections = EnabledConnectionsClient(client_wrapper=self._client_wrapper)
        return self._enabled_connections

    @property
    def invitations(self):
        if self._invitations is None:
            from .invitations.client import InvitationsClient  # noqa: E402

            self._invitations = InvitationsClient(client_wrapper=self._client_wrapper)
        return self._invitations

    @property
    def members(self):
        if self._members is None:
            from .members.client import MembersClient  # noqa: E402

            self._members = MembersClient(client_wrapper=self._client_wrapper)
        return self._members


class AsyncOrganizationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOrganizationsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._client_grants: typing.Optional[AsyncClientGrantsClient] = None
        self._discovery_domains: typing.Optional[AsyncDiscoveryDomainsClient] = None
        self._enabled_connections: typing.Optional[AsyncEnabledConnectionsClient] = None
        self._invitations: typing.Optional[AsyncInvitationsClient] = None
        self._members: typing.Optional[AsyncMembersClient] = None

    @property
    def with_raw_response(self) -> AsyncRawOrganizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOrganizationsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Organization, ListOrganizationsPaginatedResponseContent]:
        """
        Retrieve detailed list of all Organizations available in your tenant. For more information, see Auth0 Organizations.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 organizations.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total number of entries to retrieve when using the <code>from</code> parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        sort : typing.Optional[str]
            Field to sort by. Use <code>field:order</code> where order is <code>1</code> for ascending and <code>-1</code> for descending. e.g. <code>created_at:1</code>. We currently support sorting by the following fields: <code>name</code>, <code>display_name</code> and <code>created_at</code>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Organization, ListOrganizationsPaginatedResponseContent]
            Organizations successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.list(
                from_="from",
                take=1,
                sort="sort",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(from_=from_, take=take, sort=sort, request_options=request_options)

    async def create(
        self,
        *,
        name: str = "organization-1",
        display_name: typing.Optional[str] = "Acme Users",
        branding: typing.Optional[OrganizationBranding] = OMIT,
        metadata: typing.Optional[OrganizationMetadata] = OMIT,
        enabled_connections: typing.Optional[typing.Sequence[ConnectionForOrganization]] = OMIT,
        token_quota: typing.Optional[CreateTokenQuota] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationResponseContent:
        """
        Create a new Organization within your tenant.  To learn more about Organization settings, behavior, and configuration options, review <a href="https://auth0.com/docs/manage-users/organizations/create-first-organization">Create Your First Organization</a>.

        Parameters
        ----------
        name : str
            The name of this organization.

        display_name : typing.Optional[str]
            Friendly name of this organization.

        branding : typing.Optional[OrganizationBranding]

        metadata : typing.Optional[OrganizationMetadata]

        enabled_connections : typing.Optional[typing.Sequence[ConnectionForOrganization]]
            Connections that will be enabled for this organization. See POST enabled_connections endpoint for the object format. (Max of 10 connections allowed)

        token_quota : typing.Optional[CreateTokenQuota]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationResponseContent
            Organization successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            display_name=display_name,
            branding=branding,
            metadata=metadata,
            enabled_connections=enabled_connections,
            token_quota=token_quota,
            request_options=request_options,
        )
        return _response.data

    async def get_by_name(
        self, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationByNameResponseContent:
        """
        Retrieve details about a single Organization specified by name.

        Parameters
        ----------
        name : str
            name of the organization to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationByNameResponseContent
            Organization successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.get_by_name(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_name(name, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationResponseContent:
        """
        Retrieve details about a single Organization specified by ID.

        Parameters
        ----------
        id : str
            ID of the organization to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationResponseContent
            Organization successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove an Organization from your tenant.  This action cannot be undone.

        <b>Note</b>: Members are automatically disassociated from an Organization when it is deleted. However, this action does <b>not</b> delete these users from your tenant.

        Parameters
        ----------
        id : str
            Organization identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        display_name: typing.Optional[str] = "Acme Users",
        name: typing.Optional[str] = "organization-1",
        branding: typing.Optional[OrganizationBranding] = OMIT,
        metadata: typing.Optional[OrganizationMetadata] = OMIT,
        token_quota: typing.Optional[UpdateTokenQuota] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationResponseContent:
        """
        Update the details of a specific <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/create-organizations">Organization</a>, such as name and display name, branding options, and metadata.

        Parameters
        ----------
        id : str
            ID of the organization to update.

        display_name : typing.Optional[str]
            Friendly name of this organization.

        name : typing.Optional[str]
            The name of this organization.

        branding : typing.Optional[OrganizationBranding]

        metadata : typing.Optional[OrganizationMetadata]

        token_quota : typing.Optional[UpdateTokenQuota]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationResponseContent
            Organization successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            display_name=display_name,
            name=name,
            branding=branding,
            metadata=metadata,
            token_quota=token_quota,
            request_options=request_options,
        )
        return _response.data

    @property
    def client_grants(self):
        if self._client_grants is None:
            from .client_grants.client import AsyncClientGrantsClient  # noqa: E402

            self._client_grants = AsyncClientGrantsClient(client_wrapper=self._client_wrapper)
        return self._client_grants

    @property
    def discovery_domains(self):
        if self._discovery_domains is None:
            from .discovery_domains.client import AsyncDiscoveryDomainsClient  # noqa: E402

            self._discovery_domains = AsyncDiscoveryDomainsClient(client_wrapper=self._client_wrapper)
        return self._discovery_domains

    @property
    def enabled_connections(self):
        if self._enabled_connections is None:
            from .enabled_connections.client import AsyncEnabledConnectionsClient  # noqa: E402

            self._enabled_connections = AsyncEnabledConnectionsClient(client_wrapper=self._client_wrapper)
        return self._enabled_connections

    @property
    def invitations(self):
        if self._invitations is None:
            from .invitations.client import AsyncInvitationsClient  # noqa: E402

            self._invitations = AsyncInvitationsClient(client_wrapper=self._client_wrapper)
        return self._invitations

    @property
    def members(self):
        if self._members is None:
            from .members.client import AsyncMembersClient  # noqa: E402

            self._members = AsyncMembersClient(client_wrapper=self._client_wrapper)
        return self._members
