# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.associate_organization_client_grant_response_content import (
    AssociateOrganizationClientGrantResponseContent,
)
from ...types.list_organization_client_grants_offset_paginated_response_content import (
    ListOrganizationClientGrantsOffsetPaginatedResponseContent,
)
from ...types.organization_client_grant import OrganizationClientGrant
from .raw_client import AsyncRawClientGrantsClient, RawClientGrantsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ClientGrantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawClientGrantsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawClientGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawClientGrantsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        audience: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        grant_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[OrganizationClientGrant, ListOrganizationClientGrantsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        audience : typing.Optional[str]
            Optional filter on audience of the client grant.

        client_id : typing.Optional[str]
            Optional filter on client_id of the client grant.

        grant_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Optional filter on the ID of the client grant. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../client-grants?grant_ids=id1&grant_ids=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[OrganizationClientGrant, ListOrganizationClientGrantsOffsetPaginatedResponseContent]
            Client grants successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.client_grants.list(
            id="id",
            audience="audience",
            client_id="client_id",
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id,
            audience=audience,
            client_id=client_id,
            grant_ids=grant_ids,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            request_options=request_options,
        )

    def create(
        self, id: str, *, grant_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AssociateOrganizationClientGrantResponseContent:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        grant_id : str
            A Client Grant ID to add to the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssociateOrganizationClientGrantResponseContent
            Client Grant successfully associated with Organization.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.client_grants.create(
            id="id",
            grant_id="grant_id",
        )
        """
        _response = self._raw_client.create(id, grant_id=grant_id, request_options=request_options)
        return _response.data

    def delete(self, id: str, grant_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        grant_id : str
            The Client Grant ID to remove from the organization

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.client_grants.delete(
            id="id",
            grant_id="grant_id",
        )
        """
        _response = self._raw_client.delete(id, grant_id, request_options=request_options)
        return _response.data


class AsyncClientGrantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawClientGrantsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawClientGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawClientGrantsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        audience: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        grant_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[OrganizationClientGrant, ListOrganizationClientGrantsOffsetPaginatedResponseContent]:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        audience : typing.Optional[str]
            Optional filter on audience of the client grant.

        client_id : typing.Optional[str]
            Optional filter on client_id of the client grant.

        grant_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Optional filter on the ID of the client grant. Must be URL encoded and may be specified multiple times (max 10).<br /><b>e.g.</b> <i>../client-grants?grant_ids=id1&grant_ids=id2</i>

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[OrganizationClientGrant, ListOrganizationClientGrantsOffsetPaginatedResponseContent]
            Client grants successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.client_grants.list(
                id="id",
                audience="audience",
                client_id="client_id",
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id,
            audience=audience,
            client_id=client_id,
            grant_ids=grant_ids,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            request_options=request_options,
        )

    async def create(
        self, id: str, *, grant_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AssociateOrganizationClientGrantResponseContent:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        grant_id : str
            A Client Grant ID to add to the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AssociateOrganizationClientGrantResponseContent
            Client Grant successfully associated with Organization.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.client_grants.create(
                id="id",
                grant_id="grant_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, grant_id=grant_id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, grant_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        grant_id : str
            The Client Grant ID to remove from the organization

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.client_grants.delete(
                id="id",
                grant_id="grant_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, grant_id, request_options=request_options)
        return _response.data
