# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.create_organization_discovery_domain_response_content import (
    CreateOrganizationDiscoveryDomainResponseContent,
)
from ...types.get_organization_discovery_domain_response_content import GetOrganizationDiscoveryDomainResponseContent
from ...types.list_organization_discovery_domains_response_content import (
    ListOrganizationDiscoveryDomainsResponseContent,
)
from ...types.organization_discovery_domain import OrganizationDiscoveryDomain
from ...types.organization_discovery_domain_status import OrganizationDiscoveryDomainStatus
from ...types.update_organization_discovery_domain_response_content import (
    UpdateOrganizationDiscoveryDomainResponseContent,
)
from .raw_client import AsyncRawDiscoveryDomainsClient, RawDiscoveryDomainsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DiscoveryDomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDiscoveryDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDiscoveryDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDiscoveryDomainsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[OrganizationDiscoveryDomain, ListOrganizationDiscoveryDomainsResponseContent]:
        """
        Retrieve list of all organization discovery domains associated with the specified organization.

        Parameters
        ----------
        id : str
            ID of the organization.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[OrganizationDiscoveryDomain, ListOrganizationDiscoveryDomainsResponseContent]
            Organization discovery domains retrieved successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.discovery_domains.list(
            id="id",
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(id, from_=from_, take=take, request_options=request_options)

    def create(
        self,
        id: str,
        *,
        domain: str,
        status: typing.Optional[OrganizationDiscoveryDomainStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationDiscoveryDomainResponseContent:
        """
        Update the verification status for an organization discovery domain. The <code>status</code> field must be either <code>pending</code> or <code>verified</code>.

        Parameters
        ----------
        id : str
            ID of the organization.

        domain : str
            The domain name to associate with the organization e.g. acme.com.

        status : typing.Optional[OrganizationDiscoveryDomainStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.discovery_domains.create(
            id="id",
            domain="domain",
        )
        """
        _response = self._raw_client.create(id, domain=domain, status=status, request_options=request_options)
        return _response.data

    def get(
        self, id: str, discovery_domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationDiscoveryDomainResponseContent:
        """
        Retrieve details about a single organization discovery domain specified by ID.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.discovery_domains.get(
            id="id",
            discovery_domain_id="discovery_domain_id",
        )
        """
        _response = self._raw_client.get(id, discovery_domain_id, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, discovery_domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove a discovery domain from an organization. This action cannot be undone.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.discovery_domains.delete(
            id="id",
            discovery_domain_id="discovery_domain_id",
        )
        """
        _response = self._raw_client.delete(id, discovery_domain_id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        discovery_domain_id: str,
        *,
        status: typing.Optional[OrganizationDiscoveryDomainStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationDiscoveryDomainResponseContent:
        """
        Update the verification status for an organization discovery domain. The <code>status</code> field must be either <code>pending</code> or <code>verified</code>.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain to update.

        status : typing.Optional[OrganizationDiscoveryDomainStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.discovery_domains.update(
            id="id",
            discovery_domain_id="discovery_domain_id",
        )
        """
        _response = self._raw_client.update(id, discovery_domain_id, status=status, request_options=request_options)
        return _response.data


class AsyncDiscoveryDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDiscoveryDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDiscoveryDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDiscoveryDomainsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[OrganizationDiscoveryDomain, ListOrganizationDiscoveryDomainsResponseContent]:
        """
        Retrieve list of all organization discovery domains associated with the specified organization.

        Parameters
        ----------
        id : str
            ID of the organization.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[OrganizationDiscoveryDomain, ListOrganizationDiscoveryDomainsResponseContent]
            Organization discovery domains retrieved successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.discovery_domains.list(
                id="id",
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(id, from_=from_, take=take, request_options=request_options)

    async def create(
        self,
        id: str,
        *,
        domain: str,
        status: typing.Optional[OrganizationDiscoveryDomainStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationDiscoveryDomainResponseContent:
        """
        Update the verification status for an organization discovery domain. The <code>status</code> field must be either <code>pending</code> or <code>verified</code>.

        Parameters
        ----------
        id : str
            ID of the organization.

        domain : str
            The domain name to associate with the organization e.g. acme.com.

        status : typing.Optional[OrganizationDiscoveryDomainStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.discovery_domains.create(
                id="id",
                domain="domain",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, domain=domain, status=status, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, discovery_domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationDiscoveryDomainResponseContent:
        """
        Retrieve details about a single organization discovery domain specified by ID.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.discovery_domains.get(
                id="id",
                discovery_domain_id="discovery_domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, discovery_domain_id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, discovery_domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove a discovery domain from an organization. This action cannot be undone.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.discovery_domains.delete(
                id="id",
                discovery_domain_id="discovery_domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, discovery_domain_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        discovery_domain_id: str,
        *,
        status: typing.Optional[OrganizationDiscoveryDomainStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationDiscoveryDomainResponseContent:
        """
        Update the verification status for an organization discovery domain. The <code>status</code> field must be either <code>pending</code> or <code>verified</code>.

        Parameters
        ----------
        id : str
            ID of the organization.

        discovery_domain_id : str
            ID of the discovery domain to update.

        status : typing.Optional[OrganizationDiscoveryDomainStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationDiscoveryDomainResponseContent
            Organization discovery domain successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.discovery_domains.update(
                id="id",
                discovery_domain_id="discovery_domain_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, discovery_domain_id, status=status, request_options=request_options
        )
        return _response.data
