# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.add_organization_connection_response_content import AddOrganizationConnectionResponseContent
from ...types.get_organization_connection_response_content import GetOrganizationConnectionResponseContent
from ...types.list_organization_connections_offset_paginated_response_content import (
    ListOrganizationConnectionsOffsetPaginatedResponseContent,
)
from ...types.organization_connection import OrganizationConnection
from ...types.update_organization_connection_response_content import UpdateOrganizationConnectionResponseContent
from .raw_client import AsyncRawEnabledConnectionsClient, RawEnabledConnectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EnabledConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEnabledConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEnabledConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEnabledConnectionsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[OrganizationConnection, ListOrganizationConnectionsOffsetPaginatedResponseContent]:
        """
        Retrieve details about a specific connection currently enabled for an Organization. Information returned includes details such as connection ID, name, strategy, and whether the connection automatically grants membership upon login.

        Parameters
        ----------
        id : str
            Organization identifier.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[OrganizationConnection, ListOrganizationConnectionsOffsetPaginatedResponseContent]
            Connections successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.enabled_connections.list(
            id="id",
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def add(
        self,
        id: str,
        *,
        connection_id: str,
        assign_membership_on_login: typing.Optional[bool] = OMIT,
        is_signup_enabled: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddOrganizationConnectionResponseContent:
        """
        Enable a specific connection for a given Organization. To enable a connection, it must already exist within your tenant; connections cannot be created through this action.

        <a href="https://auth0.com/docs/authenticate/identity-providers">Connections</a> represent the relationship between Auth0 and a source of users. Available types of connections include database, enterprise, and social.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Single connection ID to add to the organization.

        assign_membership_on_login : typing.Optional[bool]
            When true, all users that log in with this connection will be automatically granted membership in the organization. When false, users must be granted membership in the organization before logging in with this connection.

        is_signup_enabled : typing.Optional[bool]
            Determines whether organization signup should be enabled for this organization connection. Only applicable for database connections. Default: false.

        show_as_button : typing.Optional[bool]
            Determines whether a connection should be displayed on this organization’s login prompt. Only applicable for enterprise connections. Default: true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddOrganizationConnectionResponseContent
            Organization connection successfully added.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.enabled_connections.add(
            id="id",
            connection_id="connection_id",
        )
        """
        _response = self._raw_client.add(
            id,
            connection_id=connection_id,
            assign_membership_on_login=assign_membership_on_login,
            is_signup_enabled=is_signup_enabled,
            show_as_button=show_as_button,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationConnectionResponseContent:
        """
        Retrieve details about a specific connection currently enabled for an Organization. Information returned includes details such as connection ID, name, strategy, and whether the connection automatically grants membership upon login.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationConnectionResponseContent
            Connection successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.enabled_connections.get(
            id="id",
            connection_id="connectionId",
        )
        """
        _response = self._raw_client.get(id, connection_id, request_options=request_options)
        return _response.data

    def delete(self, id: str, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Disable a specific connection for an Organization. Once disabled, Organization members can no longer use that connection to authenticate.

        <b>Note</b>: This action does not remove the connection from your tenant.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.enabled_connections.delete(
            id="id",
            connection_id="connectionId",
        )
        """
        _response = self._raw_client.delete(id, connection_id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        connection_id: str,
        *,
        assign_membership_on_login: typing.Optional[bool] = OMIT,
        is_signup_enabled: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationConnectionResponseContent:
        """
        Modify the details of a specific connection currently enabled for an Organization.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        assign_membership_on_login : typing.Optional[bool]
            When true, all users that log in with this connection will be automatically granted membership in the organization. When false, users must be granted membership in the organization before logging in with this connection.

        is_signup_enabled : typing.Optional[bool]
            Determines whether organization signup should be enabled for this organization connection. Only applicable for database connections. Default: false.

        show_as_button : typing.Optional[bool]
            Determines whether a connection should be displayed on this organization’s login prompt. Only applicable for enterprise connections. Default: true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationConnectionResponseContent
            Organization connection successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.enabled_connections.update(
            id="id",
            connection_id="connectionId",
        )
        """
        _response = self._raw_client.update(
            id,
            connection_id,
            assign_membership_on_login=assign_membership_on_login,
            is_signup_enabled=is_signup_enabled,
            show_as_button=show_as_button,
            request_options=request_options,
        )
        return _response.data


class AsyncEnabledConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEnabledConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEnabledConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEnabledConnectionsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[OrganizationConnection, ListOrganizationConnectionsOffsetPaginatedResponseContent]:
        """
        Retrieve details about a specific connection currently enabled for an Organization. Information returned includes details such as connection ID, name, strategy, and whether the connection automatically grants membership upon login.

        Parameters
        ----------
        id : str
            Organization identifier.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[OrganizationConnection, ListOrganizationConnectionsOffsetPaginatedResponseContent]
            Connections successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.enabled_connections.list(
                id="id",
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def add(
        self,
        id: str,
        *,
        connection_id: str,
        assign_membership_on_login: typing.Optional[bool] = OMIT,
        is_signup_enabled: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddOrganizationConnectionResponseContent:
        """
        Enable a specific connection for a given Organization. To enable a connection, it must already exist within your tenant; connections cannot be created through this action.

        <a href="https://auth0.com/docs/authenticate/identity-providers">Connections</a> represent the relationship between Auth0 and a source of users. Available types of connections include database, enterprise, and social.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Single connection ID to add to the organization.

        assign_membership_on_login : typing.Optional[bool]
            When true, all users that log in with this connection will be automatically granted membership in the organization. When false, users must be granted membership in the organization before logging in with this connection.

        is_signup_enabled : typing.Optional[bool]
            Determines whether organization signup should be enabled for this organization connection. Only applicable for database connections. Default: false.

        show_as_button : typing.Optional[bool]
            Determines whether a connection should be displayed on this organization’s login prompt. Only applicable for enterprise connections. Default: true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddOrganizationConnectionResponseContent
            Organization connection successfully added.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.enabled_connections.add(
                id="id",
                connection_id="connection_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add(
            id,
            connection_id=connection_id,
            assign_membership_on_login=assign_membership_on_login,
            is_signup_enabled=is_signup_enabled,
            show_as_button=show_as_button,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOrganizationConnectionResponseContent:
        """
        Retrieve details about a specific connection currently enabled for an Organization. Information returned includes details such as connection ID, name, strategy, and whether the connection automatically grants membership upon login.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationConnectionResponseContent
            Connection successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.enabled_connections.get(
                id="id",
                connection_id="connectionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, connection_id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Disable a specific connection for an Organization. Once disabled, Organization members can no longer use that connection to authenticate.

        <b>Note</b>: This action does not remove the connection from your tenant.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.enabled_connections.delete(
                id="id",
                connection_id="connectionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, connection_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        connection_id: str,
        *,
        assign_membership_on_login: typing.Optional[bool] = OMIT,
        is_signup_enabled: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateOrganizationConnectionResponseContent:
        """
        Modify the details of a specific connection currently enabled for an Organization.

        Parameters
        ----------
        id : str
            Organization identifier.

        connection_id : str
            Connection identifier.

        assign_membership_on_login : typing.Optional[bool]
            When true, all users that log in with this connection will be automatically granted membership in the organization. When false, users must be granted membership in the organization before logging in with this connection.

        is_signup_enabled : typing.Optional[bool]
            Determines whether organization signup should be enabled for this organization connection. Only applicable for database connections. Default: false.

        show_as_button : typing.Optional[bool]
            Determines whether a connection should be displayed on this organization’s login prompt. Only applicable for enterprise connections. Default: true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateOrganizationConnectionResponseContent
            Organization connection successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.enabled_connections.update(
                id="id",
                connection_id="connectionId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            connection_id,
            assign_membership_on_login=assign_membership_on_login,
            is_signup_enabled=is_signup_enabled,
            show_as_button=show_as_button,
            request_options=request_options,
        )
        return _response.data
