# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.app_metadata import AppMetadata
from ...types.create_organization_invitation_response_content import CreateOrganizationInvitationResponseContent
from ...types.get_organization_invitation_response_content import GetOrganizationInvitationResponseContent
from ...types.list_organization_invitations_offset_paginated_response_content import (
    ListOrganizationInvitationsOffsetPaginatedResponseContent,
)
from ...types.organization_invitation import OrganizationInvitation
from ...types.organization_invitation_invitee import OrganizationInvitationInvitee
from ...types.organization_invitation_inviter import OrganizationInvitationInviter
from ...types.user_metadata import UserMetadata
from .raw_client import AsyncRawInvitationsClient, RawInvitationsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InvitationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInvitationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInvitationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInvitationsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[OrganizationInvitation, ListOrganizationInvitationsOffsetPaginatedResponseContent]:
        """
        Retrieve a detailed list of invitations sent to users for a specific Organization. The list includes details such as inviter and invitee information, invitation URLs, and dates of creation and expiration. To learn more about Organization invitations, review <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/invite-members">Invite Organization Members</a>.

        Parameters
        ----------
        id : str
            Organization identifier.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            When true, return results inside an object that also contains the start and limit.  When false (default), a direct array of results is returned.  We do not yet support returning the total invitations count.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        sort : typing.Optional[str]
            Field to sort by. Use field:order where order is 1 for ascending and -1 for descending Defaults to created_at:-1.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[OrganizationInvitation, ListOrganizationInvitationsOffsetPaginatedResponseContent]
            Invitations successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.invitations.list(
            id="id",
            page=1,
            per_page=1,
            include_totals=True,
            fields="fields",
            include_fields=True,
            sort="sort",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            fields=fields,
            include_fields=include_fields,
            sort=sort,
            request_options=request_options,
        )

    def create(
        self,
        id: str,
        *,
        inviter: OrganizationInvitationInviter,
        invitee: OrganizationInvitationInvitee,
        client_id: str = "AaiyAPdpYdesoKnqjj8HJqRn4T5titww",
        connection_id: typing.Optional[str] = "con_0000000000000001",
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        roles: typing.Optional[typing.Sequence[str]] = OMIT,
        send_invitation_email: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationInvitationResponseContent:
        """
        Create a user invitation for a specific Organization. Upon creation, the listed user receives an email inviting them to join the Organization. To learn more about Organization invitations, review <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/invite-members">Invite Organization Members</a>.

        Parameters
        ----------
        id : str
            Organization identifier.

        inviter : OrganizationInvitationInviter

        invitee : OrganizationInvitationInvitee

        client_id : str
            Auth0 client ID. Used to resolve the application's login initiation endpoint.

        connection_id : typing.Optional[str]
            The id of the connection to force invitee to authenticate with.

        app_metadata : typing.Optional[AppMetadata]

        user_metadata : typing.Optional[UserMetadata]

        ttl_sec : typing.Optional[int]
            Number of seconds for which the invitation is valid before expiration. If unspecified or set to 0, this value defaults to 604800 seconds (7 days). Max value: 2592000 seconds (30 days).

        roles : typing.Optional[typing.Sequence[str]]
            List of roles IDs to associated with the user.

        send_invitation_email : typing.Optional[bool]
            Whether the user will receive an invitation email (true) or no email (false), true by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationInvitationResponseContent
            Invitation successfully created.

        Examples
        --------
        from auth0 import (
            Auth0,
            OrganizationInvitationInvitee,
            OrganizationInvitationInviter,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.invitations.create(
            id="id",
            inviter=OrganizationInvitationInviter(
                name="name",
            ),
            invitee=OrganizationInvitationInvitee(
                email="email",
            ),
            client_id="client_id",
        )
        """
        _response = self._raw_client.create(
            id,
            inviter=inviter,
            invitee=invitee,
            client_id=client_id,
            connection_id=connection_id,
            app_metadata=app_metadata,
            user_metadata=user_metadata,
            ttl_sec=ttl_sec,
            roles=roles,
            send_invitation_email=send_invitation_email,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        invitation_id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOrganizationInvitationResponseContent:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        invitation_id : str
            The id of the user invitation.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationInvitationResponseContent
            Invitation successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.invitations.get(
            id="id",
            invitation_id="invitation_id",
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(
            id, invitation_id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        invitation_id : str
            The id of the user invitation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.invitations.delete(
            id="id",
            invitation_id="invitation_id",
        )
        """
        _response = self._raw_client.delete(id, invitation_id, request_options=request_options)
        return _response.data


class AsyncInvitationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInvitationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInvitationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInvitationsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[OrganizationInvitation, ListOrganizationInvitationsOffsetPaginatedResponseContent]:
        """
        Retrieve a detailed list of invitations sent to users for a specific Organization. The list includes details such as inviter and invitee information, invitation URLs, and dates of creation and expiration. To learn more about Organization invitations, review <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/invite-members">Invite Organization Members</a>.

        Parameters
        ----------
        id : str
            Organization identifier.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            When true, return results inside an object that also contains the start and limit.  When false (default), a direct array of results is returned.  We do not yet support returning the total invitations count.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        sort : typing.Optional[str]
            Field to sort by. Use field:order where order is 1 for ascending and -1 for descending Defaults to created_at:-1.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[OrganizationInvitation, ListOrganizationInvitationsOffsetPaginatedResponseContent]
            Invitations successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.invitations.list(
                id="id",
                page=1,
                per_page=1,
                include_totals=True,
                fields="fields",
                include_fields=True,
                sort="sort",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id,
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            fields=fields,
            include_fields=include_fields,
            sort=sort,
            request_options=request_options,
        )

    async def create(
        self,
        id: str,
        *,
        inviter: OrganizationInvitationInviter,
        invitee: OrganizationInvitationInvitee,
        client_id: str = "AaiyAPdpYdesoKnqjj8HJqRn4T5titww",
        connection_id: typing.Optional[str] = "con_0000000000000001",
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        ttl_sec: typing.Optional[int] = OMIT,
        roles: typing.Optional[typing.Sequence[str]] = OMIT,
        send_invitation_email: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateOrganizationInvitationResponseContent:
        """
        Create a user invitation for a specific Organization. Upon creation, the listed user receives an email inviting them to join the Organization. To learn more about Organization invitations, review <a href="https://auth0.com/docs/manage-users/organizations/configure-organizations/invite-members">Invite Organization Members</a>.

        Parameters
        ----------
        id : str
            Organization identifier.

        inviter : OrganizationInvitationInviter

        invitee : OrganizationInvitationInvitee

        client_id : str
            Auth0 client ID. Used to resolve the application's login initiation endpoint.

        connection_id : typing.Optional[str]
            The id of the connection to force invitee to authenticate with.

        app_metadata : typing.Optional[AppMetadata]

        user_metadata : typing.Optional[UserMetadata]

        ttl_sec : typing.Optional[int]
            Number of seconds for which the invitation is valid before expiration. If unspecified or set to 0, this value defaults to 604800 seconds (7 days). Max value: 2592000 seconds (30 days).

        roles : typing.Optional[typing.Sequence[str]]
            List of roles IDs to associated with the user.

        send_invitation_email : typing.Optional[bool]
            Whether the user will receive an invitation email (true) or no email (false), true by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateOrganizationInvitationResponseContent
            Invitation successfully created.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            OrganizationInvitationInvitee,
            OrganizationInvitationInviter,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.invitations.create(
                id="id",
                inviter=OrganizationInvitationInviter(
                    name="name",
                ),
                invitee=OrganizationInvitationInvitee(
                    email="email",
                ),
                client_id="client_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id,
            inviter=inviter,
            invitee=invitee,
            client_id=client_id,
            connection_id=connection_id,
            app_metadata=app_metadata,
            user_metadata=user_metadata,
            ttl_sec=ttl_sec,
            roles=roles,
            send_invitation_email=send_invitation_email,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        invitation_id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOrganizationInvitationResponseContent:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        invitation_id : str
            The id of the user invitation.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOrganizationInvitationResponseContent
            Invitation successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.invitations.get(
                id="id",
                invitation_id="invitation_id",
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            id, invitation_id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def delete(
        self, id: str, invitation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        id : str
            Organization identifier.

        invitation_id : str
            The id of the user invitation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.invitations.delete(
                id="id",
                invitation_id="invitation_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, invitation_id, request_options=request_options)
        return _response.data
