# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.pagination import AsyncPager, SyncPager
from ....core.request_options import RequestOptions
from ....types.list_organization_member_roles_offset_paginated_response_content import (
    ListOrganizationMemberRolesOffsetPaginatedResponseContent,
)
from ....types.role import Role
from .raw_client import AsyncRawRolesClient, RawRolesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RolesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRolesClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        user_id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Role, ListOrganizationMemberRolesOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of roles assigned to a given user within the context of a specific Organization.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action only returns the roles associated with the specified Organization; any roles assigned to the user within other Organizations are not included.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            ID of the user to associate roles with.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Role, ListOrganizationMemberRolesOffsetPaginatedResponseContent]
            Roles successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.organizations.members.roles.list(
            id="id",
            user_id="user_id",
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id, user_id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def assign(
        self,
        id: str,
        user_id: str,
        *,
        roles: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Assign one or more <a href="https://auth0.com/docs/manage-users/access-control/rbac">roles</a> to a user to determine their access for a specific Organization.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action assigns roles to a user only for the specified Organization. Roles cannot be assigned to a user across multiple Organizations in the same call.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            ID of the user to associate roles with.

        roles : typing.Sequence[str]
            List of roles IDs to associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.members.roles.assign(
            id="id",
            user_id="user_id",
            roles=["roles"],
        )
        """
        _response = self._raw_client.assign(id, user_id, roles=roles, request_options=request_options)
        return _response.data

    def delete(
        self,
        id: str,
        user_id: str,
        *,
        roles: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Remove one or more Organization-specific <a href="https://auth0.com/docs/manage-users/access-control/rbac">roles</a> from a given user.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action removes roles from a user in relation to the specified Organization. Roles assigned to the user within a different Organization cannot be managed in the same call.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            User ID of the organization member to remove roles from.

        roles : typing.Sequence[str]
            List of roles IDs associated with the organization member to remove.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.organizations.members.roles.delete(
            id="id",
            user_id="user_id",
            roles=["roles"],
        )
        """
        _response = self._raw_client.delete(id, user_id, roles=roles, request_options=request_options)
        return _response.data


class AsyncRolesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRolesClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        user_id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Role, ListOrganizationMemberRolesOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of roles assigned to a given user within the context of a specific Organization.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action only returns the roles associated with the specified Organization; any roles assigned to the user within other Organizations are not included.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            ID of the user to associate roles with.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Defaults to 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Role, ListOrganizationMemberRolesOffsetPaginatedResponseContent]
            Roles successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.organizations.members.roles.list(
                id="id",
                user_id="user_id",
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id, user_id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def assign(
        self,
        id: str,
        user_id: str,
        *,
        roles: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Assign one or more <a href="https://auth0.com/docs/manage-users/access-control/rbac">roles</a> to a user to determine their access for a specific Organization.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action assigns roles to a user only for the specified Organization. Roles cannot be assigned to a user across multiple Organizations in the same call.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            ID of the user to associate roles with.

        roles : typing.Sequence[str]
            List of roles IDs to associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.members.roles.assign(
                id="id",
                user_id="user_id",
                roles=["roles"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.assign(id, user_id, roles=roles, request_options=request_options)
        return _response.data

    async def delete(
        self,
        id: str,
        user_id: str,
        *,
        roles: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Remove one or more Organization-specific <a href="https://auth0.com/docs/manage-users/access-control/rbac">roles</a> from a given user.

        Users can be members of multiple Organizations with unique roles assigned for each membership. This action removes roles from a user in relation to the specified Organization. Roles assigned to the user within a different Organization cannot be managed in the same call.

        Parameters
        ----------
        id : str
            Organization identifier.

        user_id : str
            User ID of the organization member to remove roles from.

        roles : typing.Sequence[str]
            List of roles IDs associated with the organization member to remove.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.organizations.members.roles.delete(
                id="id",
                user_id="user_id",
                roles=["roles"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, user_id, roles=roles, request_options=request_options)
        return _response.data
