# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_settings_response_content import GetSettingsResponseContent
from ..types.universal_login_experience_enum import UniversalLoginExperienceEnum
from ..types.update_settings_response_content import UpdateSettingsResponseContent
from .raw_client import AsyncRawPromptsClient, RawPromptsClient

if typing.TYPE_CHECKING:
    from .custom_text.client import AsyncCustomTextClient, CustomTextClient
    from .partials.client import AsyncPartialsClient, PartialsClient
    from .rendering.client import AsyncRenderingClient, RenderingClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._rendering: typing.Optional[RenderingClient] = None
        self._custom_text: typing.Optional[CustomTextClient] = None
        self._partials: typing.Optional[PartialsClient] = None

    @property
    def with_raw_response(self) -> RawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptsClient
        """
        return self._raw_client

    def get_settings(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetSettingsResponseContent:
        """
        Retrieve details of the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSettingsResponseContent
            Prompt settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.get_settings()
        """
        _response = self._raw_client.get_settings(request_options=request_options)
        return _response.data

    def update_settings(
        self,
        *,
        universal_login_experience: typing.Optional[UniversalLoginExperienceEnum] = OMIT,
        identifier_first: typing.Optional[bool] = OMIT,
        webauthn_platform_first_factor: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSettingsResponseContent:
        """
        Update the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.

        Parameters
        ----------
        universal_login_experience : typing.Optional[UniversalLoginExperienceEnum]

        identifier_first : typing.Optional[bool]
            Whether identifier first is enabled or not

        webauthn_platform_first_factor : typing.Optional[bool]
            Use WebAuthn with Device Biometrics as the first authentication factor

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSettingsResponseContent
            Prompts settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.prompts.update_settings()
        """
        _response = self._raw_client.update_settings(
            universal_login_experience=universal_login_experience,
            identifier_first=identifier_first,
            webauthn_platform_first_factor=webauthn_platform_first_factor,
            request_options=request_options,
        )
        return _response.data

    @property
    def rendering(self):
        if self._rendering is None:
            from .rendering.client import RenderingClient  # noqa: E402

            self._rendering = RenderingClient(client_wrapper=self._client_wrapper)
        return self._rendering

    @property
    def custom_text(self):
        if self._custom_text is None:
            from .custom_text.client import CustomTextClient  # noqa: E402

            self._custom_text = CustomTextClient(client_wrapper=self._client_wrapper)
        return self._custom_text

    @property
    def partials(self):
        if self._partials is None:
            from .partials.client import PartialsClient  # noqa: E402

            self._partials = PartialsClient(client_wrapper=self._client_wrapper)
        return self._partials


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._rendering: typing.Optional[AsyncRenderingClient] = None
        self._custom_text: typing.Optional[AsyncCustomTextClient] = None
        self._partials: typing.Optional[AsyncPartialsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptsClient
        """
        return self._raw_client

    async def get_settings(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSettingsResponseContent:
        """
        Retrieve details of the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSettingsResponseContent
            Prompt settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.get_settings()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_settings(request_options=request_options)
        return _response.data

    async def update_settings(
        self,
        *,
        universal_login_experience: typing.Optional[UniversalLoginExperienceEnum] = OMIT,
        identifier_first: typing.Optional[bool] = OMIT,
        webauthn_platform_first_factor: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSettingsResponseContent:
        """
        Update the Universal Login configuration of your tenant. This includes the <a href="https://auth0.com/docs/authenticate/login/auth0-universal-login/identifier-first">Identifier First Authentication</a> and <a href="https://auth0.com/docs/secure/multi-factor-authentication/fido-authentication-with-webauthn/configure-webauthn-device-biometrics-for-mfa">WebAuthn with Device Biometrics for MFA</a> features.

        Parameters
        ----------
        universal_login_experience : typing.Optional[UniversalLoginExperienceEnum]

        identifier_first : typing.Optional[bool]
            Whether identifier first is enabled or not

        webauthn_platform_first_factor : typing.Optional[bool]
            Use WebAuthn with Device Biometrics as the first authentication factor

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSettingsResponseContent
            Prompts settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.prompts.update_settings()


        asyncio.run(main())
        """
        _response = await self._raw_client.update_settings(
            universal_login_experience=universal_login_experience,
            identifier_first=identifier_first,
            webauthn_platform_first_factor=webauthn_platform_first_factor,
            request_options=request_options,
        )
        return _response.data

    @property
    def rendering(self):
        if self._rendering is None:
            from .rendering.client import AsyncRenderingClient  # noqa: E402

            self._rendering = AsyncRenderingClient(client_wrapper=self._client_wrapper)
        return self._rendering

    @property
    def custom_text(self):
        if self._custom_text is None:
            from .custom_text.client import AsyncCustomTextClient  # noqa: E402

            self._custom_text = AsyncCustomTextClient(client_wrapper=self._client_wrapper)
        return self._custom_text

    @property
    def partials(self):
        if self._partials is None:
            from .partials.client import AsyncPartialsClient  # noqa: E402

            self._partials = AsyncPartialsClient(client_wrapper=self._client_wrapper)
        return self._partials
